package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbManagedApplicationGroup extends AbstractUdbEntity<ManagedApplicationGroup> implements ManagedApplicationGroup {
	protected static TableIndex table;
	protected static UniversalDB universalDB;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static TextIndex icon;
	protected static TextIndex name;
	protected static TextIndex titleKey;
	protected static MultiReferenceIndex applications;
	protected static IntegerIndex listingPosition;

    private static void setTableIndex(TableIndex tableIndex, UniversalDB udb) {
		universalDB = udb;
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_RESTORED_BY);
		icon = (TextIndex) tableIndex.getFieldIndex(FIELD_ICON);
		name = (TextIndex) tableIndex.getFieldIndex(FIELD_NAME);
		titleKey = (TextIndex) tableIndex.getFieldIndex(FIELD_TITLE_KEY);
		applications = (MultiReferenceIndex) tableIndex.getFieldIndex(FIELD_APPLICATIONS);
		listingPosition = (IntegerIndex) tableIndex.getFieldIndex(FIELD_LISTING_POSITION);
    }

    public static List<ManagedApplicationGroup> getAll() {
        return new EntityBitSetList<>(ManagedApplicationGroup.getBuilder(), table.getRecordBitSet());
    }

    public static List<ManagedApplicationGroup> getDeletedRecords() {
        return new EntityBitSetList<>(ManagedApplicationGroup.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<ManagedApplicationGroup> sort(List<ManagedApplicationGroup> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<ManagedApplicationGroup> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, ManagedApplicationGroup.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbManagedApplicationGroup() {
        super(table);
    }

    public UdbManagedApplicationGroup(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public ManagedApplicationGroup build() {
        return new UdbManagedApplicationGroup();
    }

    @Override
    public ManagedApplicationGroup build(int id) {
        return new UdbManagedApplicationGroup(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public ManagedApplicationGroup setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public ManagedApplicationGroup setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public ManagedApplicationGroup setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public ManagedApplicationGroup setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public ManagedApplicationGroup setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public ManagedApplicationGroup setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public ManagedApplicationGroup setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public ManagedApplicationGroup setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public ManagedApplicationGroup setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public ManagedApplicationGroup setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public ManagedApplicationGroup setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public ManagedApplicationGroup setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public ManagedApplicationGroup setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public ManagedApplicationGroup setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public ManagedApplicationGroup setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public ManagedApplicationGroup setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public String getIcon() {
        return getTextValue(icon);
	}

	@Override
	public ManagedApplicationGroup setIcon(String value) {
	    setTextValue(value, this.icon);
		return this;
	}

	@Override
	public String getName() {
        return getTextValue(name);
	}

	@Override
	public ManagedApplicationGroup setName(String value) {
	    setTextValue(value, this.name);
		return this;
	}

	@Override
	public String getTitleKey() {
        return getTextValue(titleKey);
	}

	@Override
	public ManagedApplicationGroup setTitleKey(String value) {
	    setTextValue(value, this.titleKey);
		return this;
	}

	@Override
	public List<ManagedApplication> getApplications() {
	    return getMultiReferenceValue(applications, ManagedApplication.getBuilder());
	}

	@Override
	public ManagedApplicationGroup setApplications(List<ManagedApplication> value) {
		setMultiReferenceValue(value, applications);
		return this;
	}

	@Override
	public int getApplicationsCount() {
	    return getMultiReferenceValueCount(applications, ManagedApplication.getBuilder());
	}

	@Override
	public ManagedApplicationGroup setApplications(ManagedApplication ... value) {
		setMultiReferenceValue(Arrays.asList(value), applications);
		return this;
	}

	@Override
	public BitSet getApplicationsAsBitSet() {
	    return getMultiReferenceValueAsBitSet(applications, ManagedApplication.getBuilder());
	}

	@Override
	public ManagedApplicationGroup addApplications(List<ManagedApplication> value) {
		addMultiReferenceValue(value, applications);
		return this;
	}

	@Override
	public ManagedApplicationGroup addApplications(ManagedApplication ... value) {
		addMultiReferenceValue(Arrays.asList(value), applications);
		return this;
	}

	@Override
	public ManagedApplicationGroup removeApplications(List<ManagedApplication> value) {
		removeMultiReferenceValue(value, applications);
		return this;
	}

	@Override
	public ManagedApplicationGroup removeApplications(ManagedApplication ... value) {
		removeMultiReferenceValue(Arrays.asList(value), applications);
		return this;
	}

	@Override
	public ManagedApplicationGroup removeAllApplications() {
		removeAllMultiReferenceValue(applications);
		return this;
	}

	@Override
	public int getListingPosition() {
        return getIntValue(listingPosition);
	}

	@Override
	public ManagedApplicationGroup setListingPosition(int value) {
	    setIntValue(value, this.listingPosition);
		return this;
	}



    @Override
    public UdbManagedApplicationGroup save() {
        saveRecord(universalDB);
        return this;
    }

   @Override
    public UdbManagedApplicationGroup save(int userId, long timestamp) {
        saveRecord(universalDB, userId, timestamp);
        return this;
    }

    @Override
    public void delete() {
        deleteRecord(universalDB);
    }

    @Override
    public void delete(int userId, long timestamp) {
        deleteRecord(universalDB, userId, timestamp);
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord(universalDB);
    }

    @Override
    public void restoreDeleted(int userId, long timestamp) {
        restoreDeletedRecord(universalDB, userId, timestamp);
    }
}



