package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;
import org.teamapps.universaldb.index.transaction.request.*;


import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbOrganizationFieldView extends AbstractUdbEntity<OrganizationFieldView> implements OrganizationFieldView {
	protected static TableIndex table;
	protected static UniversalDB universalDB;
	protected static TranslatableTextIndex title;
	protected static TextIndex icon;

    private static void setTableIndex(TableIndex tableIndex, UniversalDB udb) {
		universalDB = udb;
        table = tableIndex;
		title = (TranslatableTextIndex) tableIndex.getFieldIndex(FIELD_TITLE);
		icon = (TextIndex) tableIndex.getFieldIndex(FIELD_ICON);
    }

    public static List<OrganizationFieldView> getAll() {
        return new EntityBitSetList<>(OrganizationFieldView.getBuilder(), table.getRecordBitSet());
    }

    public static List<OrganizationFieldView> sort(List<OrganizationFieldView> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<OrganizationFieldView> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, OrganizationFieldView.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbOrganizationFieldView() {
        super(table);
    }

    public UdbOrganizationFieldView(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public OrganizationFieldView build() {
        return new UdbOrganizationFieldView();
    }

    @Override
    public OrganizationFieldView build(int id) {
        return new UdbOrganizationFieldView(id, false);
    }

	@Override
	public TranslatableText getTitle() {
	    return getTranslatableTextValue(this.title);
	}

	@Override
	public String getIcon() {
        return getTextValue(icon);
	}



    @Override
    public UdbOrganizationFieldView save() {
    	throw new UnsupportedOperationException();
    }

    @Override
    public void delete() {
    	throw new UnsupportedOperationException();
    }

    @Override
    public void restoreDeleted() {
    	throw new UnsupportedOperationException();
    }

    @Override
    public UdbOrganizationFieldView save(int userId, long timestamp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(int userId, long timestamp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void restoreDeleted(int userId, long timestamp) {
        throw new UnsupportedOperationException();
    }

}



