package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbUserLanguageSettingsQuery extends AbstractUdbQuery<UserLanguageSettings> implements UserLanguageSettingsQuery {

    public UdbUserLanguageSettingsQuery() {
        super(UdbUserLanguageSettings.table, UserLanguageSettings.getBuilder());
    }

    @Override
    public UserLanguageSettingsQuery id(Integer... ids) {
        return id(Arrays.asList(ids));
    }

    @Override
    public UserLanguageSettingsQuery id(BitSet ids) {
        filterById(ids);
        return this;
    }

    @Override
    public UserLanguageSettingsQuery id(Collection<Integer> ids) {
        filterById(ids);
        return this;
    }

	@Override
	public UserLanguageSettingsQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbUserLanguageSettings.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public UserLanguageSettingsQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbUserLanguageSettings.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public UserLanguageSettingsQuery metaCreationDate(NumericFilter filter) {
		and(UdbUserLanguageSettings.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserLanguageSettingsQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbUserLanguageSettings.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserLanguageSettingsQuery metaCreatedBy(NumericFilter filter) {
		and(UdbUserLanguageSettings.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserLanguageSettingsQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbUserLanguageSettings.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserLanguageSettingsQuery metaModificationDate(NumericFilter filter) {
		and(UdbUserLanguageSettings.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserLanguageSettingsQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbUserLanguageSettings.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserLanguageSettingsQuery metaModifiedBy(NumericFilter filter) {
		and(UdbUserLanguageSettings.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserLanguageSettingsQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbUserLanguageSettings.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserLanguageSettingsQuery metaDeletionDate(NumericFilter filter) {
		and(UdbUserLanguageSettings.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public UserLanguageSettingsQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbUserLanguageSettings.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public UserLanguageSettingsQuery metaDeletedBy(NumericFilter filter) {
		and(UdbUserLanguageSettings.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserLanguageSettingsQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbUserLanguageSettings.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserLanguageSettingsQuery metaRestoreDate(NumericFilter filter) {
		and(UdbUserLanguageSettings.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public UserLanguageSettingsQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbUserLanguageSettings.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public UserLanguageSettingsQuery metaRestoredBy(NumericFilter filter) {
		and(UdbUserLanguageSettings.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public UserLanguageSettingsQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbUserLanguageSettings.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public UserLanguageSettingsQuery language(TextFilter filter) {
		and(UdbUserLanguageSettings.language.createFilter(filter));
		return this;
	}

	@Override
	public UserLanguageSettingsQuery orLanguage(TextFilter filter) {
		or(UdbUserLanguageSettings.language.createFilter(filter));
		return this;
	}

	@Override
	public UserLanguageSettingsQuery languageSkillLevel(EnumFilterType filterType, LanguageSkillLevel... enums) {
		and(UdbUserLanguageSettings.languageSkillLevel.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public UserLanguageSettingsQuery orLanguageSkillLevel(EnumFilterType filterType, LanguageSkillLevel... enums) {
		or(UdbUserLanguageSettings.languageSkillLevel.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}


	@Override
	public UdbUserLanguageSettingsQuery andOr(UserLanguageSettingsQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public UserLanguageSettingsQuery customFilter(Function<UserLanguageSettings, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(UserLanguageSettings.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



