package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.context.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface UserLoginStats extends Entity<UserLoginStats> {

	final static String FIELD_USER = "user";
	final static String FIELD_FIRST_LOGIN = "firstLogin";
	final static String FIELD_LAST_LOGIN = "lastLogin";
	final static String FIELD_LOGIN_COUNT = "loginCount";
	final static String FIELD_LAST_LOGIN_IP_ADDRESS = "lastLoginIpAddress";
	final static String FIELD_WRONG_PASSWORD_TIMESTAMP = "wrongPasswordTimestamp";
	final static String FIELD_WRONG_PASSWORD_IP_ADDRESS = "wrongPasswordIpAddress";
	final static String FIELD_WRONG_PASSWORD_COUNT = "wrongPasswordCount";

    static UserLoginStats create() {
        return new UdbUserLoginStats();
    }

    static UserLoginStats create(int id) {
        return new UdbUserLoginStats(id, true);
    }

    static UserLoginStats getById(int id) {
        return new UdbUserLoginStats(id, false);
    }

    static EntityBuilder<UserLoginStats> getBuilder() {
        return new UdbUserLoginStats(0, false);
    }

    User getUser();

    UserLoginStats setUser(User value);

    Instant getFirstLogin();

    UserLoginStats setFirstLogin(Instant value);

    int getFirstLoginAsEpochSecond();

    UserLoginStats setFirstLoginAsEpochSecond(int value);

    long getFirstLoginAsEpochMilli();

    UserLoginStats setFirstLoginAsEpochMilli(long value);

    Instant getLastLogin();

    UserLoginStats setLastLogin(Instant value);

    int getLastLoginAsEpochSecond();

    UserLoginStats setLastLoginAsEpochSecond(int value);

    long getLastLoginAsEpochMilli();

    UserLoginStats setLastLoginAsEpochMilli(long value);

    int getLoginCount();

    UserLoginStats setLoginCount(int value);

    String getLastLoginIpAddress();

    UserLoginStats setLastLoginIpAddress(String value);

    Instant getWrongPasswordTimestamp();

    UserLoginStats setWrongPasswordTimestamp(Instant value);

    int getWrongPasswordTimestampAsEpochSecond();

    UserLoginStats setWrongPasswordTimestampAsEpochSecond(int value);

    long getWrongPasswordTimestampAsEpochMilli();

    UserLoginStats setWrongPasswordTimestampAsEpochMilli(long value);

    String getWrongPasswordIpAddress();

    UserLoginStats setWrongPasswordIpAddress(String value);

    int getWrongPasswordCount();

    UserLoginStats setWrongPasswordCount(int value);


    static List<UserLoginStats> getAll() {
        return UdbUserLoginStats.getAll();
    }

    static List<UserLoginStats> getDeletedRecords() {
        return UdbUserLoginStats.getDeletedRecords();
    }

    static List<UserLoginStats> sort(List<UserLoginStats> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbUserLoginStats.sort(list, sortFieldName, ascending, userContext, path);
    }

    static int getCount() {
        return UdbUserLoginStats.getCount();
    }

    static UserLoginStatsQuery filter() {
        return new UdbUserLoginStatsQuery();
    }
}

