package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;


public interface UserLoginStatsQuery extends Query<UserLoginStats> {

    static UserLoginStatsQuery create() {
        return new UdbUserLoginStatsQuery();
    }

    UserLoginStatsQuery id(Integer... ids);

    UserLoginStatsQuery id(BitSet ids);

    UserLoginStatsQuery id(Collection<Integer> ids);

    UserLoginStatsQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    UserLoginStatsQuery parseFullTextFilter(String query, String... fieldNames);

	UserLoginStatsQuery filterUser(UserQuery query);

	UserLoginStatsQuery user(NumericFilter filter);

	UserLoginStatsQuery orUser(NumericFilter filter);

	UserLoginStatsQuery firstLogin(NumericFilter filter);

	UserLoginStatsQuery orFirstLogin(NumericFilter filter);

	UserLoginStatsQuery lastLogin(NumericFilter filter);

	UserLoginStatsQuery orLastLogin(NumericFilter filter);

	UserLoginStatsQuery loginCount(NumericFilter filter);

	UserLoginStatsQuery orLoginCount(NumericFilter filter);

	UserLoginStatsQuery lastLoginIpAddress(TextFilter filter);

	UserLoginStatsQuery orLastLoginIpAddress(TextFilter filter);

	UserLoginStatsQuery wrongPasswordTimestamp(NumericFilter filter);

	UserLoginStatsQuery orWrongPasswordTimestamp(NumericFilter filter);

	UserLoginStatsQuery wrongPasswordIpAddress(TextFilter filter);

	UserLoginStatsQuery orWrongPasswordIpAddress(TextFilter filter);

	UserLoginStatsQuery wrongPasswordCount(NumericFilter filter);

	UserLoginStatsQuery orWrongPasswordCount(NumericFilter filter);


    UserLoginStatsQuery andOr(UserLoginStatsQuery... queries);

    UserLoginStatsQuery customFilter(Function<UserLoginStats, Boolean> customFilter);

}

