package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.context.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface Role extends Entity<Role> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_TITLE = "title";
	final static String FIELD_ICON = "icon";
	final static String FIELD_ROLE_TYPE = "roleType";
	final static String FIELD_PARENT = "parent";
	final static String FIELD_CHILDREN = "children";
	final static String FIELD_ORGANIZATION_UNIT = "organizationUnit";
	final static String FIELD_ALLOWED_ORGANIZATION_UNIT_TYPES = "allowedOrganizationUnitTypes";
	final static String FIELD_ORGANIZATION_FIELD = "organizationField";
	final static String FIELD_DELEGATED_CUSTOM_PRIVILEGE_OBJECT_ROLE = "delegatedCustomPrivilegeObjectRole";
	final static String FIELD_GENERALIZATION_ROLES = "generalizationRoles";
	final static String FIELD_SPECIALIZATION_ROLES = "specializationRoles";
	final static String FIELD_PRIVILEGES_RECEIVING_ROLES = "privilegesReceivingRoles";
	final static String FIELD_PRIVILEGES_SENDING_ROLES = "privilegesSendingRoles";
	final static String FIELD_NO_DIRECT_MEMBERSHIPS = "noDirectMemberships";
	final static String FIELD_USER_ROLE_ASSIGNMENTS = "userRoleAssignments";
	final static String FIELD_PRIVILEGE_ASSIGNMENTS = "privilegeAssignments";
	final static String FIELD_APPLICATION_ROLE_ASSIGNMENTS = "applicationRoleAssignments";
	final static String FIELD_PROTECTED_ASSIGNMENTS = "protectedAssignments";
	final static String FIELD_TWO_FACTOR_AUTH_REQUIRED = "twoFactorAuthRequired";

    static Role create() {
        return new UdbRole();
    }

    static Role create(int id) {
        return new UdbRole(id, true);
    }

    static Role getById(int id) {
        return new UdbRole(id, false);
    }

    static EntityBuilder<Role> getBuilder() {
        return new UdbRole(0, false);
    }

    Instant getMetaCreationDate();

    Role setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    Role setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    Role setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    Role setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    Role setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    Role setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    Role setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    Role setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    Role setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    Role setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    Role setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    Role setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    Role setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    Role setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    Role setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    Role setMetaRestoredBy(int value);

    TranslatableText getTitle();

    Role setTitle(TranslatableText value);

    String getIcon();

    Role setIcon(String value);

    RoleType getRoleType();

    Role setRoleType(RoleType value);

    Role getParent();

    Role setParent(Role value);

    List<Role> getChildren();

    Role setChildren(List<Role> value);

    int getChildrenCount();

    Role setChildren(Role ... value);

    BitSet getChildrenAsBitSet();

    Role addChildren(List<Role> value);

    Role addChildren(Role ... value);

    Role removeChildren(List<Role> value);

    Role removeChildren(Role ... value);

    Role removeAllChildren();

    OrganizationUnit getOrganizationUnit();

    Role setOrganizationUnit(OrganizationUnit value);

    List<OrganizationUnitType> getAllowedOrganizationUnitTypes();

    Role setAllowedOrganizationUnitTypes(List<OrganizationUnitType> value);

    int getAllowedOrganizationUnitTypesCount();

    Role setAllowedOrganizationUnitTypes(OrganizationUnitType ... value);

    BitSet getAllowedOrganizationUnitTypesAsBitSet();

    Role addAllowedOrganizationUnitTypes(List<OrganizationUnitType> value);

    Role addAllowedOrganizationUnitTypes(OrganizationUnitType ... value);

    Role removeAllowedOrganizationUnitTypes(List<OrganizationUnitType> value);

    Role removeAllowedOrganizationUnitTypes(OrganizationUnitType ... value);

    Role removeAllAllowedOrganizationUnitTypes();

    OrganizationField getOrganizationField();

    Role setOrganizationField(OrganizationField value);

    boolean getDelegatedCustomPrivilegeObjectRole();

    Role setDelegatedCustomPrivilegeObjectRole(boolean value);

    boolean isDelegatedCustomPrivilegeObjectRole();

    List<Role> getGeneralizationRoles();

    Role setGeneralizationRoles(List<Role> value);

    int getGeneralizationRolesCount();

    Role setGeneralizationRoles(Role ... value);

    BitSet getGeneralizationRolesAsBitSet();

    Role addGeneralizationRoles(List<Role> value);

    Role addGeneralizationRoles(Role ... value);

    Role removeGeneralizationRoles(List<Role> value);

    Role removeGeneralizationRoles(Role ... value);

    Role removeAllGeneralizationRoles();

    List<Role> getSpecializationRoles();

    Role setSpecializationRoles(List<Role> value);

    int getSpecializationRolesCount();

    Role setSpecializationRoles(Role ... value);

    BitSet getSpecializationRolesAsBitSet();

    Role addSpecializationRoles(List<Role> value);

    Role addSpecializationRoles(Role ... value);

    Role removeSpecializationRoles(List<Role> value);

    Role removeSpecializationRoles(Role ... value);

    Role removeAllSpecializationRoles();

    List<Role> getPrivilegesReceivingRoles();

    Role setPrivilegesReceivingRoles(List<Role> value);

    int getPrivilegesReceivingRolesCount();

    Role setPrivilegesReceivingRoles(Role ... value);

    BitSet getPrivilegesReceivingRolesAsBitSet();

    Role addPrivilegesReceivingRoles(List<Role> value);

    Role addPrivilegesReceivingRoles(Role ... value);

    Role removePrivilegesReceivingRoles(List<Role> value);

    Role removePrivilegesReceivingRoles(Role ... value);

    Role removeAllPrivilegesReceivingRoles();

    List<Role> getPrivilegesSendingRoles();

    Role setPrivilegesSendingRoles(List<Role> value);

    int getPrivilegesSendingRolesCount();

    Role setPrivilegesSendingRoles(Role ... value);

    BitSet getPrivilegesSendingRolesAsBitSet();

    Role addPrivilegesSendingRoles(List<Role> value);

    Role addPrivilegesSendingRoles(Role ... value);

    Role removePrivilegesSendingRoles(List<Role> value);

    Role removePrivilegesSendingRoles(Role ... value);

    Role removeAllPrivilegesSendingRoles();

    boolean getNoDirectMemberships();

    Role setNoDirectMemberships(boolean value);

    boolean isNoDirectMemberships();

    List<UserRoleAssignment> getUserRoleAssignments();

    Role setUserRoleAssignments(List<UserRoleAssignment> value);

    int getUserRoleAssignmentsCount();

    Role setUserRoleAssignments(UserRoleAssignment ... value);

    BitSet getUserRoleAssignmentsAsBitSet();

    Role addUserRoleAssignments(List<UserRoleAssignment> value);

    Role addUserRoleAssignments(UserRoleAssignment ... value);

    Role removeUserRoleAssignments(List<UserRoleAssignment> value);

    Role removeUserRoleAssignments(UserRoleAssignment ... value);

    Role removeAllUserRoleAssignments();

    List<RolePrivilegeAssignment> getPrivilegeAssignments();

    Role setPrivilegeAssignments(List<RolePrivilegeAssignment> value);

    int getPrivilegeAssignmentsCount();

    Role setPrivilegeAssignments(RolePrivilegeAssignment ... value);

    BitSet getPrivilegeAssignmentsAsBitSet();

    Role addPrivilegeAssignments(List<RolePrivilegeAssignment> value);

    Role addPrivilegeAssignments(RolePrivilegeAssignment ... value);

    Role removePrivilegeAssignments(List<RolePrivilegeAssignment> value);

    Role removePrivilegeAssignments(RolePrivilegeAssignment ... value);

    Role removeAllPrivilegeAssignments();

    List<RoleApplicationRoleAssignment> getApplicationRoleAssignments();

    Role setApplicationRoleAssignments(List<RoleApplicationRoleAssignment> value);

    int getApplicationRoleAssignmentsCount();

    Role setApplicationRoleAssignments(RoleApplicationRoleAssignment ... value);

    BitSet getApplicationRoleAssignmentsAsBitSet();

    Role addApplicationRoleAssignments(List<RoleApplicationRoleAssignment> value);

    Role addApplicationRoleAssignments(RoleApplicationRoleAssignment ... value);

    Role removeApplicationRoleAssignments(List<RoleApplicationRoleAssignment> value);

    Role removeApplicationRoleAssignments(RoleApplicationRoleAssignment ... value);

    Role removeAllApplicationRoleAssignments();

    boolean getProtectedAssignments();

    Role setProtectedAssignments(boolean value);

    boolean isProtectedAssignments();

    boolean getTwoFactorAuthRequired();

    Role setTwoFactorAuthRequired(boolean value);

    boolean isTwoFactorAuthRequired();


    static List<Role> getAll() {
        return UdbRole.getAll();
    }

    static List<Role> getDeletedRecords() {
        return UdbRole.getDeletedRecords();
    }

    static List<Role> sort(List<Role> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbRole.sort(list, sortFieldName, ascending, userContext, path);
    }

    static int getCount() {
        return UdbRole.getCount();
    }

    static RoleQuery filter() {
        return new UdbRoleQuery();
    }
}

