package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbUserLoginStatsQuery extends AbstractUdbQuery<UserLoginStats> implements UserLoginStatsQuery {

    public UdbUserLoginStatsQuery() {
        super(UdbUserLoginStats.table, UserLoginStats.getBuilder());
    }

    @Override
    public UserLoginStatsQuery id(Integer... ids) {
        return id(Arrays.asList(ids));
    }

    @Override
    public UserLoginStatsQuery id(BitSet ids) {
        filterById(ids);
        return this;
    }

    @Override
    public UserLoginStatsQuery id(Collection<Integer> ids) {
        filterById(ids);
        return this;
    }

	@Override
	public UserLoginStatsQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbUserLoginStats.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public UserLoginStatsQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbUserLoginStats.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public UserLoginStatsQuery filterUser(UserQuery query) {
		UdbUserQuery udbQuery = (UdbUserQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbUserLoginStats.user, UdbUser.loginStats);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public UserLoginStatsQuery user(NumericFilter filter) {
		and(UdbUserLoginStats.user.createFilter(filter));
		return this;
	}

	@Override
	public UserLoginStatsQuery orUser(NumericFilter filter) {
		or(UdbUserLoginStats.user.createFilter(filter));
		return this;
	}

	@Override
	public UserLoginStatsQuery firstLogin(NumericFilter filter) {
		and(UdbUserLoginStats.firstLogin.createFilter(filter));
		return this;
	}

	@Override
	public UserLoginStatsQuery orFirstLogin(NumericFilter filter) {
		or(UdbUserLoginStats.firstLogin.createFilter(filter));
		return this;
	}

	@Override
	public UserLoginStatsQuery lastLogin(NumericFilter filter) {
		and(UdbUserLoginStats.lastLogin.createFilter(filter));
		return this;
	}

	@Override
	public UserLoginStatsQuery orLastLogin(NumericFilter filter) {
		or(UdbUserLoginStats.lastLogin.createFilter(filter));
		return this;
	}

	@Override
	public UserLoginStatsQuery loginCount(NumericFilter filter) {
		and(UdbUserLoginStats.loginCount.createFilter(filter));
		return this;
	}

	@Override
	public UserLoginStatsQuery orLoginCount(NumericFilter filter) {
		or(UdbUserLoginStats.loginCount.createFilter(filter));
		return this;
	}

	@Override
	public UserLoginStatsQuery lastLoginIpAddress(TextFilter filter) {
		and(UdbUserLoginStats.lastLoginIpAddress.createFilter(filter));
		return this;
	}

	@Override
	public UserLoginStatsQuery orLastLoginIpAddress(TextFilter filter) {
		or(UdbUserLoginStats.lastLoginIpAddress.createFilter(filter));
		return this;
	}

	@Override
	public UserLoginStatsQuery wrongPasswordTimestamp(NumericFilter filter) {
		and(UdbUserLoginStats.wrongPasswordTimestamp.createFilter(filter));
		return this;
	}

	@Override
	public UserLoginStatsQuery orWrongPasswordTimestamp(NumericFilter filter) {
		or(UdbUserLoginStats.wrongPasswordTimestamp.createFilter(filter));
		return this;
	}

	@Override
	public UserLoginStatsQuery wrongPasswordIpAddress(TextFilter filter) {
		and(UdbUserLoginStats.wrongPasswordIpAddress.createFilter(filter));
		return this;
	}

	@Override
	public UserLoginStatsQuery orWrongPasswordIpAddress(TextFilter filter) {
		or(UdbUserLoginStats.wrongPasswordIpAddress.createFilter(filter));
		return this;
	}

	@Override
	public UserLoginStatsQuery wrongPasswordCount(NumericFilter filter) {
		and(UdbUserLoginStats.wrongPasswordCount.createFilter(filter));
		return this;
	}

	@Override
	public UserLoginStatsQuery orWrongPasswordCount(NumericFilter filter) {
		or(UdbUserLoginStats.wrongPasswordCount.createFilter(filter));
		return this;
	}

	@Override
	public UserLoginStatsQuery lastTotpAuthentication(NumericFilter filter) {
		and(UdbUserLoginStats.lastTotpAuthentication.createFilter(filter));
		return this;
	}

	@Override
	public UserLoginStatsQuery orLastTotpAuthentication(NumericFilter filter) {
		or(UdbUserLoginStats.lastTotpAuthentication.createFilter(filter));
		return this;
	}


	@Override
	public UdbUserLoginStatsQuery andOr(UserLoginStatsQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public UserLoginStatsQuery customFilter(Function<UserLoginStats, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(UserLoginStats.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



