/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.model.controlcenter;

import java.time.Instant;
import java.util.BitSet;
import java.util.List;
import org.teamapps.model.controlcenter.Application;
import org.teamapps.model.controlcenter.ApplicationPerspective;
import org.teamapps.model.controlcenter.ApplicationVersion;
import org.teamapps.model.controlcenter.LogLevel;
import org.teamapps.model.controlcenter.ManagedApplication;
import org.teamapps.model.controlcenter.ManagedApplicationPerspective;
import org.teamapps.model.controlcenter.SystemLog;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.FieldIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.numeric.ShortIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.EntityBitSetList;

public class UdbSystemLog
extends AbstractUdbEntity<SystemLog>
implements SystemLog {
    protected static TableIndex table;
    protected static UniversalDB universalDB;
    protected static IntegerIndex metaCreationDate;
    protected static IntegerIndex metaCreatedBy;
    protected static IntegerIndex metaModificationDate;
    protected static IntegerIndex metaModifiedBy;
    protected static IntegerIndex metaDeletionDate;
    protected static IntegerIndex metaDeletedBy;
    protected static IntegerIndex metaRestoreDate;
    protected static IntegerIndex metaRestoredBy;
    protected static SingleReferenceIndex managedApplication;
    protected static SingleReferenceIndex managedPerspective;
    protected static SingleReferenceIndex application;
    protected static SingleReferenceIndex applicationPerspective;
    protected static SingleReferenceIndex applicationVersion;
    protected static ShortIndex logLevel;
    protected static TextIndex thread;
    protected static TextIndex message;
    protected static TextIndex details;
    protected static TextIndex exceptionClass;

    private static void setTableIndex(TableIndex tableIndex, UniversalDB udb) {
        universalDB = udb;
        table = tableIndex;
        metaCreationDate = (IntegerIndex)tableIndex.getFieldIndex("metaCreationDate");
        metaCreatedBy = (IntegerIndex)tableIndex.getFieldIndex("metaCreatedBy");
        metaModificationDate = (IntegerIndex)tableIndex.getFieldIndex("metaModificationDate");
        metaModifiedBy = (IntegerIndex)tableIndex.getFieldIndex("metaModifiedBy");
        metaDeletionDate = (IntegerIndex)tableIndex.getFieldIndex("metaDeletionDate");
        metaDeletedBy = (IntegerIndex)tableIndex.getFieldIndex("metaDeletedBy");
        metaRestoreDate = (IntegerIndex)tableIndex.getFieldIndex("metaRestoreDate");
        metaRestoredBy = (IntegerIndex)tableIndex.getFieldIndex("metaRestoredBy");
        managedApplication = (SingleReferenceIndex)tableIndex.getFieldIndex("managedApplication");
        managedPerspective = (SingleReferenceIndex)tableIndex.getFieldIndex("managedPerspective");
        application = (SingleReferenceIndex)tableIndex.getFieldIndex("application");
        applicationPerspective = (SingleReferenceIndex)tableIndex.getFieldIndex("applicationPerspective");
        applicationVersion = (SingleReferenceIndex)tableIndex.getFieldIndex("applicationVersion");
        logLevel = (ShortIndex)tableIndex.getFieldIndex("logLevel");
        thread = (TextIndex)tableIndex.getFieldIndex("thread");
        message = (TextIndex)tableIndex.getFieldIndex("message");
        details = (TextIndex)tableIndex.getFieldIndex("details");
        exceptionClass = (TextIndex)tableIndex.getFieldIndex("exceptionClass");
    }

    public static List<SystemLog> getAll() {
        return new EntityBitSetList(SystemLog.getBuilder(), table.getRecordBitSet());
    }

    public static List<SystemLog> getDeletedRecords() {
        return new EntityBitSetList(SystemLog.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<SystemLog> sort(List<SystemLog> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbSystemLog.sort((TableIndex)table, list, (String)sortFieldName, (boolean)ascending, (UserContext)userContext, (String[])path);
    }

    public static List<SystemLog> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbSystemLog.sort((TableIndex)table, SystemLog.getBuilder(), (BitSet)recordIds, (String)sortFieldName, (boolean)ascending, (UserContext)userContext, (String[])path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbSystemLog() {
        super(table);
    }

    public UdbSystemLog(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    public SystemLog build() {
        return new UdbSystemLog();
    }

    public SystemLog build(int id) {
        return new UdbSystemLog(id, false);
    }

    @Override
    public Instant getMetaCreationDate() {
        return this.getTimestampValue(metaCreationDate);
    }

    @Override
    public SystemLog setMetaCreationDate(Instant value) {
        this.setTimestampValue(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaCreationDate);
    }

    @Override
    public SystemLog setMetaCreationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaCreationDate);
        return this;
    }

    @Override
    public long getMetaCreationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaCreationDate);
    }

    @Override
    public SystemLog setMetaCreationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreatedBy() {
        return this.getIntValue(metaCreatedBy);
    }

    @Override
    public SystemLog setMetaCreatedBy(int value) {
        this.setIntValue(value, metaCreatedBy);
        return this;
    }

    @Override
    public Instant getMetaModificationDate() {
        return this.getTimestampValue(metaModificationDate);
    }

    @Override
    public SystemLog setMetaModificationDate(Instant value) {
        this.setTimestampValue(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModificationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaModificationDate);
    }

    @Override
    public SystemLog setMetaModificationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaModificationDate);
        return this;
    }

    @Override
    public long getMetaModificationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaModificationDate);
    }

    @Override
    public SystemLog setMetaModificationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModifiedBy() {
        return this.getIntValue(metaModifiedBy);
    }

    @Override
    public SystemLog setMetaModifiedBy(int value) {
        this.setIntValue(value, metaModifiedBy);
        return this;
    }

    @Override
    public Instant getMetaDeletionDate() {
        return this.getTimestampValue(metaDeletionDate);
    }

    @Override
    public SystemLog setMetaDeletionDate(Instant value) {
        this.setTimestampValue(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletionDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaDeletionDate);
    }

    @Override
    public SystemLog setMetaDeletionDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaDeletionDate);
        return this;
    }

    @Override
    public long getMetaDeletionDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaDeletionDate);
    }

    @Override
    public SystemLog setMetaDeletionDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletedBy() {
        return this.getIntValue(metaDeletedBy);
    }

    @Override
    public SystemLog setMetaDeletedBy(int value) {
        this.setIntValue(value, metaDeletedBy);
        return this;
    }

    @Override
    public Instant getMetaRestoreDate() {
        return this.getTimestampValue(metaRestoreDate);
    }

    @Override
    public SystemLog setMetaRestoreDate(Instant value) {
        this.setTimestampValue(value, metaRestoreDate);
        return this;
    }

    @Override
    public int getMetaRestoreDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaRestoreDate);
    }

    @Override
    public SystemLog setMetaRestoreDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaRestoreDate);
        return this;
    }

    @Override
    public long getMetaRestoreDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaRestoreDate);
    }

    @Override
    public SystemLog setMetaRestoreDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaRestoreDate);
        return this;
    }

    @Override
    public int getMetaRestoredBy() {
        return this.getIntValue(metaRestoredBy);
    }

    @Override
    public SystemLog setMetaRestoredBy(int value) {
        this.setIntValue(value, metaRestoredBy);
        return this;
    }

    @Override
    public ManagedApplication getManagedApplication() {
        if (this.isChanged((FieldIndex)managedApplication)) {
            return (ManagedApplication)this.getReferenceChangeValue((FieldIndex)managedApplication);
        }
        int id = managedApplication.getValue(this.getId());
        if (id > 0) {
            return ManagedApplication.getById(id);
        }
        return null;
    }

    @Override
    public SystemLog setManagedApplication(ManagedApplication value) {
        this.setSingleReferenceValue(managedApplication, value, table);
        return this;
    }

    @Override
    public ManagedApplicationPerspective getManagedPerspective() {
        if (this.isChanged((FieldIndex)managedPerspective)) {
            return (ManagedApplicationPerspective)this.getReferenceChangeValue((FieldIndex)managedPerspective);
        }
        int id = managedPerspective.getValue(this.getId());
        if (id > 0) {
            return ManagedApplicationPerspective.getById(id);
        }
        return null;
    }

    @Override
    public SystemLog setManagedPerspective(ManagedApplicationPerspective value) {
        this.setSingleReferenceValue(managedPerspective, value, table);
        return this;
    }

    @Override
    public Application getApplication() {
        if (this.isChanged((FieldIndex)application)) {
            return (Application)this.getReferenceChangeValue((FieldIndex)application);
        }
        int id = application.getValue(this.getId());
        if (id > 0) {
            return Application.getById(id);
        }
        return null;
    }

    @Override
    public SystemLog setApplication(Application value) {
        this.setSingleReferenceValue(application, value, table);
        return this;
    }

    @Override
    public ApplicationPerspective getApplicationPerspective() {
        if (this.isChanged((FieldIndex)applicationPerspective)) {
            return (ApplicationPerspective)this.getReferenceChangeValue((FieldIndex)applicationPerspective);
        }
        int id = applicationPerspective.getValue(this.getId());
        if (id > 0) {
            return ApplicationPerspective.getById(id);
        }
        return null;
    }

    @Override
    public SystemLog setApplicationPerspective(ApplicationPerspective value) {
        this.setSingleReferenceValue(applicationPerspective, value, table);
        return this;
    }

    @Override
    public ApplicationVersion getApplicationVersion() {
        if (this.isChanged((FieldIndex)applicationVersion)) {
            return (ApplicationVersion)this.getReferenceChangeValue((FieldIndex)applicationVersion);
        }
        int id = applicationVersion.getValue(this.getId());
        if (id > 0) {
            return ApplicationVersion.getById(id);
        }
        return null;
    }

    @Override
    public SystemLog setApplicationVersion(ApplicationVersion value) {
        this.setSingleReferenceValue(applicationVersion, value, table);
        return this;
    }

    @Override
    public LogLevel getLogLevel() {
        return (LogLevel)this.getEnumValue(logLevel, LogLevel.values());
    }

    @Override
    public SystemLog setLogLevel(LogLevel value) {
        this.setEnumValue(logLevel, value);
        return this;
    }

    @Override
    public String getThread() {
        return this.getTextValue(thread);
    }

    @Override
    public SystemLog setThread(String value) {
        this.setTextValue(value, thread);
        return this;
    }

    @Override
    public String getMessage() {
        return this.getTextValue(message);
    }

    @Override
    public SystemLog setMessage(String value) {
        this.setTextValue(value, message);
        return this;
    }

    @Override
    public String getDetails() {
        return this.getTextValue(details);
    }

    @Override
    public SystemLog setDetails(String value) {
        this.setTextValue(value, details);
        return this;
    }

    @Override
    public String getExceptionClass() {
        return this.getTextValue(exceptionClass);
    }

    @Override
    public SystemLog setExceptionClass(String value) {
        this.setTextValue(value, exceptionClass);
        return this;
    }

    public UdbSystemLog save() {
        this.saveRecord(universalDB);
        return this;
    }

    public UdbSystemLog save(int userId, long timestamp) {
        this.saveRecord(universalDB, userId, timestamp);
        return this;
    }

    public void delete() {
        this.deleteRecord(universalDB);
    }

    public void delete(int userId, long timestamp) {
        this.deleteRecord(universalDB, userId, timestamp);
    }

    public void restoreDeleted() {
        this.restoreDeletedRecord(universalDB);
    }

    public void restoreDeleted(int userId, long timestamp) {
        this.restoreDeletedRecord(universalDB, userId, timestamp);
    }
}

