package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.context.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface ManagedApplicationGroup extends Entity<ManagedApplicationGroup> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_ICON = "icon";
	final static String FIELD_NAME = "name";
	final static String FIELD_TITLE_KEY = "titleKey";
	final static String FIELD_APPLICATIONS = "applications";
	final static String FIELD_LISTING_POSITION = "listingPosition";

    static ManagedApplicationGroup create() {
        return new UdbManagedApplicationGroup();
    }

    static ManagedApplicationGroup create(int id) {
        return new UdbManagedApplicationGroup(id, true);
    }

    static ManagedApplicationGroup getById(int id) {
        return new UdbManagedApplicationGroup(id, false);
    }

    static EntityBuilder<ManagedApplicationGroup> getBuilder() {
        return new UdbManagedApplicationGroup(0, false);
    }

    Instant getMetaCreationDate();

    ManagedApplicationGroup setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    ManagedApplicationGroup setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    ManagedApplicationGroup setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    ManagedApplicationGroup setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    ManagedApplicationGroup setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    ManagedApplicationGroup setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    ManagedApplicationGroup setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    ManagedApplicationGroup setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    ManagedApplicationGroup setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    ManagedApplicationGroup setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    ManagedApplicationGroup setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    ManagedApplicationGroup setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    ManagedApplicationGroup setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    ManagedApplicationGroup setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    ManagedApplicationGroup setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    ManagedApplicationGroup setMetaRestoredBy(int value);

    String getIcon();

    ManagedApplicationGroup setIcon(String value);

    String getName();

    ManagedApplicationGroup setName(String value);

    String getTitleKey();

    ManagedApplicationGroup setTitleKey(String value);

    List<ManagedApplication> getApplications();

    ManagedApplicationGroup setApplications(List<ManagedApplication> value);

    int getApplicationsCount();

    ManagedApplicationGroup setApplications(ManagedApplication ... value);

    BitSet getApplicationsAsBitSet();

    ManagedApplicationGroup addApplications(List<ManagedApplication> value);

    ManagedApplicationGroup addApplications(ManagedApplication ... value);

    ManagedApplicationGroup removeApplications(List<ManagedApplication> value);

    ManagedApplicationGroup removeApplications(ManagedApplication ... value);

    ManagedApplicationGroup removeAllApplications();

    int getListingPosition();

    ManagedApplicationGroup setListingPosition(int value);


    static List<ManagedApplicationGroup> getAll() {
        return UdbManagedApplicationGroup.getAll();
    }

    static List<ManagedApplicationGroup> getDeletedRecords() {
        return UdbManagedApplicationGroup.getDeletedRecords();
    }

    static List<ManagedApplicationGroup> sort(List<ManagedApplicationGroup> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbManagedApplicationGroup.sort(list, sortFieldName, ascending, userContext, path);
    }

    static int getCount() {
        return UdbManagedApplicationGroup.getCount();
    }

    static ManagedApplicationGroupQuery filter() {
        return new UdbManagedApplicationGroupQuery();
    }
}

