package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbLocalizationValue extends AbstractUdbEntity<LocalizationValue> implements LocalizationValue {
	protected static TableIndex table;
	protected static UniversalDB universalDB;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static SingleReferenceIndex localizationKey;
	protected static TextIndex language;
	protected static TextIndex original;
	protected static TextIndex machineTranslation;
	protected static TextIndex translation;
	protected static TextIndex adminLocalOverride;
	protected static TextIndex adminKeyOverride;
	protected static TextIndex currentDisplayValue;
	protected static TextIndex notes;
	protected static ShortIndex machineTranslationState;
	protected static ShortIndex translationState;
	protected static ShortIndex translationVerificationState;

    private static void setTableIndex(TableIndex tableIndex, UniversalDB udb) {
		universalDB = udb;
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_RESTORED_BY);
		localizationKey = (SingleReferenceIndex) tableIndex.getFieldIndex(FIELD_LOCALIZATION_KEY);
		language = (TextIndex) tableIndex.getFieldIndex(FIELD_LANGUAGE);
		original = (TextIndex) tableIndex.getFieldIndex(FIELD_ORIGINAL);
		machineTranslation = (TextIndex) tableIndex.getFieldIndex(FIELD_MACHINE_TRANSLATION);
		translation = (TextIndex) tableIndex.getFieldIndex(FIELD_TRANSLATION);
		adminLocalOverride = (TextIndex) tableIndex.getFieldIndex(FIELD_ADMIN_LOCAL_OVERRIDE);
		adminKeyOverride = (TextIndex) tableIndex.getFieldIndex(FIELD_ADMIN_KEY_OVERRIDE);
		currentDisplayValue = (TextIndex) tableIndex.getFieldIndex(FIELD_CURRENT_DISPLAY_VALUE);
		notes = (TextIndex) tableIndex.getFieldIndex(FIELD_NOTES);
		machineTranslationState = (ShortIndex) tableIndex.getFieldIndex(FIELD_MACHINE_TRANSLATION_STATE);
		translationState = (ShortIndex) tableIndex.getFieldIndex(FIELD_TRANSLATION_STATE);
		translationVerificationState = (ShortIndex) tableIndex.getFieldIndex(FIELD_TRANSLATION_VERIFICATION_STATE);
    }

    public static List<LocalizationValue> getAll() {
        return new EntityBitSetList<>(LocalizationValue.getBuilder(), table.getRecordBitSet());
    }

    public static List<LocalizationValue> getDeletedRecords() {
        return new EntityBitSetList<>(LocalizationValue.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<LocalizationValue> sort(List<LocalizationValue> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<LocalizationValue> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, LocalizationValue.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbLocalizationValue() {
        super(table);
    }

    public UdbLocalizationValue(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public LocalizationValue build() {
        return new UdbLocalizationValue();
    }

    @Override
    public LocalizationValue build(int id) {
        return new UdbLocalizationValue(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public LocalizationValue setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public LocalizationValue setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public LocalizationValue setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public LocalizationValue setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public LocalizationValue setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public LocalizationValue setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public LocalizationValue setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public LocalizationValue setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public LocalizationValue setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public LocalizationValue setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public LocalizationValue setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public LocalizationValue setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public LocalizationValue setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public LocalizationValue setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public LocalizationValue setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public LocalizationValue setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public LocalizationKey getLocalizationKey() {
		if (isChanged(localizationKey)) {
			return (LocalizationKey) getReferenceChangeValue(localizationKey);
		} else {
			int id = localizationKey.getValue(getId());
			if (id > 0) {
				return LocalizationKey.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public LocalizationValue setLocalizationKey(LocalizationKey value) {
		setSingleReferenceValue(localizationKey, value, table);
		return this;
	}

	@Override
	public String getLanguage() {
        return getTextValue(language);
	}

	@Override
	public LocalizationValue setLanguage(String value) {
	    setTextValue(value, this.language);
		return this;
	}

	@Override
	public String getOriginal() {
        return getTextValue(original);
	}

	@Override
	public LocalizationValue setOriginal(String value) {
	    setTextValue(value, this.original);
		return this;
	}

	@Override
	public String getMachineTranslation() {
        return getTextValue(machineTranslation);
	}

	@Override
	public LocalizationValue setMachineTranslation(String value) {
	    setTextValue(value, this.machineTranslation);
		return this;
	}

	@Override
	public String getTranslation() {
        return getTextValue(translation);
	}

	@Override
	public LocalizationValue setTranslation(String value) {
	    setTextValue(value, this.translation);
		return this;
	}

	@Override
	public String getAdminLocalOverride() {
        return getTextValue(adminLocalOverride);
	}

	@Override
	public LocalizationValue setAdminLocalOverride(String value) {
	    setTextValue(value, this.adminLocalOverride);
		return this;
	}

	@Override
	public String getAdminKeyOverride() {
        return getTextValue(adminKeyOverride);
	}

	@Override
	public LocalizationValue setAdminKeyOverride(String value) {
	    setTextValue(value, this.adminKeyOverride);
		return this;
	}

	@Override
	public String getCurrentDisplayValue() {
        return getTextValue(currentDisplayValue);
	}

	@Override
	public LocalizationValue setCurrentDisplayValue(String value) {
	    setTextValue(value, this.currentDisplayValue);
		return this;
	}

	@Override
	public String getNotes() {
        return getTextValue(notes);
	}

	@Override
	public LocalizationValue setNotes(String value) {
	    setTextValue(value, this.notes);
		return this;
	}

	@Override
	public MachineTranslationState getMachineTranslationState() {
	    return getEnumValue(machineTranslationState, MachineTranslationState.values());
	}

	@Override
	public LocalizationValue setMachineTranslationState(MachineTranslationState value) {
    	setEnumValue(this.machineTranslationState, value);
		return this;
	}

	@Override
	public TranslationState getTranslationState() {
	    return getEnumValue(translationState, TranslationState.values());
	}

	@Override
	public LocalizationValue setTranslationState(TranslationState value) {
    	setEnumValue(this.translationState, value);
		return this;
	}

	@Override
	public TranslationVerificationState getTranslationVerificationState() {
	    return getEnumValue(translationVerificationState, TranslationVerificationState.values());
	}

	@Override
	public LocalizationValue setTranslationVerificationState(TranslationVerificationState value) {
    	setEnumValue(this.translationVerificationState, value);
		return this;
	}



    @Override
    public UdbLocalizationValue save() {
        saveRecord(universalDB);
        return this;
    }

   @Override
    public UdbLocalizationValue save(int userId, long timestamp) {
        saveRecord(universalDB, userId, timestamp);
        return this;
    }

    @Override
    public void delete() {
        deleteRecord(universalDB);
    }

    @Override
    public void delete(int userId, long timestamp) {
        deleteRecord(universalDB, userId, timestamp);
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord(universalDB);
    }

    @Override
    public void restoreDeleted(int userId, long timestamp) {
        restoreDeletedRecord(universalDB, userId, timestamp);
    }
}



