package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbOrganizationUnit extends AbstractUdbEntity<OrganizationUnit> implements OrganizationUnit {
	protected static TableIndex table;
	protected static UniversalDB universalDB;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static TranslatableTextIndex name;
	protected static SingleReferenceIndex parent;
	protected static MultiReferenceIndex children;
	protected static SingleReferenceIndex type;
	protected static TextIndex icon;
	protected static ShortIndex orgUnitLifeCycleStatus;
	protected static SingleReferenceIndex address;
	protected static MultiReferenceIndex users;
	protected static MultiReferenceIndex userRoleAssignments;
	protected static IntegerIndex lifeCycleChangeDatePrepareDeletion;
	protected static IntegerIndex lifeCycleChangeDateInactive;
	protected static IntegerIndex lifeCycleChangeDateDeleted;

    private static void setTableIndex(TableIndex tableIndex, UniversalDB udb) {
		universalDB = udb;
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_RESTORED_BY);
		name = (TranslatableTextIndex) tableIndex.getFieldIndex(FIELD_NAME);
		parent = (SingleReferenceIndex) tableIndex.getFieldIndex(FIELD_PARENT);
		children = (MultiReferenceIndex) tableIndex.getFieldIndex(FIELD_CHILDREN);
		type = (SingleReferenceIndex) tableIndex.getFieldIndex(FIELD_TYPE);
		icon = (TextIndex) tableIndex.getFieldIndex(FIELD_ICON);
		orgUnitLifeCycleStatus = (ShortIndex) tableIndex.getFieldIndex(FIELD_ORG_UNIT_LIFE_CYCLE_STATUS);
		address = (SingleReferenceIndex) tableIndex.getFieldIndex(FIELD_ADDRESS);
		users = (MultiReferenceIndex) tableIndex.getFieldIndex(FIELD_USERS);
		userRoleAssignments = (MultiReferenceIndex) tableIndex.getFieldIndex(FIELD_USER_ROLE_ASSIGNMENTS);
		lifeCycleChangeDatePrepareDeletion = (IntegerIndex) tableIndex.getFieldIndex(FIELD_LIFE_CYCLE_CHANGE_DATE_PREPARE_DELETION);
		lifeCycleChangeDateInactive = (IntegerIndex) tableIndex.getFieldIndex(FIELD_LIFE_CYCLE_CHANGE_DATE_INACTIVE);
		lifeCycleChangeDateDeleted = (IntegerIndex) tableIndex.getFieldIndex(FIELD_LIFE_CYCLE_CHANGE_DATE_DELETED);
    }

    public static List<OrganizationUnit> getAll() {
        return new EntityBitSetList<>(OrganizationUnit.getBuilder(), table.getRecordBitSet());
    }

    public static List<OrganizationUnit> getDeletedRecords() {
        return new EntityBitSetList<>(OrganizationUnit.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<OrganizationUnit> sort(List<OrganizationUnit> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<OrganizationUnit> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, OrganizationUnit.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbOrganizationUnit() {
        super(table);
    }

    public UdbOrganizationUnit(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public OrganizationUnit build() {
        return new UdbOrganizationUnit();
    }

    @Override
    public OrganizationUnit build(int id) {
        return new UdbOrganizationUnit(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public OrganizationUnit setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public OrganizationUnit setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public OrganizationUnit setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public OrganizationUnit setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public OrganizationUnit setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public OrganizationUnit setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public OrganizationUnit setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public OrganizationUnit setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public OrganizationUnit setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public OrganizationUnit setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public OrganizationUnit setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public OrganizationUnit setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public OrganizationUnit setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public OrganizationUnit setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public OrganizationUnit setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public OrganizationUnit setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public TranslatableText getName() {
	    return getTranslatableTextValue(this.name);
	}

	@Override
	public OrganizationUnit setName(TranslatableText value) {
    	setTranslatableTextValue(value, this.name);
		return this;
	}

	@Override
	public OrganizationUnit getParent() {
		if (isChanged(parent)) {
			return (OrganizationUnit) getReferenceChangeValue(parent);
		} else {
			int id = parent.getValue(getId());
			if (id > 0) {
				return OrganizationUnit.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public OrganizationUnit setParent(OrganizationUnit value) {
		setSingleReferenceValue(parent, value, table);
		return this;
	}

	@Override
	public List<OrganizationUnit> getChildren() {
	    return getMultiReferenceValue(children, OrganizationUnit.getBuilder());
	}

	@Override
	public OrganizationUnit setChildren(List<OrganizationUnit> value) {
		setMultiReferenceValue(value, children);
		return this;
	}

	@Override
	public int getChildrenCount() {
	    return getMultiReferenceValueCount(children, OrganizationUnit.getBuilder());
	}

	@Override
	public OrganizationUnit setChildren(OrganizationUnit ... value) {
		setMultiReferenceValue(Arrays.asList(value), children);
		return this;
	}

	@Override
	public BitSet getChildrenAsBitSet() {
	    return getMultiReferenceValueAsBitSet(children, OrganizationUnit.getBuilder());
	}

	@Override
	public OrganizationUnit addChildren(List<OrganizationUnit> value) {
		addMultiReferenceValue(value, children);
		return this;
	}

	@Override
	public OrganizationUnit addChildren(OrganizationUnit ... value) {
		addMultiReferenceValue(Arrays.asList(value), children);
		return this;
	}

	@Override
	public OrganizationUnit removeChildren(List<OrganizationUnit> value) {
		removeMultiReferenceValue(value, children);
		return this;
	}

	@Override
	public OrganizationUnit removeChildren(OrganizationUnit ... value) {
		removeMultiReferenceValue(Arrays.asList(value), children);
		return this;
	}

	@Override
	public OrganizationUnit removeAllChildren() {
		removeAllMultiReferenceValue(children);
		return this;
	}

	@Override
	public OrganizationUnitType getType() {
		if (isChanged(type)) {
			return (OrganizationUnitType) getReferenceChangeValue(type);
		} else {
			int id = type.getValue(getId());
			if (id > 0) {
				return OrganizationUnitType.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public OrganizationUnit setType(OrganizationUnitType value) {
		setSingleReferenceValue(type, value, table);
		return this;
	}

	@Override
	public String getIcon() {
        return getTextValue(icon);
	}

	@Override
	public OrganizationUnit setIcon(String value) {
	    setTextValue(value, this.icon);
		return this;
	}

	@Override
	public OrgUnitLifeCycleStatus getOrgUnitLifeCycleStatus() {
	    return getEnumValue(orgUnitLifeCycleStatus, OrgUnitLifeCycleStatus.values());
	}

	@Override
	public OrganizationUnit setOrgUnitLifeCycleStatus(OrgUnitLifeCycleStatus value) {
    	setEnumValue(this.orgUnitLifeCycleStatus, value);
		return this;
	}

	@Override
	public Address getAddress() {
		if (isChanged(address)) {
			return (Address) getReferenceChangeValue(address);
		} else {
			int id = address.getValue(getId());
			if (id > 0) {
				return Address.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public OrganizationUnit setAddress(Address value) {
		setSingleReferenceValue(address, value, table);
		return this;
	}

	@Override
	public List<User> getUsers() {
	    return getMultiReferenceValue(users, User.getBuilder());
	}

	@Override
	public OrganizationUnit setUsers(List<User> value) {
		setMultiReferenceValue(value, users);
		return this;
	}

	@Override
	public int getUsersCount() {
	    return getMultiReferenceValueCount(users, User.getBuilder());
	}

	@Override
	public OrganizationUnit setUsers(User ... value) {
		setMultiReferenceValue(Arrays.asList(value), users);
		return this;
	}

	@Override
	public BitSet getUsersAsBitSet() {
	    return getMultiReferenceValueAsBitSet(users, User.getBuilder());
	}

	@Override
	public OrganizationUnit addUsers(List<User> value) {
		addMultiReferenceValue(value, users);
		return this;
	}

	@Override
	public OrganizationUnit addUsers(User ... value) {
		addMultiReferenceValue(Arrays.asList(value), users);
		return this;
	}

	@Override
	public OrganizationUnit removeUsers(List<User> value) {
		removeMultiReferenceValue(value, users);
		return this;
	}

	@Override
	public OrganizationUnit removeUsers(User ... value) {
		removeMultiReferenceValue(Arrays.asList(value), users);
		return this;
	}

	@Override
	public OrganizationUnit removeAllUsers() {
		removeAllMultiReferenceValue(users);
		return this;
	}

	@Override
	public List<UserRoleAssignment> getUserRoleAssignments() {
	    return getMultiReferenceValue(userRoleAssignments, UserRoleAssignment.getBuilder());
	}

	@Override
	public OrganizationUnit setUserRoleAssignments(List<UserRoleAssignment> value) {
		setMultiReferenceValue(value, userRoleAssignments);
		return this;
	}

	@Override
	public int getUserRoleAssignmentsCount() {
	    return getMultiReferenceValueCount(userRoleAssignments, UserRoleAssignment.getBuilder());
	}

	@Override
	public OrganizationUnit setUserRoleAssignments(UserRoleAssignment ... value) {
		setMultiReferenceValue(Arrays.asList(value), userRoleAssignments);
		return this;
	}

	@Override
	public BitSet getUserRoleAssignmentsAsBitSet() {
	    return getMultiReferenceValueAsBitSet(userRoleAssignments, UserRoleAssignment.getBuilder());
	}

	@Override
	public OrganizationUnit addUserRoleAssignments(List<UserRoleAssignment> value) {
		addMultiReferenceValue(value, userRoleAssignments);
		return this;
	}

	@Override
	public OrganizationUnit addUserRoleAssignments(UserRoleAssignment ... value) {
		addMultiReferenceValue(Arrays.asList(value), userRoleAssignments);
		return this;
	}

	@Override
	public OrganizationUnit removeUserRoleAssignments(List<UserRoleAssignment> value) {
		removeMultiReferenceValue(value, userRoleAssignments);
		return this;
	}

	@Override
	public OrganizationUnit removeUserRoleAssignments(UserRoleAssignment ... value) {
		removeMultiReferenceValue(Arrays.asList(value), userRoleAssignments);
		return this;
	}

	@Override
	public OrganizationUnit removeAllUserRoleAssignments() {
		removeAllMultiReferenceValue(userRoleAssignments);
		return this;
	}

	@Override
	public Instant getLifeCycleChangeDatePrepareDeletion() {
	    return getTimestampValue(lifeCycleChangeDatePrepareDeletion);
	}

	@Override
	public OrganizationUnit setLifeCycleChangeDatePrepareDeletion(Instant value) {
	    setTimestampValue(value, this.lifeCycleChangeDatePrepareDeletion);
		return this;
	}

	@Override
	public int getLifeCycleChangeDatePrepareDeletionAsEpochSecond() {
	    return getTimestampAsEpochSecond(lifeCycleChangeDatePrepareDeletion);
	}

	@Override
	public OrganizationUnit setLifeCycleChangeDatePrepareDeletionAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.lifeCycleChangeDatePrepareDeletion);
		return this;
	}

	@Override
	public long getLifeCycleChangeDatePrepareDeletionAsEpochMilli() {
	    return getTimestampAsEpochMilli(lifeCycleChangeDatePrepareDeletion);
	}

	@Override
	public OrganizationUnit setLifeCycleChangeDatePrepareDeletionAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.lifeCycleChangeDatePrepareDeletion);
		return this;
	}

	@Override
	public Instant getLifeCycleChangeDateInactive() {
	    return getTimestampValue(lifeCycleChangeDateInactive);
	}

	@Override
	public OrganizationUnit setLifeCycleChangeDateInactive(Instant value) {
	    setTimestampValue(value, this.lifeCycleChangeDateInactive);
		return this;
	}

	@Override
	public int getLifeCycleChangeDateInactiveAsEpochSecond() {
	    return getTimestampAsEpochSecond(lifeCycleChangeDateInactive);
	}

	@Override
	public OrganizationUnit setLifeCycleChangeDateInactiveAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.lifeCycleChangeDateInactive);
		return this;
	}

	@Override
	public long getLifeCycleChangeDateInactiveAsEpochMilli() {
	    return getTimestampAsEpochMilli(lifeCycleChangeDateInactive);
	}

	@Override
	public OrganizationUnit setLifeCycleChangeDateInactiveAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.lifeCycleChangeDateInactive);
		return this;
	}

	@Override
	public Instant getLifeCycleChangeDateDeleted() {
	    return getTimestampValue(lifeCycleChangeDateDeleted);
	}

	@Override
	public OrganizationUnit setLifeCycleChangeDateDeleted(Instant value) {
	    setTimestampValue(value, this.lifeCycleChangeDateDeleted);
		return this;
	}

	@Override
	public int getLifeCycleChangeDateDeletedAsEpochSecond() {
	    return getTimestampAsEpochSecond(lifeCycleChangeDateDeleted);
	}

	@Override
	public OrganizationUnit setLifeCycleChangeDateDeletedAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.lifeCycleChangeDateDeleted);
		return this;
	}

	@Override
	public long getLifeCycleChangeDateDeletedAsEpochMilli() {
	    return getTimestampAsEpochMilli(lifeCycleChangeDateDeleted);
	}

	@Override
	public OrganizationUnit setLifeCycleChangeDateDeletedAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.lifeCycleChangeDateDeleted);
		return this;
	}



    @Override
    public UdbOrganizationUnit save() {
        saveRecord(universalDB);
        return this;
    }

   @Override
    public UdbOrganizationUnit save(int userId, long timestamp) {
        saveRecord(universalDB, userId, timestamp);
        return this;
    }

    @Override
    public void delete() {
        deleteRecord(universalDB);
    }

    @Override
    public void delete(int userId, long timestamp) {
        deleteRecord(universalDB, userId, timestamp);
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord(universalDB);
    }

    @Override
    public void restoreDeleted(int userId, long timestamp) {
        restoreDeletedRecord(universalDB, userId, timestamp);
    }
}



