package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbOrganizationUnitViewQuery extends AbstractUdbQuery<OrganizationUnitView> implements OrganizationUnitViewQuery {

    public UdbOrganizationUnitViewQuery() {
        super(UdbOrganizationUnitView.table, OrganizationUnitView.getBuilder());
    }

    @Override
    public OrganizationUnitViewQuery id(Integer... ids) {
        return id(Arrays.asList(ids));
    }

    @Override
    public OrganizationUnitViewQuery id(BitSet ids) {
        filterById(ids);
        return this;
    }

    @Override
    public OrganizationUnitViewQuery id(Collection<Integer> ids) {
        filterById(ids);
        return this;
    }

	@Override
	public OrganizationUnitViewQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbOrganizationUnitView.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public OrganizationUnitViewQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbOrganizationUnitView.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public OrganizationUnitViewQuery name(TranslatableTextFilter filter) {
		and(UdbOrganizationUnitView.name.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitViewQuery orName(TranslatableTextFilter filter) {
		or(UdbOrganizationUnitView.name.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitViewQuery filterParent(OrganizationUnitViewQuery query) {
		UdbOrganizationUnitViewQuery udbQuery = (UdbOrganizationUnitViewQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbOrganizationUnitView.parent);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public OrganizationUnitViewQuery parent(NumericFilter filter) {
		and(UdbOrganizationUnitView.parent.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitViewQuery orParent(NumericFilter filter) {
		or(UdbOrganizationUnitView.parent.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitViewQuery filterChildren(OrganizationUnitViewQuery query) {
		UdbOrganizationUnitViewQuery udbQuery = (UdbOrganizationUnitViewQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbOrganizationUnitView.children);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public OrganizationUnitViewQuery children(MultiReferenceFilterType type, OrganizationUnitView ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (OrganizationUnitView value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbOrganizationUnitView.children.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitViewQuery childrenCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbOrganizationUnitView.children.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitViewQuery children(MultiReferenceFilter filter) {
		and(UdbOrganizationUnitView.children.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitViewQuery orChildren(MultiReferenceFilter filter) {
		or(UdbOrganizationUnitView.children.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitViewQuery filterType(OrganizationUnitTypeViewQuery query) {
		UdbOrganizationUnitTypeViewQuery udbQuery = (UdbOrganizationUnitTypeViewQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbOrganizationUnitView.type);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public OrganizationUnitViewQuery type(NumericFilter filter) {
		and(UdbOrganizationUnitView.type.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitViewQuery orType(NumericFilter filter) {
		or(UdbOrganizationUnitView.type.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitViewQuery icon(TextFilter filter) {
		and(UdbOrganizationUnitView.icon.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitViewQuery orIcon(TextFilter filter) {
		or(UdbOrganizationUnitView.icon.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitViewQuery orgUnitLifeCycleStatus(EnumFilterType filterType, OrgUnitLifeCycleStatus... enums) {
		and(UdbOrganizationUnitView.orgUnitLifeCycleStatus.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public OrganizationUnitViewQuery orOrgUnitLifeCycleStatus(EnumFilterType filterType, OrgUnitLifeCycleStatus... enums) {
		or(UdbOrganizationUnitView.orgUnitLifeCycleStatus.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public OrganizationUnitViewQuery filterAddress(AddressViewQuery query) {
		UdbAddressViewQuery udbQuery = (UdbAddressViewQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbOrganizationUnitView.address);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public OrganizationUnitViewQuery address(NumericFilter filter) {
		and(UdbOrganizationUnitView.address.createFilter(filter));
		return this;
	}

	@Override
	public OrganizationUnitViewQuery orAddress(NumericFilter filter) {
		or(UdbOrganizationUnitView.address.createFilter(filter));
		return this;
	}


	@Override
	public UdbOrganizationUnitViewQuery andOr(OrganizationUnitViewQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public OrganizationUnitViewQuery customFilter(Function<OrganizationUnitView, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(OrganizationUnitView.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



