package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbUserAccessToken extends AbstractUdbEntity<UserAccessToken> implements UserAccessToken {
	protected static TableIndex table;
	protected static UniversalDB universalDB;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static SingleReferenceIndex user;
	protected static TextIndex userAgentOnCreation;
	protected static TextIndex userAgentLastUsed;
	protected static IntegerIndex lastUsed;
	protected static IntegerIndex lastTotpAuthentication;
	protected static BooleanIndex valid;
	protected static BooleanIndex restApi;
	protected static TextIndex secureToken;

    private static void setTableIndex(TableIndex tableIndex, UniversalDB udb) {
		universalDB = udb;
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_MODIFIED_BY);
		user = (SingleReferenceIndex) tableIndex.getFieldIndex(FIELD_USER);
		userAgentOnCreation = (TextIndex) tableIndex.getFieldIndex(FIELD_USER_AGENT_ON_CREATION);
		userAgentLastUsed = (TextIndex) tableIndex.getFieldIndex(FIELD_USER_AGENT_LAST_USED);
		lastUsed = (IntegerIndex) tableIndex.getFieldIndex(FIELD_LAST_USED);
		lastTotpAuthentication = (IntegerIndex) tableIndex.getFieldIndex(FIELD_LAST_TOTP_AUTHENTICATION);
		valid = (BooleanIndex) tableIndex.getFieldIndex(FIELD_VALID);
		restApi = (BooleanIndex) tableIndex.getFieldIndex(FIELD_REST_API);
		secureToken = (TextIndex) tableIndex.getFieldIndex(FIELD_SECURE_TOKEN);
    }

    public static List<UserAccessToken> getAll() {
        return new EntityBitSetList<>(UserAccessToken.getBuilder(), table.getRecordBitSet());
    }

    public static List<UserAccessToken> getDeletedRecords() {
        return new EntityBitSetList<>(UserAccessToken.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<UserAccessToken> sort(List<UserAccessToken> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<UserAccessToken> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, UserAccessToken.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbUserAccessToken() {
        super(table);
    }

    public UdbUserAccessToken(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public UserAccessToken build() {
        return new UdbUserAccessToken();
    }

    @Override
    public UserAccessToken build(int id) {
        return new UdbUserAccessToken(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public UserAccessToken setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public UserAccessToken setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public UserAccessToken setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public UserAccessToken setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public UserAccessToken setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public UserAccessToken setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public UserAccessToken setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public UserAccessToken setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public User getUser() {
		if (isChanged(user)) {
			return (User) getReferenceChangeValue(user);
		} else {
			int id = user.getValue(getId());
			if (id > 0) {
				return User.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public UserAccessToken setUser(User value) {
		setSingleReferenceValue(user, value, table);
		return this;
	}

	@Override
	public String getUserAgentOnCreation() {
        return getTextValue(userAgentOnCreation);
	}

	@Override
	public UserAccessToken setUserAgentOnCreation(String value) {
	    setTextValue(value, this.userAgentOnCreation);
		return this;
	}

	@Override
	public String getUserAgentLastUsed() {
        return getTextValue(userAgentLastUsed);
	}

	@Override
	public UserAccessToken setUserAgentLastUsed(String value) {
	    setTextValue(value, this.userAgentLastUsed);
		return this;
	}

	@Override
	public Instant getLastUsed() {
	    return getTimestampValue(lastUsed);
	}

	@Override
	public UserAccessToken setLastUsed(Instant value) {
	    setTimestampValue(value, this.lastUsed);
		return this;
	}

	@Override
	public int getLastUsedAsEpochSecond() {
	    return getTimestampAsEpochSecond(lastUsed);
	}

	@Override
	public UserAccessToken setLastUsedAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.lastUsed);
		return this;
	}

	@Override
	public long getLastUsedAsEpochMilli() {
	    return getTimestampAsEpochMilli(lastUsed);
	}

	@Override
	public UserAccessToken setLastUsedAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.lastUsed);
		return this;
	}

	@Override
	public Instant getLastTotpAuthentication() {
	    return getTimestampValue(lastTotpAuthentication);
	}

	@Override
	public UserAccessToken setLastTotpAuthentication(Instant value) {
	    setTimestampValue(value, this.lastTotpAuthentication);
		return this;
	}

	@Override
	public int getLastTotpAuthenticationAsEpochSecond() {
	    return getTimestampAsEpochSecond(lastTotpAuthentication);
	}

	@Override
	public UserAccessToken setLastTotpAuthenticationAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.lastTotpAuthentication);
		return this;
	}

	@Override
	public long getLastTotpAuthenticationAsEpochMilli() {
	    return getTimestampAsEpochMilli(lastTotpAuthentication);
	}

	@Override
	public UserAccessToken setLastTotpAuthenticationAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.lastTotpAuthentication);
		return this;
	}

	@Override
	public boolean getValid() {
	    return getBooleanValue(valid);
	}

	@Override
	public UserAccessToken setValid(boolean value) {
	    setBooleanValue(value, this.valid);
		return this;
	}

	@Override
	public boolean isValid() {
	    return getBooleanValue(valid);
	}

	@Override
	public boolean getRestApi() {
	    return getBooleanValue(restApi);
	}

	@Override
	public UserAccessToken setRestApi(boolean value) {
	    setBooleanValue(value, this.restApi);
		return this;
	}

	@Override
	public boolean isRestApi() {
	    return getBooleanValue(restApi);
	}

	@Override
	public String getSecureToken() {
        return getTextValue(secureToken);
	}

	@Override
	public UserAccessToken setSecureToken(String value) {
	    setTextValue(value, this.secureToken);
		return this;
	}



    @Override
    public UdbUserAccessToken save() {
        saveRecord(universalDB);
        return this;
    }

   @Override
    public UdbUserAccessToken save(int userId, long timestamp) {
        saveRecord(universalDB, userId, timestamp);
        return this;
    }

    @Override
    public void delete() {
        deleteRecord(universalDB);
    }

    @Override
    public void delete(int userId, long timestamp) {
        deleteRecord(universalDB, userId, timestamp);
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord(universalDB);
    }

    @Override
    public void restoreDeleted(int userId, long timestamp) {
        restoreDeletedRecord(universalDB, userId, timestamp);
    }
}



