package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.context.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface LanguageSettings extends Entity<LanguageSettings> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_LANGUAGE = "language";
	final static String FIELD_LANGUAGE_SKILL_LEVEL = "languageSkillLevel";

    static LanguageSettings create() {
        return new UdbLanguageSettings();
    }

    static LanguageSettings create(int id) {
        return new UdbLanguageSettings(id, true);
    }

    static LanguageSettings getById(int id) {
        return new UdbLanguageSettings(id, false);
    }

    static EntityBuilder<LanguageSettings> getBuilder() {
        return new UdbLanguageSettings(0, false);
    }

    Instant getMetaCreationDate();

    LanguageSettings setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    LanguageSettings setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    LanguageSettings setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    LanguageSettings setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    LanguageSettings setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    LanguageSettings setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    LanguageSettings setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    LanguageSettings setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    LanguageSettings setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    LanguageSettings setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    LanguageSettings setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    LanguageSettings setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    LanguageSettings setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    LanguageSettings setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    LanguageSettings setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    LanguageSettings setMetaRestoredBy(int value);

    String getLanguage();

    LanguageSettings setLanguage(String value);

    LanguageSkillLevel getLanguageSkillLevel();

    LanguageSettings setLanguageSkillLevel(LanguageSkillLevel value);


    static List<LanguageSettings> getAll() {
        return UdbLanguageSettings.getAll();
    }

    static List<LanguageSettings> getDeletedRecords() {
        return UdbLanguageSettings.getDeletedRecords();
    }

    static List<LanguageSettings> sort(List<LanguageSettings> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbLanguageSettings.sort(list, sortFieldName, ascending, userContext, path);
    }

    static int getCount() {
        return UdbLanguageSettings.getCount();
    }

    static LanguageSettingsQuery filter() {
        return new UdbLanguageSettingsQuery();
    }
}

