package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;


public interface OrganizationUnitQuery extends Query<OrganizationUnit> {

    static OrganizationUnitQuery create() {
        return new UdbOrganizationUnitQuery();
    }

    OrganizationUnitQuery id(Integer... ids);

    OrganizationUnitQuery id(BitSet ids);

    OrganizationUnitQuery id(Collection<Integer> ids);

    OrganizationUnitQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    OrganizationUnitQuery parseFullTextFilter(String query, String... fieldNames);

	OrganizationUnitQuery metaCreationDate(NumericFilter filter);

	OrganizationUnitQuery orMetaCreationDate(NumericFilter filter);

	OrganizationUnitQuery metaCreatedBy(NumericFilter filter);

	OrganizationUnitQuery orMetaCreatedBy(NumericFilter filter);

	OrganizationUnitQuery metaModificationDate(NumericFilter filter);

	OrganizationUnitQuery orMetaModificationDate(NumericFilter filter);

	OrganizationUnitQuery metaModifiedBy(NumericFilter filter);

	OrganizationUnitQuery orMetaModifiedBy(NumericFilter filter);

	OrganizationUnitQuery metaDeletionDate(NumericFilter filter);

	OrganizationUnitQuery orMetaDeletionDate(NumericFilter filter);

	OrganizationUnitQuery metaDeletedBy(NumericFilter filter);

	OrganizationUnitQuery orMetaDeletedBy(NumericFilter filter);

	OrganizationUnitQuery metaRestoreDate(NumericFilter filter);

	OrganizationUnitQuery orMetaRestoreDate(NumericFilter filter);

	OrganizationUnitQuery metaRestoredBy(NumericFilter filter);

	OrganizationUnitQuery orMetaRestoredBy(NumericFilter filter);

	OrganizationUnitQuery name(TranslatableTextFilter filter);

	OrganizationUnitQuery orName(TranslatableTextFilter filter);

	OrganizationUnitQuery filterParent(OrganizationUnitQuery query);

	OrganizationUnitQuery parent(NumericFilter filter);

	OrganizationUnitQuery orParent(NumericFilter filter);

	OrganizationUnitQuery filterChildren(OrganizationUnitQuery query);

	OrganizationUnitQuery children(MultiReferenceFilterType type, OrganizationUnit ... value);

	OrganizationUnitQuery childrenCount(MultiReferenceFilterType type, int count);

	OrganizationUnitQuery children(MultiReferenceFilter filter);

	OrganizationUnitQuery orChildren(MultiReferenceFilter filter);

	OrganizationUnitQuery filterType(OrganizationUnitTypeQuery query);

	OrganizationUnitQuery type(NumericFilter filter);

	OrganizationUnitQuery orType(NumericFilter filter);

	OrganizationUnitQuery icon(TextFilter filter);

	OrganizationUnitQuery orIcon(TextFilter filter);

	OrganizationUnitQuery orgUnitLifeCycleStatus(EnumFilterType filterType, OrgUnitLifeCycleStatus ... enums);

	OrganizationUnitQuery orOrgUnitLifeCycleStatus(EnumFilterType filterType, OrgUnitLifeCycleStatus ... enums);

	OrganizationUnitQuery filterAddress(AddressQuery query);

	OrganizationUnitQuery address(NumericFilter filter);

	OrganizationUnitQuery orAddress(NumericFilter filter);

	OrganizationUnitQuery filterUsers(UserQuery query);

	OrganizationUnitQuery users(MultiReferenceFilterType type, User ... value);

	OrganizationUnitQuery usersCount(MultiReferenceFilterType type, int count);

	OrganizationUnitQuery users(MultiReferenceFilter filter);

	OrganizationUnitQuery orUsers(MultiReferenceFilter filter);


    OrganizationUnitQuery andOr(OrganizationUnitQuery... queries);

    OrganizationUnitQuery customFilter(Function<OrganizationUnit, Boolean> customFilter);

}

