package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbApplicationVersionQuery extends AbstractUdbQuery<ApplicationVersion> implements ApplicationVersionQuery {

    public UdbApplicationVersionQuery() {
        super(UdbApplicationVersion.table, ApplicationVersion.getBuilder());
    }

    @Override
    public ApplicationVersionQuery id(Integer... ids) {
        return id(Arrays.asList(ids));
    }

    @Override
    public ApplicationVersionQuery id(BitSet ids) {
        filterById(ids);
        return this;
    }

    @Override
    public ApplicationVersionQuery id(Collection<Integer> ids) {
        filterById(ids);
        return this;
    }

	@Override
	public ApplicationVersionQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbApplicationVersion.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public ApplicationVersionQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbApplicationVersion.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public ApplicationVersionQuery metaCreationDate(NumericFilter filter) {
		and(UdbApplicationVersion.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbApplicationVersion.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery metaCreatedBy(NumericFilter filter) {
		and(UdbApplicationVersion.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbApplicationVersion.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery metaModificationDate(NumericFilter filter) {
		and(UdbApplicationVersion.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbApplicationVersion.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery metaModifiedBy(NumericFilter filter) {
		and(UdbApplicationVersion.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbApplicationVersion.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery metaDeletionDate(NumericFilter filter) {
		and(UdbApplicationVersion.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbApplicationVersion.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery metaDeletedBy(NumericFilter filter) {
		and(UdbApplicationVersion.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbApplicationVersion.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery metaRestoreDate(NumericFilter filter) {
		and(UdbApplicationVersion.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbApplicationVersion.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery metaRestoredBy(NumericFilter filter) {
		and(UdbApplicationVersion.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbApplicationVersion.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery filterApplication(ApplicationQuery query) {
		UdbApplicationQuery udbQuery = (UdbApplicationQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbApplicationVersion.application, UdbApplication.versions);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ApplicationVersionQuery application(NumericFilter filter) {
		and(UdbApplicationVersion.application.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery orApplication(NumericFilter filter) {
		or(UdbApplicationVersion.application.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery binary(FileFilter filter) {
		and(UdbApplicationVersion.binary.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery orBinary(FileFilter filter) {
		or(UdbApplicationVersion.binary.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery binaryHash(TextFilter filter) {
		and(UdbApplicationVersion.binaryHash.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery orBinaryHash(TextFilter filter) {
		or(UdbApplicationVersion.binaryHash.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery version(TextFilter filter) {
		and(UdbApplicationVersion.version.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery orVersion(TextFilter filter) {
		or(UdbApplicationVersion.version.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery releaseNotes(TextFilter filter) {
		and(UdbApplicationVersion.releaseNotes.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery orReleaseNotes(TextFilter filter) {
		or(UdbApplicationVersion.releaseNotes.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery filterDataModelData(ApplicationVersionDataQuery query) {
		UdbApplicationVersionDataQuery udbQuery = (UdbApplicationVersionDataQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbApplicationVersion.dataModelData);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ApplicationVersionQuery dataModelData(NumericFilter filter) {
		and(UdbApplicationVersion.dataModelData.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery orDataModelData(NumericFilter filter) {
		or(UdbApplicationVersion.dataModelData.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery filterLocalizationData(ApplicationVersionDataQuery query) {
		UdbApplicationVersionDataQuery udbQuery = (UdbApplicationVersionDataQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbApplicationVersion.localizationData);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ApplicationVersionQuery localizationData(NumericFilter filter) {
		and(UdbApplicationVersion.localizationData.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery orLocalizationData(NumericFilter filter) {
		or(UdbApplicationVersion.localizationData.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery filterPrivilegeData(ApplicationVersionDataQuery query) {
		UdbApplicationVersionDataQuery udbQuery = (UdbApplicationVersionDataQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbApplicationVersion.privilegeData);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ApplicationVersionQuery privilegeData(NumericFilter filter) {
		and(UdbApplicationVersion.privilegeData.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery orPrivilegeData(NumericFilter filter) {
		or(UdbApplicationVersion.privilegeData.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery filterPerspectiveData(ApplicationVersionDataQuery query) {
		UdbApplicationVersionDataQuery udbQuery = (UdbApplicationVersionDataQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbApplicationVersion.perspectiveData);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public ApplicationVersionQuery perspectiveData(NumericFilter filter) {
		and(UdbApplicationVersion.perspectiveData.createFilter(filter));
		return this;
	}

	@Override
	public ApplicationVersionQuery orPerspectiveData(NumericFilter filter) {
		or(UdbApplicationVersion.perspectiveData.createFilter(filter));
		return this;
	}


	@Override
	public UdbApplicationVersionQuery andOr(ApplicationVersionQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public ApplicationVersionQuery customFilter(Function<ApplicationVersion, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(ApplicationVersion.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



