package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbRole extends AbstractUdbEntity<Role> implements Role {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static TranslatableTextIndex title;
	protected static TextIndex icon;
	protected static ShortIndex roleType;
	protected static SingleReferenceIndex parent;
	protected static MultiReferenceIndex children;
	protected static SingleReferenceIndex organizationUnit;
	protected static MultiReferenceIndex allowedOrganizationUnitTypes;
	protected static SingleReferenceIndex organizationField;
	protected static BooleanIndex delegatedCustomPrivilegeObjectRole;
	protected static MultiReferenceIndex generalizationRoles;
	protected static MultiReferenceIndex specializationRoles;
	protected static MultiReferenceIndex privilegesReceivingRoles;
	protected static MultiReferenceIndex privilegesSendingRoles;
	protected static BooleanIndex noDirectMemberships;
	protected static MultiReferenceIndex userRoleAssignments;
	protected static MultiReferenceIndex privilegeAssignments;
	protected static MultiReferenceIndex applicationRoleAssignments;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORED_BY);
		title = (TranslatableTextIndex) tableIndex.getColumnIndex(FIELD_TITLE);
		icon = (TextIndex) tableIndex.getColumnIndex(FIELD_ICON);
		roleType = (ShortIndex) tableIndex.getColumnIndex(FIELD_ROLE_TYPE);
		parent = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_PARENT);
		children = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_CHILDREN);
		organizationUnit = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ORGANIZATION_UNIT);
		allowedOrganizationUnitTypes = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_ALLOWED_ORGANIZATION_UNIT_TYPES);
		organizationField = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ORGANIZATION_FIELD);
		delegatedCustomPrivilegeObjectRole = (BooleanIndex) tableIndex.getColumnIndex(FIELD_DELEGATED_CUSTOM_PRIVILEGE_OBJECT_ROLE);
		generalizationRoles = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_GENERALIZATION_ROLES);
		specializationRoles = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_SPECIALIZATION_ROLES);
		privilegesReceivingRoles = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_PRIVILEGES_RECEIVING_ROLES);
		privilegesSendingRoles = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_PRIVILEGES_SENDING_ROLES);
		noDirectMemberships = (BooleanIndex) tableIndex.getColumnIndex(FIELD_NO_DIRECT_MEMBERSHIPS);
		userRoleAssignments = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_USER_ROLE_ASSIGNMENTS);
		privilegeAssignments = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_PRIVILEGE_ASSIGNMENTS);
		applicationRoleAssignments = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_APPLICATION_ROLE_ASSIGNMENTS);
    }

    public static List<Role> getAll() {
        return new EntityBitSetList<>(Role.getBuilder(), table.getRecordBitSet());
    }

    public static List<Role> getDeletedRecords() {
        return new EntityBitSetList<>(Role.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<Role> sort(List<Role> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<Role> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, Role.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbRole() {
        super(table);
    }

    public UdbRole(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public Role build() {
        return new UdbRole();
    }

    @Override
    public Role build(int id) {
        return new UdbRole(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public Role setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public Role setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public Role setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public Role setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public Role setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public Role setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public Role setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public Role setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public Role setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public Role setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public Role setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public Role setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public Role setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public Role setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public Role setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public Role setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public TranslatableText getTitle() {
	    return getTranslatableTextValue(this.title);
	}

	@Override
	public Role setTitle(TranslatableText value) {
    	setTranslatableTextValue(value, this.title);
		return this;
	}

	@Override
	public String getIcon() {
        return getTextValue(icon);
	}

	@Override
	public Role setIcon(String value) {
	    setTextValue(value, this.icon);
		return this;
	}

	@Override
	public RoleType getRoleType() {
	    return getEnumValue(roleType, RoleType.values());
	}

	@Override
	public Role setRoleType(RoleType value) {
    	setEnumValue(this.roleType, value);
		return this;
	}

	@Override
	public Role getParent() {
		if (isChanged(parent)) {
			return (Role) getReferenceChangeValue(parent);
		} else {
			int id = parent.getValue(getId());
			if (id > 0) {
				return Role.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public Role setParent(Role value) {
		setSingleReferenceValue(parent, value, table);
		return this;
	}

	@Override
	public List<Role> getChildren() {
	    return getMultiReferenceValue(children, Role.getBuilder());
	}

	@Override
	public Role setChildren(List<Role> value) {
		setMultiReferenceValue(value, children);
		return this;
	}

	@Override
	public int getChildrenCount() {
	    return getMultiReferenceValueCount(children, Role.getBuilder());
	}

	@Override
	public Role setChildren(Role ... value) {
		setMultiReferenceValue(Arrays.asList(value), children);
		return this;
	}

	@Override
	public BitSet getChildrenAsBitSet() {
	    return getMultiReferenceValueAsBitSet(children, Role.getBuilder());
	}

	@Override
	public Role addChildren(List<Role> value) {
		addMultiReferenceValue(value, children);
		return this;
	}

	@Override
	public Role addChildren(Role ... value) {
		addMultiReferenceValue(Arrays.asList(value), children);
		return this;
	}

	@Override
	public Role removeChildren(List<Role> value) {
		removeMultiReferenceValue(value, children);
		return this;
	}

	@Override
	public Role removeChildren(Role ... value) {
		removeMultiReferenceValue(Arrays.asList(value), children);
		return this;
	}

	@Override
	public Role removeAllChildren() {
		removeAllMultiReferenceValue(children);
		return this;
	}

	@Override
	public OrganizationUnit getOrganizationUnit() {
		if (isChanged(organizationUnit)) {
			return (OrganizationUnit) getReferenceChangeValue(organizationUnit);
		} else {
			int id = organizationUnit.getValue(getId());
			if (id > 0) {
				return OrganizationUnit.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public Role setOrganizationUnit(OrganizationUnit value) {
		setSingleReferenceValue(organizationUnit, value, table);
		return this;
	}

	@Override
	public List<OrganizationUnitType> getAllowedOrganizationUnitTypes() {
	    return getMultiReferenceValue(allowedOrganizationUnitTypes, OrganizationUnitType.getBuilder());
	}

	@Override
	public Role setAllowedOrganizationUnitTypes(List<OrganizationUnitType> value) {
		setMultiReferenceValue(value, allowedOrganizationUnitTypes);
		return this;
	}

	@Override
	public int getAllowedOrganizationUnitTypesCount() {
	    return getMultiReferenceValueCount(allowedOrganizationUnitTypes, OrganizationUnitType.getBuilder());
	}

	@Override
	public Role setAllowedOrganizationUnitTypes(OrganizationUnitType ... value) {
		setMultiReferenceValue(Arrays.asList(value), allowedOrganizationUnitTypes);
		return this;
	}

	@Override
	public BitSet getAllowedOrganizationUnitTypesAsBitSet() {
	    return getMultiReferenceValueAsBitSet(allowedOrganizationUnitTypes, OrganizationUnitType.getBuilder());
	}

	@Override
	public Role addAllowedOrganizationUnitTypes(List<OrganizationUnitType> value) {
		addMultiReferenceValue(value, allowedOrganizationUnitTypes);
		return this;
	}

	@Override
	public Role addAllowedOrganizationUnitTypes(OrganizationUnitType ... value) {
		addMultiReferenceValue(Arrays.asList(value), allowedOrganizationUnitTypes);
		return this;
	}

	@Override
	public Role removeAllowedOrganizationUnitTypes(List<OrganizationUnitType> value) {
		removeMultiReferenceValue(value, allowedOrganizationUnitTypes);
		return this;
	}

	@Override
	public Role removeAllowedOrganizationUnitTypes(OrganizationUnitType ... value) {
		removeMultiReferenceValue(Arrays.asList(value), allowedOrganizationUnitTypes);
		return this;
	}

	@Override
	public Role removeAllAllowedOrganizationUnitTypes() {
		removeAllMultiReferenceValue(allowedOrganizationUnitTypes);
		return this;
	}

	@Override
	public OrganizationField getOrganizationField() {
		if (isChanged(organizationField)) {
			return (OrganizationField) getReferenceChangeValue(organizationField);
		} else {
			int id = organizationField.getValue(getId());
			if (id > 0) {
				return OrganizationField.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public Role setOrganizationField(OrganizationField value) {
		setSingleReferenceValue(organizationField, value, table);
		return this;
	}

	@Override
	public boolean getDelegatedCustomPrivilegeObjectRole() {
	    return getBooleanValue(delegatedCustomPrivilegeObjectRole);
	}

	@Override
	public Role setDelegatedCustomPrivilegeObjectRole(boolean value) {
	    setBooleanValue(value, this.delegatedCustomPrivilegeObjectRole);
		return this;
	}

	@Override
	public boolean isDelegatedCustomPrivilegeObjectRole() {
	    return getBooleanValue(delegatedCustomPrivilegeObjectRole);
	}

	@Override
	public List<Role> getGeneralizationRoles() {
	    return getMultiReferenceValue(generalizationRoles, Role.getBuilder());
	}

	@Override
	public Role setGeneralizationRoles(List<Role> value) {
		setMultiReferenceValue(value, generalizationRoles);
		return this;
	}

	@Override
	public int getGeneralizationRolesCount() {
	    return getMultiReferenceValueCount(generalizationRoles, Role.getBuilder());
	}

	@Override
	public Role setGeneralizationRoles(Role ... value) {
		setMultiReferenceValue(Arrays.asList(value), generalizationRoles);
		return this;
	}

	@Override
	public BitSet getGeneralizationRolesAsBitSet() {
	    return getMultiReferenceValueAsBitSet(generalizationRoles, Role.getBuilder());
	}

	@Override
	public Role addGeneralizationRoles(List<Role> value) {
		addMultiReferenceValue(value, generalizationRoles);
		return this;
	}

	@Override
	public Role addGeneralizationRoles(Role ... value) {
		addMultiReferenceValue(Arrays.asList(value), generalizationRoles);
		return this;
	}

	@Override
	public Role removeGeneralizationRoles(List<Role> value) {
		removeMultiReferenceValue(value, generalizationRoles);
		return this;
	}

	@Override
	public Role removeGeneralizationRoles(Role ... value) {
		removeMultiReferenceValue(Arrays.asList(value), generalizationRoles);
		return this;
	}

	@Override
	public Role removeAllGeneralizationRoles() {
		removeAllMultiReferenceValue(generalizationRoles);
		return this;
	}

	@Override
	public List<Role> getSpecializationRoles() {
	    return getMultiReferenceValue(specializationRoles, Role.getBuilder());
	}

	@Override
	public Role setSpecializationRoles(List<Role> value) {
		setMultiReferenceValue(value, specializationRoles);
		return this;
	}

	@Override
	public int getSpecializationRolesCount() {
	    return getMultiReferenceValueCount(specializationRoles, Role.getBuilder());
	}

	@Override
	public Role setSpecializationRoles(Role ... value) {
		setMultiReferenceValue(Arrays.asList(value), specializationRoles);
		return this;
	}

	@Override
	public BitSet getSpecializationRolesAsBitSet() {
	    return getMultiReferenceValueAsBitSet(specializationRoles, Role.getBuilder());
	}

	@Override
	public Role addSpecializationRoles(List<Role> value) {
		addMultiReferenceValue(value, specializationRoles);
		return this;
	}

	@Override
	public Role addSpecializationRoles(Role ... value) {
		addMultiReferenceValue(Arrays.asList(value), specializationRoles);
		return this;
	}

	@Override
	public Role removeSpecializationRoles(List<Role> value) {
		removeMultiReferenceValue(value, specializationRoles);
		return this;
	}

	@Override
	public Role removeSpecializationRoles(Role ... value) {
		removeMultiReferenceValue(Arrays.asList(value), specializationRoles);
		return this;
	}

	@Override
	public Role removeAllSpecializationRoles() {
		removeAllMultiReferenceValue(specializationRoles);
		return this;
	}

	@Override
	public List<Role> getPrivilegesReceivingRoles() {
	    return getMultiReferenceValue(privilegesReceivingRoles, Role.getBuilder());
	}

	@Override
	public Role setPrivilegesReceivingRoles(List<Role> value) {
		setMultiReferenceValue(value, privilegesReceivingRoles);
		return this;
	}

	@Override
	public int getPrivilegesReceivingRolesCount() {
	    return getMultiReferenceValueCount(privilegesReceivingRoles, Role.getBuilder());
	}

	@Override
	public Role setPrivilegesReceivingRoles(Role ... value) {
		setMultiReferenceValue(Arrays.asList(value), privilegesReceivingRoles);
		return this;
	}

	@Override
	public BitSet getPrivilegesReceivingRolesAsBitSet() {
	    return getMultiReferenceValueAsBitSet(privilegesReceivingRoles, Role.getBuilder());
	}

	@Override
	public Role addPrivilegesReceivingRoles(List<Role> value) {
		addMultiReferenceValue(value, privilegesReceivingRoles);
		return this;
	}

	@Override
	public Role addPrivilegesReceivingRoles(Role ... value) {
		addMultiReferenceValue(Arrays.asList(value), privilegesReceivingRoles);
		return this;
	}

	@Override
	public Role removePrivilegesReceivingRoles(List<Role> value) {
		removeMultiReferenceValue(value, privilegesReceivingRoles);
		return this;
	}

	@Override
	public Role removePrivilegesReceivingRoles(Role ... value) {
		removeMultiReferenceValue(Arrays.asList(value), privilegesReceivingRoles);
		return this;
	}

	@Override
	public Role removeAllPrivilegesReceivingRoles() {
		removeAllMultiReferenceValue(privilegesReceivingRoles);
		return this;
	}

	@Override
	public List<Role> getPrivilegesSendingRoles() {
	    return getMultiReferenceValue(privilegesSendingRoles, Role.getBuilder());
	}

	@Override
	public Role setPrivilegesSendingRoles(List<Role> value) {
		setMultiReferenceValue(value, privilegesSendingRoles);
		return this;
	}

	@Override
	public int getPrivilegesSendingRolesCount() {
	    return getMultiReferenceValueCount(privilegesSendingRoles, Role.getBuilder());
	}

	@Override
	public Role setPrivilegesSendingRoles(Role ... value) {
		setMultiReferenceValue(Arrays.asList(value), privilegesSendingRoles);
		return this;
	}

	@Override
	public BitSet getPrivilegesSendingRolesAsBitSet() {
	    return getMultiReferenceValueAsBitSet(privilegesSendingRoles, Role.getBuilder());
	}

	@Override
	public Role addPrivilegesSendingRoles(List<Role> value) {
		addMultiReferenceValue(value, privilegesSendingRoles);
		return this;
	}

	@Override
	public Role addPrivilegesSendingRoles(Role ... value) {
		addMultiReferenceValue(Arrays.asList(value), privilegesSendingRoles);
		return this;
	}

	@Override
	public Role removePrivilegesSendingRoles(List<Role> value) {
		removeMultiReferenceValue(value, privilegesSendingRoles);
		return this;
	}

	@Override
	public Role removePrivilegesSendingRoles(Role ... value) {
		removeMultiReferenceValue(Arrays.asList(value), privilegesSendingRoles);
		return this;
	}

	@Override
	public Role removeAllPrivilegesSendingRoles() {
		removeAllMultiReferenceValue(privilegesSendingRoles);
		return this;
	}

	@Override
	public boolean getNoDirectMemberships() {
	    return getBooleanValue(noDirectMemberships);
	}

	@Override
	public Role setNoDirectMemberships(boolean value) {
	    setBooleanValue(value, this.noDirectMemberships);
		return this;
	}

	@Override
	public boolean isNoDirectMemberships() {
	    return getBooleanValue(noDirectMemberships);
	}

	@Override
	public List<UserRoleAssignment> getUserRoleAssignments() {
	    return getMultiReferenceValue(userRoleAssignments, UserRoleAssignment.getBuilder());
	}

	@Override
	public Role setUserRoleAssignments(List<UserRoleAssignment> value) {
		setMultiReferenceValue(value, userRoleAssignments);
		return this;
	}

	@Override
	public int getUserRoleAssignmentsCount() {
	    return getMultiReferenceValueCount(userRoleAssignments, UserRoleAssignment.getBuilder());
	}

	@Override
	public Role setUserRoleAssignments(UserRoleAssignment ... value) {
		setMultiReferenceValue(Arrays.asList(value), userRoleAssignments);
		return this;
	}

	@Override
	public BitSet getUserRoleAssignmentsAsBitSet() {
	    return getMultiReferenceValueAsBitSet(userRoleAssignments, UserRoleAssignment.getBuilder());
	}

	@Override
	public Role addUserRoleAssignments(List<UserRoleAssignment> value) {
		addMultiReferenceValue(value, userRoleAssignments);
		return this;
	}

	@Override
	public Role addUserRoleAssignments(UserRoleAssignment ... value) {
		addMultiReferenceValue(Arrays.asList(value), userRoleAssignments);
		return this;
	}

	@Override
	public Role removeUserRoleAssignments(List<UserRoleAssignment> value) {
		removeMultiReferenceValue(value, userRoleAssignments);
		return this;
	}

	@Override
	public Role removeUserRoleAssignments(UserRoleAssignment ... value) {
		removeMultiReferenceValue(Arrays.asList(value), userRoleAssignments);
		return this;
	}

	@Override
	public Role removeAllUserRoleAssignments() {
		removeAllMultiReferenceValue(userRoleAssignments);
		return this;
	}

	@Override
	public List<RolePrivilegeAssignment> getPrivilegeAssignments() {
	    return getMultiReferenceValue(privilegeAssignments, RolePrivilegeAssignment.getBuilder());
	}

	@Override
	public Role setPrivilegeAssignments(List<RolePrivilegeAssignment> value) {
		setMultiReferenceValue(value, privilegeAssignments);
		return this;
	}

	@Override
	public int getPrivilegeAssignmentsCount() {
	    return getMultiReferenceValueCount(privilegeAssignments, RolePrivilegeAssignment.getBuilder());
	}

	@Override
	public Role setPrivilegeAssignments(RolePrivilegeAssignment ... value) {
		setMultiReferenceValue(Arrays.asList(value), privilegeAssignments);
		return this;
	}

	@Override
	public BitSet getPrivilegeAssignmentsAsBitSet() {
	    return getMultiReferenceValueAsBitSet(privilegeAssignments, RolePrivilegeAssignment.getBuilder());
	}

	@Override
	public Role addPrivilegeAssignments(List<RolePrivilegeAssignment> value) {
		addMultiReferenceValue(value, privilegeAssignments);
		return this;
	}

	@Override
	public Role addPrivilegeAssignments(RolePrivilegeAssignment ... value) {
		addMultiReferenceValue(Arrays.asList(value), privilegeAssignments);
		return this;
	}

	@Override
	public Role removePrivilegeAssignments(List<RolePrivilegeAssignment> value) {
		removeMultiReferenceValue(value, privilegeAssignments);
		return this;
	}

	@Override
	public Role removePrivilegeAssignments(RolePrivilegeAssignment ... value) {
		removeMultiReferenceValue(Arrays.asList(value), privilegeAssignments);
		return this;
	}

	@Override
	public Role removeAllPrivilegeAssignments() {
		removeAllMultiReferenceValue(privilegeAssignments);
		return this;
	}

	@Override
	public List<RoleApplicationRoleAssignment> getApplicationRoleAssignments() {
	    return getMultiReferenceValue(applicationRoleAssignments, RoleApplicationRoleAssignment.getBuilder());
	}

	@Override
	public Role setApplicationRoleAssignments(List<RoleApplicationRoleAssignment> value) {
		setMultiReferenceValue(value, applicationRoleAssignments);
		return this;
	}

	@Override
	public int getApplicationRoleAssignmentsCount() {
	    return getMultiReferenceValueCount(applicationRoleAssignments, RoleApplicationRoleAssignment.getBuilder());
	}

	@Override
	public Role setApplicationRoleAssignments(RoleApplicationRoleAssignment ... value) {
		setMultiReferenceValue(Arrays.asList(value), applicationRoleAssignments);
		return this;
	}

	@Override
	public BitSet getApplicationRoleAssignmentsAsBitSet() {
	    return getMultiReferenceValueAsBitSet(applicationRoleAssignments, RoleApplicationRoleAssignment.getBuilder());
	}

	@Override
	public Role addApplicationRoleAssignments(List<RoleApplicationRoleAssignment> value) {
		addMultiReferenceValue(value, applicationRoleAssignments);
		return this;
	}

	@Override
	public Role addApplicationRoleAssignments(RoleApplicationRoleAssignment ... value) {
		addMultiReferenceValue(Arrays.asList(value), applicationRoleAssignments);
		return this;
	}

	@Override
	public Role removeApplicationRoleAssignments(List<RoleApplicationRoleAssignment> value) {
		removeMultiReferenceValue(value, applicationRoleAssignments);
		return this;
	}

	@Override
	public Role removeApplicationRoleAssignments(RoleApplicationRoleAssignment ... value) {
		removeMultiReferenceValue(Arrays.asList(value), applicationRoleAssignments);
		return this;
	}

	@Override
	public Role removeAllApplicationRoleAssignments() {
		removeAllMultiReferenceValue(applicationRoleAssignments);
		return this;
	}



    @Override
    public UdbRole save() {
        saveRecord();
        return this;
    }

    @Override
    public void delete() {
        deleteRecord();
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord();
    }
}



