package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbUserGroupMembership extends AbstractUdbEntity<UserGroupMembership> implements UserGroupMembership {
	protected static TableIndex table;
	protected static SingleReferenceIndex group;
	protected static SingleReferenceIndex user;
	protected static ShortIndex groupMembershipRole;
	protected static BooleanIndex membershipRejected;
	protected static ShortIndex groupMembershipNotificationSetting;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		group = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_GROUP);
		user = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_USER);
		groupMembershipRole = (ShortIndex) tableIndex.getColumnIndex(FIELD_GROUP_MEMBERSHIP_ROLE);
		membershipRejected = (BooleanIndex) tableIndex.getColumnIndex(FIELD_MEMBERSHIP_REJECTED);
		groupMembershipNotificationSetting = (ShortIndex) tableIndex.getColumnIndex(FIELD_GROUP_MEMBERSHIP_NOTIFICATION_SETTING);
    }

    public static List<UserGroupMembership> getAll() {
        return new EntityBitSetList<>(UserGroupMembership.getBuilder(), table.getRecordBitSet());
    }

    public static List<UserGroupMembership> getDeletedRecords() {
        return new EntityBitSetList<>(UserGroupMembership.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<UserGroupMembership> sort(List<UserGroupMembership> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<UserGroupMembership> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, UserGroupMembership.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbUserGroupMembership() {
        super(table);
    }

    public UdbUserGroupMembership(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public UserGroupMembership build() {
        return new UdbUserGroupMembership();
    }

    @Override
    public UserGroupMembership build(int id) {
        return new UdbUserGroupMembership(id, false);
    }

	@Override
	public Group getGroup() {
		if (isChanged(group)) {
			return (Group) getReferenceChangeValue(group);
		} else {
			int id = group.getValue(getId());
			if (id > 0) {
				return Group.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public UserGroupMembership setGroup(Group value) {
		setSingleReferenceValue(group, value, table);
		return this;
	}

	@Override
	public User getUser() {
		if (isChanged(user)) {
			return (User) getReferenceChangeValue(user);
		} else {
			int id = user.getValue(getId());
			if (id > 0) {
				return User.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public UserGroupMembership setUser(User value) {
		setSingleReferenceValue(user, value, table);
		return this;
	}

	@Override
	public GroupMembershipRole getGroupMembershipRole() {
	    return getEnumValue(groupMembershipRole, GroupMembershipRole.values());
	}

	@Override
	public UserGroupMembership setGroupMembershipRole(GroupMembershipRole value) {
    	setEnumValue(this.groupMembershipRole, value);
		return this;
	}

	@Override
	public boolean getMembershipRejected() {
	    return getBooleanValue(membershipRejected);
	}

	@Override
	public UserGroupMembership setMembershipRejected(boolean value) {
	    setBooleanValue(value, this.membershipRejected);
		return this;
	}

	@Override
	public boolean isMembershipRejected() {
	    return getBooleanValue(membershipRejected);
	}

	@Override
	public GroupMembershipNotificationSetting getGroupMembershipNotificationSetting() {
	    return getEnumValue(groupMembershipNotificationSetting, GroupMembershipNotificationSetting.values());
	}

	@Override
	public UserGroupMembership setGroupMembershipNotificationSetting(GroupMembershipNotificationSetting value) {
    	setEnumValue(this.groupMembershipNotificationSetting, value);
		return this;
	}



    @Override
    public UdbUserGroupMembership save() {
        saveRecord();
        return this;
    }

    @Override
    public void delete() {
        deleteRecord();
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord();
    }
}



