/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.model.controlcenter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.function.Function;
import org.teamapps.model.controlcenter.ApplicationQuery;
import org.teamapps.model.controlcenter.LocalizationKey;
import org.teamapps.model.controlcenter.LocalizationKeyFormat;
import org.teamapps.model.controlcenter.LocalizationKeyQuery;
import org.teamapps.model.controlcenter.LocalizationKeyType;
import org.teamapps.model.controlcenter.LocalizationTopic;
import org.teamapps.model.controlcenter.LocalizationTopicQuery;
import org.teamapps.model.controlcenter.LocalizationValue;
import org.teamapps.model.controlcenter.LocalizationValueQuery;
import org.teamapps.model.controlcenter.UdbApplicationQuery;
import org.teamapps.model.controlcenter.UdbLocalizationKey;
import org.teamapps.model.controlcenter.UdbLocalizationTopic;
import org.teamapps.model.controlcenter.UdbLocalizationTopicQuery;
import org.teamapps.model.controlcenter.UdbLocalizationValue;
import org.teamapps.model.controlcenter.UdbLocalizationValueQuery;
import org.teamapps.universaldb.index.bool.BooleanFilter;
import org.teamapps.universaldb.index.enumeration.EnumFilterType;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceFilter;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceFilterType;
import org.teamapps.universaldb.index.text.TextFilter;
import org.teamapps.universaldb.pojo.AbstractUdbQuery;
import org.teamapps.universaldb.query.CustomEntityFilter;
import org.teamapps.universaldb.query.IndexPath;

public class UdbLocalizationKeyQuery
extends AbstractUdbQuery<LocalizationKey>
implements LocalizationKeyQuery {
    public UdbLocalizationKeyQuery() {
        super(UdbLocalizationKey.table, LocalizationKey.getBuilder());
    }

    @Override
    public LocalizationKeyQuery id(Integer ... ids) {
        return this.id(Arrays.asList(ids));
    }

    @Override
    public LocalizationKeyQuery id(BitSet ids) {
        this.filterById(ids);
        return this;
    }

    @Override
    public LocalizationKeyQuery id(Collection<Integer> ids) {
        this.filterById(ids);
        return this;
    }

    @Override
    public LocalizationKeyQuery fullTextFilter(TextFilter textFilter, String ... fieldNames) {
        this.and(UdbLocalizationKey.table.createFullTextFilter(textFilter, fieldNames));
        return this;
    }

    @Override
    public LocalizationKeyQuery parseFullTextFilter(String query, String ... fieldNames) {
        this.and(UdbLocalizationKey.table.createFullTextFilter(query, fieldNames));
        return this;
    }

    @Override
    public LocalizationKeyQuery metaCreationDate(NumericFilter filter) {
        this.and(UdbLocalizationKey.metaCreationDate.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery orMetaCreationDate(NumericFilter filter) {
        this.or(UdbLocalizationKey.metaCreationDate.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery metaCreatedBy(NumericFilter filter) {
        this.and(UdbLocalizationKey.metaCreatedBy.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery orMetaCreatedBy(NumericFilter filter) {
        this.or(UdbLocalizationKey.metaCreatedBy.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery metaModificationDate(NumericFilter filter) {
        this.and(UdbLocalizationKey.metaModificationDate.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery orMetaModificationDate(NumericFilter filter) {
        this.or(UdbLocalizationKey.metaModificationDate.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery metaModifiedBy(NumericFilter filter) {
        this.and(UdbLocalizationKey.metaModifiedBy.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery orMetaModifiedBy(NumericFilter filter) {
        this.or(UdbLocalizationKey.metaModifiedBy.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery metaDeletionDate(NumericFilter filter) {
        this.and(UdbLocalizationKey.metaDeletionDate.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery orMetaDeletionDate(NumericFilter filter) {
        this.or(UdbLocalizationKey.metaDeletionDate.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery metaDeletedBy(NumericFilter filter) {
        this.and(UdbLocalizationKey.metaDeletedBy.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery orMetaDeletedBy(NumericFilter filter) {
        this.or(UdbLocalizationKey.metaDeletedBy.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery metaRestoreDate(NumericFilter filter) {
        this.and(UdbLocalizationKey.metaRestoreDate.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery orMetaRestoreDate(NumericFilter filter) {
        this.or(UdbLocalizationKey.metaRestoreDate.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery metaRestoredBy(NumericFilter filter) {
        this.and(UdbLocalizationKey.metaRestoredBy.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery orMetaRestoredBy(NumericFilter filter) {
        this.or(UdbLocalizationKey.metaRestoredBy.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery filterApplication(ApplicationQuery query) {
        UdbApplicationQuery udbQuery = (UdbApplicationQuery)query;
        IndexPath path = new IndexPath();
        path.addPath(UdbLocalizationKey.application);
        udbQuery.prependPath(path);
        this.and(udbQuery);
        return this;
    }

    @Override
    public LocalizationKeyQuery application(NumericFilter filter) {
        this.and(UdbLocalizationKey.application.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery orApplication(NumericFilter filter) {
        this.or(UdbLocalizationKey.application.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery key(TextFilter filter) {
        this.and(UdbLocalizationKey.key.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery orKey(TextFilter filter) {
        this.or(UdbLocalizationKey.key.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery used(BooleanFilter filter) {
        this.and(UdbLocalizationKey.used.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery orUsed(BooleanFilter filter) {
        this.or(UdbLocalizationKey.used.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery localizationKeyFormat(EnumFilterType filterType, LocalizationKeyFormat ... enums) {
        this.and(UdbLocalizationKey.localizationKeyFormat.createFilter((Object)NumericFilter.createEnumFilter((EnumFilterType)filterType, (Enum[])enums)));
        return this;
    }

    @Override
    public LocalizationKeyQuery orLocalizationKeyFormat(EnumFilterType filterType, LocalizationKeyFormat ... enums) {
        this.or(UdbLocalizationKey.localizationKeyFormat.createFilter((Object)NumericFilter.createEnumFilter((EnumFilterType)filterType, (Enum[])enums)));
        return this;
    }

    @Override
    public LocalizationKeyQuery localizationKeyType(EnumFilterType filterType, LocalizationKeyType ... enums) {
        this.and(UdbLocalizationKey.localizationKeyType.createFilter((Object)NumericFilter.createEnumFilter((EnumFilterType)filterType, (Enum[])enums)));
        return this;
    }

    @Override
    public LocalizationKeyQuery orLocalizationKeyType(EnumFilterType filterType, LocalizationKeyType ... enums) {
        this.or(UdbLocalizationKey.localizationKeyType.createFilter((Object)NumericFilter.createEnumFilter((EnumFilterType)filterType, (Enum[])enums)));
        return this;
    }

    @Override
    public LocalizationKeyQuery comments(TextFilter filter) {
        this.and(UdbLocalizationKey.comments.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery orComments(TextFilter filter) {
        this.or(UdbLocalizationKey.comments.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery filterLocalizationValues(LocalizationValueQuery query) {
        UdbLocalizationValueQuery udbQuery = (UdbLocalizationValueQuery)query;
        IndexPath path = new IndexPath();
        path.addPath(UdbLocalizationKey.localizationValues, UdbLocalizationValue.localizationKey);
        udbQuery.prependPath(path);
        this.and(udbQuery);
        return this;
    }

    @Override
    public LocalizationKeyQuery localizationValues(MultiReferenceFilterType type, LocalizationValue ... values) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (values != null) {
            for (LocalizationValue value : values) {
                ids.add(value.getId());
            }
        }
        MultiReferenceFilter filter = MultiReferenceFilter.createFilter((MultiReferenceFilterType)type, ids);
        this.and(UdbLocalizationKey.localizationValues.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery localizationValuesCount(MultiReferenceFilterType type, int count) {
        MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter((MultiReferenceFilterType)type, (int)count);
        this.and(UdbLocalizationKey.localizationValues.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery localizationValues(MultiReferenceFilter filter) {
        this.and(UdbLocalizationKey.localizationValues.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery orLocalizationValues(MultiReferenceFilter filter) {
        this.or(UdbLocalizationKey.localizationValues.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery filterTopics(LocalizationTopicQuery query) {
        UdbLocalizationTopicQuery udbQuery = (UdbLocalizationTopicQuery)query;
        IndexPath path = new IndexPath();
        path.addPath(UdbLocalizationKey.topics, UdbLocalizationTopic.keys);
        udbQuery.prependPath(path);
        this.and(udbQuery);
        return this;
    }

    @Override
    public LocalizationKeyQuery topics(MultiReferenceFilterType type, LocalizationTopic ... values) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (values != null) {
            for (LocalizationTopic value : values) {
                ids.add(value.getId());
            }
        }
        MultiReferenceFilter filter = MultiReferenceFilter.createFilter((MultiReferenceFilterType)type, ids);
        this.and(UdbLocalizationKey.topics.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery topicsCount(MultiReferenceFilterType type, int count) {
        MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter((MultiReferenceFilterType)type, (int)count);
        this.and(UdbLocalizationKey.topics.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery topics(MultiReferenceFilter filter) {
        this.and(UdbLocalizationKey.topics.createFilter((Object)filter));
        return this;
    }

    @Override
    public LocalizationKeyQuery orTopics(MultiReferenceFilter filter) {
        this.or(UdbLocalizationKey.topics.createFilter((Object)filter));
        return this;
    }

    @Override
    public UdbLocalizationKeyQuery andOr(LocalizationKeyQuery ... queries) {
        AbstractUdbQuery[] abstractUdbQueries = (AbstractUdbQuery[])Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
        this.andOr(abstractUdbQueries);
        return this;
    }

    @Override
    public LocalizationKeyQuery customFilter(Function<LocalizationKey, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> (Boolean)customFilter.apply(LocalizationKey.getById(id));
        this.and(new CustomEntityFilter(filterFunction));
        return this;
    }
}

