/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.model.controlcenter;

import java.io.File;
import java.time.Instant;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.teamapps.model.controlcenter.ApplicationFolder;
import org.teamapps.model.controlcenter.Appointment;
import org.teamapps.model.controlcenter.AppointmentSeries;
import org.teamapps.model.controlcenter.GroupFolder;
import org.teamapps.model.controlcenter.Message;
import org.teamapps.model.controlcenter.MessageRecipientType;
import org.teamapps.model.controlcenter.MessageType;
import org.teamapps.model.controlcenter.User;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.file.FileIndex;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.numeric.ShortIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.EntityBitSetList;

public class UdbMessage
extends AbstractUdbEntity<Message>
implements Message {
    protected static TableIndex table;
    protected static IntegerIndex metaCreationDate;
    protected static IntegerIndex metaCreatedBy;
    protected static IntegerIndex metaModificationDate;
    protected static IntegerIndex metaModifiedBy;
    protected static IntegerIndex metaDeletionDate;
    protected static IntegerIndex metaDeletedBy;
    protected static IntegerIndex metaRestoreDate;
    protected static IntegerIndex metaRestoredBy;
    protected static ShortIndex messageRecipientType;
    protected static MultiReferenceIndex privateRecipients;
    protected static SingleReferenceIndex groupFolder;
    protected static SingleReferenceIndex applicationFolder;
    protected static TextIndex subject;
    protected static TextIndex message;
    protected static ShortIndex messageType;
    protected static FileIndex file;
    protected static SingleReferenceIndex appointment;
    protected static SingleReferenceIndex appointmentSeries;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
        metaCreationDate = (IntegerIndex)tableIndex.getColumnIndex("metaCreationDate");
        metaCreatedBy = (IntegerIndex)tableIndex.getColumnIndex("metaCreatedBy");
        metaModificationDate = (IntegerIndex)tableIndex.getColumnIndex("metaModificationDate");
        metaModifiedBy = (IntegerIndex)tableIndex.getColumnIndex("metaModifiedBy");
        metaDeletionDate = (IntegerIndex)tableIndex.getColumnIndex("metaDeletionDate");
        metaDeletedBy = (IntegerIndex)tableIndex.getColumnIndex("metaDeletedBy");
        metaRestoreDate = (IntegerIndex)tableIndex.getColumnIndex("metaRestoreDate");
        metaRestoredBy = (IntegerIndex)tableIndex.getColumnIndex("metaRestoredBy");
        messageRecipientType = (ShortIndex)tableIndex.getColumnIndex("messageRecipientType");
        privateRecipients = (MultiReferenceIndex)tableIndex.getColumnIndex("privateRecipients");
        groupFolder = (SingleReferenceIndex)tableIndex.getColumnIndex("groupFolder");
        applicationFolder = (SingleReferenceIndex)tableIndex.getColumnIndex("applicationFolder");
        subject = (TextIndex)tableIndex.getColumnIndex("subject");
        message = (TextIndex)tableIndex.getColumnIndex("message");
        messageType = (ShortIndex)tableIndex.getColumnIndex("messageType");
        file = (FileIndex)tableIndex.getColumnIndex("file");
        appointment = (SingleReferenceIndex)tableIndex.getColumnIndex("appointment");
        appointmentSeries = (SingleReferenceIndex)tableIndex.getColumnIndex("appointmentSeries");
    }

    public static List<Message> getAll() {
        return new EntityBitSetList(Message.getBuilder(), table.getRecordBitSet());
    }

    public static List<Message> getDeletedRecords() {
        return new EntityBitSetList(Message.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<Message> sort(List<Message> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbMessage.sort((TableIndex)table, list, (String)sortFieldName, (boolean)ascending, (UserContext)userContext, (String[])path);
    }

    public static List<Message> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbMessage.sort((TableIndex)table, Message.getBuilder(), (BitSet)recordIds, (String)sortFieldName, (boolean)ascending, (UserContext)userContext, (String[])path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbMessage() {
        super(table);
    }

    public UdbMessage(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    public Message build() {
        return new UdbMessage();
    }

    public Message build(int id) {
        return new UdbMessage(id, false);
    }

    @Override
    public Instant getMetaCreationDate() {
        return this.getTimestampValue(metaCreationDate);
    }

    @Override
    public Message setMetaCreationDate(Instant value) {
        this.setTimestampValue(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaCreationDate);
    }

    @Override
    public Message setMetaCreationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaCreationDate);
        return this;
    }

    @Override
    public long getMetaCreationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaCreationDate);
    }

    @Override
    public Message setMetaCreationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaCreationDate);
        return this;
    }

    @Override
    public int getMetaCreatedBy() {
        return this.getIntValue(metaCreatedBy);
    }

    @Override
    public Message setMetaCreatedBy(int value) {
        this.setIntValue(value, metaCreatedBy);
        return this;
    }

    @Override
    public Instant getMetaModificationDate() {
        return this.getTimestampValue(metaModificationDate);
    }

    @Override
    public Message setMetaModificationDate(Instant value) {
        this.setTimestampValue(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModificationDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaModificationDate);
    }

    @Override
    public Message setMetaModificationDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaModificationDate);
        return this;
    }

    @Override
    public long getMetaModificationDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaModificationDate);
    }

    @Override
    public Message setMetaModificationDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaModificationDate);
        return this;
    }

    @Override
    public int getMetaModifiedBy() {
        return this.getIntValue(metaModifiedBy);
    }

    @Override
    public Message setMetaModifiedBy(int value) {
        this.setIntValue(value, metaModifiedBy);
        return this;
    }

    @Override
    public Instant getMetaDeletionDate() {
        return this.getTimestampValue(metaDeletionDate);
    }

    @Override
    public Message setMetaDeletionDate(Instant value) {
        this.setTimestampValue(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletionDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaDeletionDate);
    }

    @Override
    public Message setMetaDeletionDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaDeletionDate);
        return this;
    }

    @Override
    public long getMetaDeletionDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaDeletionDate);
    }

    @Override
    public Message setMetaDeletionDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaDeletionDate);
        return this;
    }

    @Override
    public int getMetaDeletedBy() {
        return this.getIntValue(metaDeletedBy);
    }

    @Override
    public Message setMetaDeletedBy(int value) {
        this.setIntValue(value, metaDeletedBy);
        return this;
    }

    @Override
    public Instant getMetaRestoreDate() {
        return this.getTimestampValue(metaRestoreDate);
    }

    @Override
    public Message setMetaRestoreDate(Instant value) {
        this.setTimestampValue(value, metaRestoreDate);
        return this;
    }

    @Override
    public int getMetaRestoreDateAsEpochSecond() {
        return this.getTimestampAsEpochSecond(metaRestoreDate);
    }

    @Override
    public Message setMetaRestoreDateAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, metaRestoreDate);
        return this;
    }

    @Override
    public long getMetaRestoreDateAsEpochMilli() {
        return this.getTimestampAsEpochMilli(metaRestoreDate);
    }

    @Override
    public Message setMetaRestoreDateAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, metaRestoreDate);
        return this;
    }

    @Override
    public int getMetaRestoredBy() {
        return this.getIntValue(metaRestoredBy);
    }

    @Override
    public Message setMetaRestoredBy(int value) {
        this.setIntValue(value, metaRestoredBy);
        return this;
    }

    @Override
    public MessageRecipientType getMessageRecipientType() {
        return (MessageRecipientType)this.getEnumValue(messageRecipientType, MessageRecipientType.values());
    }

    @Override
    public Message setMessageRecipientType(MessageRecipientType value) {
        this.setEnumValue(messageRecipientType, value);
        return this;
    }

    @Override
    public List<User> getPrivateRecipients() {
        return this.getMultiReferenceValue(privateRecipients, User.getBuilder());
    }

    @Override
    public Message setPrivateRecipients(List<User> value) {
        this.setMultiReferenceValue(value, privateRecipients);
        return this;
    }

    @Override
    public int getPrivateRecipientsCount() {
        return this.getMultiReferenceValueCount(privateRecipients, User.getBuilder());
    }

    @Override
    public Message setPrivateRecipients(User ... value) {
        this.setMultiReferenceValue(Arrays.asList(value), privateRecipients);
        return this;
    }

    @Override
    public BitSet getPrivateRecipientsAsBitSet() {
        return this.getMultiReferenceValueAsBitSet(privateRecipients, User.getBuilder());
    }

    @Override
    public Message addPrivateRecipients(List<User> value) {
        this.addMultiReferenceValue(value, privateRecipients);
        return this;
    }

    @Override
    public Message addPrivateRecipients(User ... value) {
        this.addMultiReferenceValue(Arrays.asList(value), privateRecipients);
        return this;
    }

    @Override
    public Message removePrivateRecipients(List<User> value) {
        this.removeMultiReferenceValue(value, privateRecipients);
        return this;
    }

    @Override
    public Message removePrivateRecipients(User ... value) {
        this.removeMultiReferenceValue(Arrays.asList(value), privateRecipients);
        return this;
    }

    @Override
    public Message removeAllPrivateRecipients() {
        this.removeAllMultiReferenceValue(privateRecipients);
        return this;
    }

    @Override
    public GroupFolder getGroupFolder() {
        if (this.isChanged((ColumnIndex)groupFolder)) {
            return (GroupFolder)this.getReferenceChangeValue((ColumnIndex)groupFolder);
        }
        int id = groupFolder.getValue(this.getId());
        if (id > 0) {
            return GroupFolder.getById(id);
        }
        return null;
    }

    @Override
    public Message setGroupFolder(GroupFolder value) {
        this.setSingleReferenceValue(groupFolder, value, table);
        return this;
    }

    @Override
    public ApplicationFolder getApplicationFolder() {
        if (this.isChanged((ColumnIndex)applicationFolder)) {
            return (ApplicationFolder)this.getReferenceChangeValue((ColumnIndex)applicationFolder);
        }
        int id = applicationFolder.getValue(this.getId());
        if (id > 0) {
            return ApplicationFolder.getById(id);
        }
        return null;
    }

    @Override
    public Message setApplicationFolder(ApplicationFolder value) {
        this.setSingleReferenceValue(applicationFolder, value, table);
        return this;
    }

    @Override
    public String getSubject() {
        return this.getTextValue(subject);
    }

    @Override
    public Message setSubject(String value) {
        this.setTextValue(value, subject);
        return this;
    }

    @Override
    public String getMessage() {
        return this.getTextValue(message);
    }

    @Override
    public Message setMessage(String value) {
        this.setTextValue(value, message);
        return this;
    }

    @Override
    public MessageType getMessageType() {
        return (MessageType)this.getEnumValue(messageType, MessageType.values());
    }

    @Override
    public Message setMessageType(MessageType value) {
        this.setEnumValue(messageType, value);
        return this;
    }

    @Override
    public FileValue getFile() {
        if (this.isChanged((ColumnIndex)file)) {
            return (FileValue)this.getChangedValue((ColumnIndex)file);
        }
        return file.getValue(this.getId());
    }

    @Override
    public Message setFile(File value) {
        FileValue storeFile = file.storeFile(value);
        this.setChangeValue((ColumnIndex)file, storeFile, table);
        return this;
    }

    @Override
    public Message setFile(File value, String fileName) {
        FileValue storeFile = file.storeFile(value, fileName);
        this.setChangeValue((ColumnIndex)file, storeFile, table);
        return this;
    }

    @Override
    public Appointment getAppointment() {
        if (this.isChanged((ColumnIndex)appointment)) {
            return (Appointment)this.getReferenceChangeValue((ColumnIndex)appointment);
        }
        int id = appointment.getValue(this.getId());
        if (id > 0) {
            return Appointment.getById(id);
        }
        return null;
    }

    @Override
    public Message setAppointment(Appointment value) {
        this.setSingleReferenceValue(appointment, value, table);
        return this;
    }

    @Override
    public AppointmentSeries getAppointmentSeries() {
        if (this.isChanged((ColumnIndex)appointmentSeries)) {
            return (AppointmentSeries)this.getReferenceChangeValue((ColumnIndex)appointmentSeries);
        }
        int id = appointmentSeries.getValue(this.getId());
        if (id > 0) {
            return AppointmentSeries.getById(id);
        }
        return null;
    }

    @Override
    public Message setAppointmentSeries(AppointmentSeries value) {
        this.setSingleReferenceValue(appointmentSeries, value, table);
        return this;
    }

    public UdbMessage save() {
        this.saveRecord();
        return this;
    }

    public void delete() {
        this.deleteRecord();
    }

    public void restoreDeleted() {
        this.restoreDeletedRecord();
    }
}

