package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;


public interface LanguageSettingsQuery extends Query<LanguageSettings> {

    static LanguageSettingsQuery create() {
        return new UdbLanguageSettingsQuery();
    }

    LanguageSettingsQuery id(Integer... ids);

    LanguageSettingsQuery id(BitSet ids);

    LanguageSettingsQuery id(Collection<Integer> ids);

    LanguageSettingsQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    LanguageSettingsQuery parseFullTextFilter(String query, String... fieldNames);

	LanguageSettingsQuery metaCreationDate(NumericFilter filter);

	LanguageSettingsQuery orMetaCreationDate(NumericFilter filter);

	LanguageSettingsQuery metaCreatedBy(NumericFilter filter);

	LanguageSettingsQuery orMetaCreatedBy(NumericFilter filter);

	LanguageSettingsQuery metaModificationDate(NumericFilter filter);

	LanguageSettingsQuery orMetaModificationDate(NumericFilter filter);

	LanguageSettingsQuery metaModifiedBy(NumericFilter filter);

	LanguageSettingsQuery orMetaModifiedBy(NumericFilter filter);

	LanguageSettingsQuery metaDeletionDate(NumericFilter filter);

	LanguageSettingsQuery orMetaDeletionDate(NumericFilter filter);

	LanguageSettingsQuery metaDeletedBy(NumericFilter filter);

	LanguageSettingsQuery orMetaDeletedBy(NumericFilter filter);

	LanguageSettingsQuery metaRestoreDate(NumericFilter filter);

	LanguageSettingsQuery orMetaRestoreDate(NumericFilter filter);

	LanguageSettingsQuery metaRestoredBy(NumericFilter filter);

	LanguageSettingsQuery orMetaRestoredBy(NumericFilter filter);

	LanguageSettingsQuery language(TextFilter filter);

	LanguageSettingsQuery orLanguage(TextFilter filter);

	LanguageSettingsQuery languageSkillLevel(EnumFilterType filterType, LanguageSkillLevel ... enums);

	LanguageSettingsQuery orLanguageSkillLevel(EnumFilterType filterType, LanguageSkillLevel ... enums);


    LanguageSettingsQuery andOr(LanguageSettingsQuery... queries);

    LanguageSettingsQuery customFilter(Function<LanguageSettings, Boolean> customFilter);

}

