package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbLanguageSettingsQuery extends AbstractUdbQuery<LanguageSettings> implements LanguageSettingsQuery {

    public UdbLanguageSettingsQuery() {
        super(UdbLanguageSettings.table, LanguageSettings.getBuilder());
    }

    @Override
    public LanguageSettingsQuery id(Integer... ids) {
        return id(Arrays.asList(ids));
    }

    @Override
    public LanguageSettingsQuery id(BitSet ids) {
        filterById(ids);
        return this;
    }

    @Override
    public LanguageSettingsQuery id(Collection<Integer> ids) {
        filterById(ids);
        return this;
    }

	@Override
	public LanguageSettingsQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbLanguageSettings.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public LanguageSettingsQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbLanguageSettings.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public LanguageSettingsQuery metaCreationDate(NumericFilter filter) {
		and(UdbLanguageSettings.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public LanguageSettingsQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbLanguageSettings.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public LanguageSettingsQuery metaCreatedBy(NumericFilter filter) {
		and(UdbLanguageSettings.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public LanguageSettingsQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbLanguageSettings.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public LanguageSettingsQuery metaModificationDate(NumericFilter filter) {
		and(UdbLanguageSettings.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public LanguageSettingsQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbLanguageSettings.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public LanguageSettingsQuery metaModifiedBy(NumericFilter filter) {
		and(UdbLanguageSettings.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public LanguageSettingsQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbLanguageSettings.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public LanguageSettingsQuery metaDeletionDate(NumericFilter filter) {
		and(UdbLanguageSettings.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public LanguageSettingsQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbLanguageSettings.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public LanguageSettingsQuery metaDeletedBy(NumericFilter filter) {
		and(UdbLanguageSettings.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public LanguageSettingsQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbLanguageSettings.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public LanguageSettingsQuery metaRestoreDate(NumericFilter filter) {
		and(UdbLanguageSettings.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public LanguageSettingsQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbLanguageSettings.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public LanguageSettingsQuery metaRestoredBy(NumericFilter filter) {
		and(UdbLanguageSettings.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public LanguageSettingsQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbLanguageSettings.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public LanguageSettingsQuery language(TextFilter filter) {
		and(UdbLanguageSettings.language.createFilter(filter));
		return this;
	}

	@Override
	public LanguageSettingsQuery orLanguage(TextFilter filter) {
		or(UdbLanguageSettings.language.createFilter(filter));
		return this;
	}

	@Override
	public LanguageSettingsQuery languageSkillLevel(EnumFilterType filterType, LanguageSkillLevel... enums) {
		and(UdbLanguageSettings.languageSkillLevel.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public LanguageSettingsQuery orLanguageSkillLevel(EnumFilterType filterType, LanguageSkillLevel... enums) {
		or(UdbLanguageSettings.languageSkillLevel.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}


	@Override
	public UdbLanguageSettingsQuery andOr(LanguageSettingsQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public LanguageSettingsQuery customFilter(Function<LanguageSettings, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(LanguageSettings.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



