package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbSystemSettingsQuery extends AbstractUdbQuery<SystemSettings> implements SystemSettingsQuery {

    public UdbSystemSettingsQuery() {
        super(UdbSystemSettings.table, SystemSettings.getBuilder());
    }

    @Override
    public SystemSettingsQuery id(Integer... ids) {
        return id(Arrays.asList(ids));
    }

    @Override
    public SystemSettingsQuery id(BitSet ids) {
        filterById(ids);
        return this;
    }

    @Override
    public SystemSettingsQuery id(Collection<Integer> ids) {
        filterById(ids);
        return this;
    }

	@Override
	public SystemSettingsQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbSystemSettings.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public SystemSettingsQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbSystemSettings.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public SystemSettingsQuery metaCreationDate(NumericFilter filter) {
		and(UdbSystemSettings.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public SystemSettingsQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbSystemSettings.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public SystemSettingsQuery metaCreatedBy(NumericFilter filter) {
		and(UdbSystemSettings.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public SystemSettingsQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbSystemSettings.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public SystemSettingsQuery metaModificationDate(NumericFilter filter) {
		and(UdbSystemSettings.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public SystemSettingsQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbSystemSettings.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public SystemSettingsQuery metaModifiedBy(NumericFilter filter) {
		and(UdbSystemSettings.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public SystemSettingsQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbSystemSettings.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public SystemSettingsQuery metaDeletionDate(NumericFilter filter) {
		and(UdbSystemSettings.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public SystemSettingsQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbSystemSettings.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public SystemSettingsQuery metaDeletedBy(NumericFilter filter) {
		and(UdbSystemSettings.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public SystemSettingsQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbSystemSettings.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public SystemSettingsQuery metaRestoreDate(NumericFilter filter) {
		and(UdbSystemSettings.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public SystemSettingsQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbSystemSettings.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public SystemSettingsQuery metaRestoredBy(NumericFilter filter) {
		and(UdbSystemSettings.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public SystemSettingsQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbSystemSettings.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public SystemSettingsQuery allowedBaseLanguages(TextFilter filter) {
		and(UdbSystemSettings.allowedBaseLanguages.createFilter(filter));
		return this;
	}

	@Override
	public SystemSettingsQuery orAllowedBaseLanguages(TextFilter filter) {
		or(UdbSystemSettings.allowedBaseLanguages.createFilter(filter));
		return this;
	}


	@Override
	public UdbSystemSettingsQuery andOr(SystemSettingsQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public SystemSettingsQuery customFilter(Function<SystemSettings, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(SystemSettings.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



