package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbUser extends AbstractUdbEntity<User> implements User {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static TextIndex firstName;
	protected static TextIndex firstNameTranslated;
	protected static TextIndex lastName;
	protected static TextIndex lastNameTranslated;
	protected static BinaryIndex profilePicture;
	protected static BinaryIndex profilePictureLarge;
	protected static TextIndex language;
	protected static TextIndex email;
	protected static TextIndex mobile;
	protected static TextIndex phone;
	protected static TextIndex login;
	protected static IntegerIndex lastLogin;
	protected static TextIndex password;
	protected static TextIndex theme;
	protected static BooleanIndex darkTheme;
	protected static ShortIndex userAccountStatus;
	protected static SingleReferenceIndex acceptedPolicies;
	protected static SingleReferenceIndex address;
	protected static SingleReferenceIndex organizationUnit;
	protected static MultiReferenceIndex accessTokens;
	protected static MultiReferenceIndex roleAssignments;
	protected static MultiReferenceIndex allGroupMemberships;
	protected static MultiReferenceIndex privateMessages;
	protected static MultiReferenceIndex languageSettings;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORED_BY);
		firstName = (TextIndex) tableIndex.getColumnIndex(FIELD_FIRST_NAME);
		firstNameTranslated = (TextIndex) tableIndex.getColumnIndex(FIELD_FIRST_NAME_TRANSLATED);
		lastName = (TextIndex) tableIndex.getColumnIndex(FIELD_LAST_NAME);
		lastNameTranslated = (TextIndex) tableIndex.getColumnIndex(FIELD_LAST_NAME_TRANSLATED);
		profilePicture = (BinaryIndex) tableIndex.getColumnIndex(FIELD_PROFILE_PICTURE);
		profilePictureLarge = (BinaryIndex) tableIndex.getColumnIndex(FIELD_PROFILE_PICTURE_LARGE);
		language = (TextIndex) tableIndex.getColumnIndex(FIELD_LANGUAGE);
		email = (TextIndex) tableIndex.getColumnIndex(FIELD_EMAIL);
		mobile = (TextIndex) tableIndex.getColumnIndex(FIELD_MOBILE);
		phone = (TextIndex) tableIndex.getColumnIndex(FIELD_PHONE);
		login = (TextIndex) tableIndex.getColumnIndex(FIELD_LOGIN);
		lastLogin = (IntegerIndex) tableIndex.getColumnIndex(FIELD_LAST_LOGIN);
		password = (TextIndex) tableIndex.getColumnIndex(FIELD_PASSWORD);
		theme = (TextIndex) tableIndex.getColumnIndex(FIELD_THEME);
		darkTheme = (BooleanIndex) tableIndex.getColumnIndex(FIELD_DARK_THEME);
		userAccountStatus = (ShortIndex) tableIndex.getColumnIndex(FIELD_USER_ACCOUNT_STATUS);
		acceptedPolicies = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ACCEPTED_POLICIES);
		address = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ADDRESS);
		organizationUnit = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ORGANIZATION_UNIT);
		accessTokens = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_ACCESS_TOKENS);
		roleAssignments = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_ROLE_ASSIGNMENTS);
		allGroupMemberships = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_ALL_GROUP_MEMBERSHIPS);
		privateMessages = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_PRIVATE_MESSAGES);
		languageSettings = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_LANGUAGE_SETTINGS);
    }

    public static List<User> getAll() {
        return new EntityBitSetList<>(User.getBuilder(), table.getRecordBitSet());
    }

    public static List<User> getDeletedRecords() {
        return new EntityBitSetList<>(User.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<User> sort(List<User> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<User> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, User.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbUser() {
        super(table);
    }

    public UdbUser(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public User build() {
        return new UdbUser();
    }

    @Override
    public User build(int id) {
        return new UdbUser(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public User setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public User setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public User setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public User setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public User setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public User setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public User setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public User setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public User setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public User setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public User setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public User setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public User setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public User setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public User setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public User setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public String getFirstName() {
        return getTextValue(firstName);
	}

	@Override
	public User setFirstName(String value) {
	    setTextValue(value, this.firstName);
		return this;
	}

	@Override
	public String getFirstNameTranslated() {
        return getTextValue(firstNameTranslated);
	}

	@Override
	public User setFirstNameTranslated(String value) {
	    setTextValue(value, this.firstNameTranslated);
		return this;
	}

	@Override
	public String getLastName() {
        return getTextValue(lastName);
	}

	@Override
	public User setLastName(String value) {
	    setTextValue(value, this.lastName);
		return this;
	}

	@Override
	public String getLastNameTranslated() {
        return getTextValue(lastNameTranslated);
	}

	@Override
	public User setLastNameTranslated(String value) {
	    setTextValue(value, this.lastNameTranslated);
		return this;
	}

	@Override
	public byte[] getProfilePicture() {
		if (isChanged(profilePicture)) {
			return (byte[]) getChangedValue(profilePicture);
		} else {
			return profilePicture.getValue(getId());
		}
	}

	@Override
	public User setProfilePicture(byte[] value) {
		setChangeValue(this.profilePicture, value, table);
		return this;
	}

	@Override
	public int getProfilePictureLength() {
		if (isChanged(profilePicture)) {
			byte[] bytes = (byte[]) getChangedValue(profilePicture);
			return bytes != null ? bytes.length : 0;
		} else {
			return profilePicture.getLength(getId());
		}
	}

	@Override
	public Supplier<InputStream> getProfilePictureInputStreamSupplier() {
		if (isChanged(profilePicture)) {
			byte[] bytes = (byte[]) getChangedValue(profilePicture);
			if (bytes == null) return null;
			return () -> new ByteArrayInputStream(bytes);
		} else {
			return profilePicture.getInputStreamSupplier(getId());
		}
	}

	@Override
	public byte[] getProfilePictureLarge() {
		if (isChanged(profilePictureLarge)) {
			return (byte[]) getChangedValue(profilePictureLarge);
		} else {
			return profilePictureLarge.getValue(getId());
		}
	}

	@Override
	public User setProfilePictureLarge(byte[] value) {
		setChangeValue(this.profilePictureLarge, value, table);
		return this;
	}

	@Override
	public int getProfilePictureLargeLength() {
		if (isChanged(profilePictureLarge)) {
			byte[] bytes = (byte[]) getChangedValue(profilePictureLarge);
			return bytes != null ? bytes.length : 0;
		} else {
			return profilePictureLarge.getLength(getId());
		}
	}

	@Override
	public Supplier<InputStream> getProfilePictureLargeInputStreamSupplier() {
		if (isChanged(profilePictureLarge)) {
			byte[] bytes = (byte[]) getChangedValue(profilePictureLarge);
			if (bytes == null) return null;
			return () -> new ByteArrayInputStream(bytes);
		} else {
			return profilePictureLarge.getInputStreamSupplier(getId());
		}
	}

	@Override
	public String getLanguage() {
        return getTextValue(language);
	}

	@Override
	public User setLanguage(String value) {
	    setTextValue(value, this.language);
		return this;
	}

	@Override
	public String getEmail() {
        return getTextValue(email);
	}

	@Override
	public User setEmail(String value) {
	    setTextValue(value, this.email);
		return this;
	}

	@Override
	public String getMobile() {
        return getTextValue(mobile);
	}

	@Override
	public User setMobile(String value) {
	    setTextValue(value, this.mobile);
		return this;
	}

	@Override
	public String getPhone() {
        return getTextValue(phone);
	}

	@Override
	public User setPhone(String value) {
	    setTextValue(value, this.phone);
		return this;
	}

	@Override
	public String getLogin() {
        return getTextValue(login);
	}

	@Override
	public User setLogin(String value) {
	    setTextValue(value, this.login);
		return this;
	}

	@Override
	public Instant getLastLogin() {
	    return getTimestampValue(lastLogin);
	}

	@Override
	public User setLastLogin(Instant value) {
	    setTimestampValue(value, this.lastLogin);
		return this;
	}

	@Override
	public int getLastLoginAsEpochSecond() {
	    return getTimestampAsEpochSecond(lastLogin);
	}

	@Override
	public User setLastLoginAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.lastLogin);
		return this;
	}

	@Override
	public long getLastLoginAsEpochMilli() {
	    return getTimestampAsEpochMilli(lastLogin);
	}

	@Override
	public User setLastLoginAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.lastLogin);
		return this;
	}

	@Override
	public String getPassword() {
        return getTextValue(password);
	}

	@Override
	public User setPassword(String value) {
	    setTextValue(value, this.password);
		return this;
	}

	@Override
	public String getTheme() {
        return getTextValue(theme);
	}

	@Override
	public User setTheme(String value) {
	    setTextValue(value, this.theme);
		return this;
	}

	@Override
	public boolean getDarkTheme() {
	    return getBooleanValue(darkTheme);
	}

	@Override
	public User setDarkTheme(boolean value) {
	    setBooleanValue(value, this.darkTheme);
		return this;
	}

	@Override
	public boolean isDarkTheme() {
	    return getBooleanValue(darkTheme);
	}

	@Override
	public UserAccountStatus getUserAccountStatus() {
	    return getEnumValue(userAccountStatus, UserAccountStatus.values());
	}

	@Override
	public User setUserAccountStatus(UserAccountStatus value) {
    	setEnumValue(this.userAccountStatus, value);
		return this;
	}

	@Override
	public UserAcceptedPolicy getAcceptedPolicies() {
		if (isChanged(acceptedPolicies)) {
			return (UserAcceptedPolicy) getReferenceChangeValue(acceptedPolicies);
		} else {
			int id = acceptedPolicies.getValue(getId());
			if (id > 0) {
				return UserAcceptedPolicy.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public User setAcceptedPolicies(UserAcceptedPolicy value) {
		setSingleReferenceValue(acceptedPolicies, value, table);
		return this;
	}

	@Override
	public Address getAddress() {
		if (isChanged(address)) {
			return (Address) getReferenceChangeValue(address);
		} else {
			int id = address.getValue(getId());
			if (id > 0) {
				return Address.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public User setAddress(Address value) {
		setSingleReferenceValue(address, value, table);
		return this;
	}

	@Override
	public OrganizationUnit getOrganizationUnit() {
		if (isChanged(organizationUnit)) {
			return (OrganizationUnit) getReferenceChangeValue(organizationUnit);
		} else {
			int id = organizationUnit.getValue(getId());
			if (id > 0) {
				return OrganizationUnit.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public User setOrganizationUnit(OrganizationUnit value) {
		setSingleReferenceValue(organizationUnit, value, table);
		return this;
	}

	@Override
	public List<UserAccessToken> getAccessTokens() {
	    return getMultiReferenceValue(accessTokens, UserAccessToken.getBuilder());
	}

	@Override
	public User setAccessTokens(List<UserAccessToken> value) {
		setMultiReferenceValue(value, accessTokens);
		return this;
	}

	@Override
	public int getAccessTokensCount() {
	    return getMultiReferenceValueCount(accessTokens, UserAccessToken.getBuilder());
	}

	@Override
	public User setAccessTokens(UserAccessToken ... value) {
		setMultiReferenceValue(Arrays.asList(value), accessTokens);
		return this;
	}

	@Override
	public BitSet getAccessTokensAsBitSet() {
	    return getMultiReferenceValueAsBitSet(accessTokens, UserAccessToken.getBuilder());
	}

	@Override
	public User addAccessTokens(List<UserAccessToken> value) {
		addMultiReferenceValue(value, accessTokens);
		return this;
	}

	@Override
	public User addAccessTokens(UserAccessToken ... value) {
		addMultiReferenceValue(Arrays.asList(value), accessTokens);
		return this;
	}

	@Override
	public User removeAccessTokens(List<UserAccessToken> value) {
		removeMultiReferenceValue(value, accessTokens);
		return this;
	}

	@Override
	public User removeAccessTokens(UserAccessToken ... value) {
		removeMultiReferenceValue(Arrays.asList(value), accessTokens);
		return this;
	}

	@Override
	public User removeAllAccessTokens() {
		removeAllMultiReferenceValue(accessTokens);
		return this;
	}

	@Override
	public List<UserRoleAssignment> getRoleAssignments() {
	    return getMultiReferenceValue(roleAssignments, UserRoleAssignment.getBuilder());
	}

	@Override
	public User setRoleAssignments(List<UserRoleAssignment> value) {
		setMultiReferenceValue(value, roleAssignments);
		return this;
	}

	@Override
	public int getRoleAssignmentsCount() {
	    return getMultiReferenceValueCount(roleAssignments, UserRoleAssignment.getBuilder());
	}

	@Override
	public User setRoleAssignments(UserRoleAssignment ... value) {
		setMultiReferenceValue(Arrays.asList(value), roleAssignments);
		return this;
	}

	@Override
	public BitSet getRoleAssignmentsAsBitSet() {
	    return getMultiReferenceValueAsBitSet(roleAssignments, UserRoleAssignment.getBuilder());
	}

	@Override
	public User addRoleAssignments(List<UserRoleAssignment> value) {
		addMultiReferenceValue(value, roleAssignments);
		return this;
	}

	@Override
	public User addRoleAssignments(UserRoleAssignment ... value) {
		addMultiReferenceValue(Arrays.asList(value), roleAssignments);
		return this;
	}

	@Override
	public User removeRoleAssignments(List<UserRoleAssignment> value) {
		removeMultiReferenceValue(value, roleAssignments);
		return this;
	}

	@Override
	public User removeRoleAssignments(UserRoleAssignment ... value) {
		removeMultiReferenceValue(Arrays.asList(value), roleAssignments);
		return this;
	}

	@Override
	public User removeAllRoleAssignments() {
		removeAllMultiReferenceValue(roleAssignments);
		return this;
	}

	@Override
	public List<UserGroupMembership> getAllGroupMemberships() {
	    return getMultiReferenceValue(allGroupMemberships, UserGroupMembership.getBuilder());
	}

	@Override
	public User setAllGroupMemberships(List<UserGroupMembership> value) {
		setMultiReferenceValue(value, allGroupMemberships);
		return this;
	}

	@Override
	public int getAllGroupMembershipsCount() {
	    return getMultiReferenceValueCount(allGroupMemberships, UserGroupMembership.getBuilder());
	}

	@Override
	public User setAllGroupMemberships(UserGroupMembership ... value) {
		setMultiReferenceValue(Arrays.asList(value), allGroupMemberships);
		return this;
	}

	@Override
	public BitSet getAllGroupMembershipsAsBitSet() {
	    return getMultiReferenceValueAsBitSet(allGroupMemberships, UserGroupMembership.getBuilder());
	}

	@Override
	public User addAllGroupMemberships(List<UserGroupMembership> value) {
		addMultiReferenceValue(value, allGroupMemberships);
		return this;
	}

	@Override
	public User addAllGroupMemberships(UserGroupMembership ... value) {
		addMultiReferenceValue(Arrays.asList(value), allGroupMemberships);
		return this;
	}

	@Override
	public User removeAllGroupMemberships(List<UserGroupMembership> value) {
		removeMultiReferenceValue(value, allGroupMemberships);
		return this;
	}

	@Override
	public User removeAllGroupMemberships(UserGroupMembership ... value) {
		removeMultiReferenceValue(Arrays.asList(value), allGroupMemberships);
		return this;
	}

	@Override
	public User removeAllAllGroupMemberships() {
		removeAllMultiReferenceValue(allGroupMemberships);
		return this;
	}

	@Override
	public List<Message> getPrivateMessages() {
	    return getMultiReferenceValue(privateMessages, Message.getBuilder());
	}

	@Override
	public User setPrivateMessages(List<Message> value) {
		setMultiReferenceValue(value, privateMessages);
		return this;
	}

	@Override
	public int getPrivateMessagesCount() {
	    return getMultiReferenceValueCount(privateMessages, Message.getBuilder());
	}

	@Override
	public User setPrivateMessages(Message ... value) {
		setMultiReferenceValue(Arrays.asList(value), privateMessages);
		return this;
	}

	@Override
	public BitSet getPrivateMessagesAsBitSet() {
	    return getMultiReferenceValueAsBitSet(privateMessages, Message.getBuilder());
	}

	@Override
	public User addPrivateMessages(List<Message> value) {
		addMultiReferenceValue(value, privateMessages);
		return this;
	}

	@Override
	public User addPrivateMessages(Message ... value) {
		addMultiReferenceValue(Arrays.asList(value), privateMessages);
		return this;
	}

	@Override
	public User removePrivateMessages(List<Message> value) {
		removeMultiReferenceValue(value, privateMessages);
		return this;
	}

	@Override
	public User removePrivateMessages(Message ... value) {
		removeMultiReferenceValue(Arrays.asList(value), privateMessages);
		return this;
	}

	@Override
	public User removeAllPrivateMessages() {
		removeAllMultiReferenceValue(privateMessages);
		return this;
	}

	@Override
	public List<LanguageSettings> getLanguageSettings() {
	    return getMultiReferenceValue(languageSettings, LanguageSettings.getBuilder());
	}

	@Override
	public User setLanguageSettings(List<LanguageSettings> value) {
		setMultiReferenceValue(value, languageSettings);
		return this;
	}

	@Override
	public int getLanguageSettingsCount() {
	    return getMultiReferenceValueCount(languageSettings, LanguageSettings.getBuilder());
	}

	@Override
	public User setLanguageSettings(LanguageSettings ... value) {
		setMultiReferenceValue(Arrays.asList(value), languageSettings);
		return this;
	}

	@Override
	public BitSet getLanguageSettingsAsBitSet() {
	    return getMultiReferenceValueAsBitSet(languageSettings, LanguageSettings.getBuilder());
	}

	@Override
	public User addLanguageSettings(List<LanguageSettings> value) {
		addMultiReferenceValue(value, languageSettings);
		return this;
	}

	@Override
	public User addLanguageSettings(LanguageSettings ... value) {
		addMultiReferenceValue(Arrays.asList(value), languageSettings);
		return this;
	}

	@Override
	public User removeLanguageSettings(List<LanguageSettings> value) {
		removeMultiReferenceValue(value, languageSettings);
		return this;
	}

	@Override
	public User removeLanguageSettings(LanguageSettings ... value) {
		removeMultiReferenceValue(Arrays.asList(value), languageSettings);
		return this;
	}

	@Override
	public User removeAllLanguageSettings() {
		removeAllMultiReferenceValue(languageSettings);
		return this;
	}



    @Override
    public UdbUser save() {
        saveRecord();
        return this;
    }

    @Override
    public void delete() {
        deleteRecord();
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord();
    }
}



