package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;
import org.teamapps.universaldb.index.transaction.request.*;


import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbUserView extends AbstractUdbEntity<UserView> implements UserView {
	protected static TableIndex table;
	protected static TextIndex firstName;
	protected static TextIndex firstNameTranslated;
	protected static TextIndex lastName;
	protected static TextIndex lastNameTranslated;
	protected static BinaryIndex profilePicture;
	protected static BinaryIndex profilePictureLarge;
	protected static TextIndex language;
	protected static SingleReferenceIndex organizationUnit;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		firstName = (TextIndex) tableIndex.getColumnIndex(FIELD_FIRST_NAME);
		firstNameTranslated = (TextIndex) tableIndex.getColumnIndex(FIELD_FIRST_NAME_TRANSLATED);
		lastName = (TextIndex) tableIndex.getColumnIndex(FIELD_LAST_NAME);
		lastNameTranslated = (TextIndex) tableIndex.getColumnIndex(FIELD_LAST_NAME_TRANSLATED);
		profilePicture = (BinaryIndex) tableIndex.getColumnIndex(FIELD_PROFILE_PICTURE);
		profilePictureLarge = (BinaryIndex) tableIndex.getColumnIndex(FIELD_PROFILE_PICTURE_LARGE);
		language = (TextIndex) tableIndex.getColumnIndex(FIELD_LANGUAGE);
		organizationUnit = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ORGANIZATION_UNIT);
    }

    public static List<UserView> getAll() {
        return new EntityBitSetList<>(UserView.getBuilder(), table.getRecordBitSet());
    }

    public static List<UserView> sort(List<UserView> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<UserView> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, UserView.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbUserView() {
        super(table);
    }

    public UdbUserView(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public UserView build() {
        return new UdbUserView();
    }

    @Override
    public UserView build(int id) {
        return new UdbUserView(id, false);
    }

	@Override
	public String getFirstName() {
        return getTextValue(firstName);
	}

	@Override
	public String getFirstNameTranslated() {
        return getTextValue(firstNameTranslated);
	}

	@Override
	public String getLastName() {
        return getTextValue(lastName);
	}

	@Override
	public String getLastNameTranslated() {
        return getTextValue(lastNameTranslated);
	}

	@Override
	public byte[] getProfilePicture() {
		if (isChanged(profilePicture)) {
			return (byte[]) getChangedValue(profilePicture);
		} else {
			return profilePicture.getValue(getId());
		}
	}

	@Override
	public int getProfilePictureLength() {
		if (isChanged(profilePicture)) {
			byte[] bytes = (byte[]) getChangedValue(profilePicture);
			return bytes != null ? bytes.length : 0;
		} else {
			return profilePicture.getLength(getId());
		}
	}

	@Override
	public Supplier<InputStream> getProfilePictureInputStreamSupplier() {
		if (isChanged(profilePicture)) {
			byte[] bytes = (byte[]) getChangedValue(profilePicture);
			if (bytes == null) return null;
			return () -> new ByteArrayInputStream(bytes);
		} else {
			return profilePicture.getInputStreamSupplier(getId());
		}
	}

	@Override
	public byte[] getProfilePictureLarge() {
		if (isChanged(profilePictureLarge)) {
			return (byte[]) getChangedValue(profilePictureLarge);
		} else {
			return profilePictureLarge.getValue(getId());
		}
	}

	@Override
	public int getProfilePictureLargeLength() {
		if (isChanged(profilePictureLarge)) {
			byte[] bytes = (byte[]) getChangedValue(profilePictureLarge);
			return bytes != null ? bytes.length : 0;
		} else {
			return profilePictureLarge.getLength(getId());
		}
	}

	@Override
	public Supplier<InputStream> getProfilePictureLargeInputStreamSupplier() {
		if (isChanged(profilePictureLarge)) {
			byte[] bytes = (byte[]) getChangedValue(profilePictureLarge);
			if (bytes == null) return null;
			return () -> new ByteArrayInputStream(bytes);
		} else {
			return profilePictureLarge.getInputStreamSupplier(getId());
		}
	}

	@Override
	public String getLanguage() {
        return getTextValue(language);
	}

	@Override
	public OrganizationUnitView getOrganizationUnit() {
		if (isChanged(organizationUnit)) {
			return (OrganizationUnitView) getReferenceChangeValue(organizationUnit);
		} else {
			int id = organizationUnit.getValue(getId());
			if (id > 0) {
				return OrganizationUnitView.getById(id);
			} else {
				return null;
			}
		}
	}



    @Override
    public UdbUserView save() {
    	throw new UnsupportedOperationException();
    }

    @Override
    public void delete() {
    	throw new UnsupportedOperationException();
    }

    @Override
    public void restoreDeleted() {
    	throw new UnsupportedOperationException();
    }

	@Override
	public String toString() {
    	StringBuilder sb = new StringBuilder();
    	sb.append(table.getName()).append(": ").append(getId()).append("\n");
		for (ColumnIndex column : table.getColumnIndices()) {
			sb.append("\t").append(column.getName()).append(": ").append(column.getStringValue(getId()));
			if (isChanged(column)) {
			    TransactionRequestRecordValue changeValue = getChangeValue(column);
				sb.append(" -> ").append(changeValue.getValue());
			}
			sb.append("\n");
		}
		return sb.toString();
	}
}



