package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbUserViewQuery extends AbstractUdbQuery<UserView> implements UserViewQuery {

    public UdbUserViewQuery() {
        super(UdbUserView.table, UserView.getBuilder());
    }

    @Override
    public UserViewQuery id(Integer... ids) {
        return id(Arrays.asList(ids));
    }

    @Override
    public UserViewQuery id(BitSet ids) {
        filterById(ids);
        return this;
    }

    @Override
    public UserViewQuery id(Collection<Integer> ids) {
        filterById(ids);
        return this;
    }

	@Override
	public UserViewQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbUserView.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public UserViewQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbUserView.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public UserViewQuery firstName(TextFilter filter) {
		and(UdbUserView.firstName.createFilter(filter));
		return this;
	}

	@Override
	public UserViewQuery orFirstName(TextFilter filter) {
		or(UdbUserView.firstName.createFilter(filter));
		return this;
	}

	@Override
	public UserViewQuery firstNameTranslated(TextFilter filter) {
		and(UdbUserView.firstNameTranslated.createFilter(filter));
		return this;
	}

	@Override
	public UserViewQuery orFirstNameTranslated(TextFilter filter) {
		or(UdbUserView.firstNameTranslated.createFilter(filter));
		return this;
	}

	@Override
	public UserViewQuery lastName(TextFilter filter) {
		and(UdbUserView.lastName.createFilter(filter));
		return this;
	}

	@Override
	public UserViewQuery orLastName(TextFilter filter) {
		or(UdbUserView.lastName.createFilter(filter));
		return this;
	}

	@Override
	public UserViewQuery lastNameTranslated(TextFilter filter) {
		and(UdbUserView.lastNameTranslated.createFilter(filter));
		return this;
	}

	@Override
	public UserViewQuery orLastNameTranslated(TextFilter filter) {
		or(UdbUserView.lastNameTranslated.createFilter(filter));
		return this;
	}

	@Override
	public UserViewQuery profilePicture(BinaryFilter filter) {
		and(UdbUserView.profilePicture.createFilter(filter));
		return this;
	}

	@Override
	public UserViewQuery orProfilePicture(BinaryFilter filter) {
		or(UdbUserView.profilePicture.createFilter(filter));
		return this;
	}

	@Override
	public UserViewQuery profilePictureLarge(BinaryFilter filter) {
		and(UdbUserView.profilePictureLarge.createFilter(filter));
		return this;
	}

	@Override
	public UserViewQuery orProfilePictureLarge(BinaryFilter filter) {
		or(UdbUserView.profilePictureLarge.createFilter(filter));
		return this;
	}

	@Override
	public UserViewQuery language(TextFilter filter) {
		and(UdbUserView.language.createFilter(filter));
		return this;
	}

	@Override
	public UserViewQuery orLanguage(TextFilter filter) {
		or(UdbUserView.language.createFilter(filter));
		return this;
	}

	@Override
	public UserViewQuery filterOrganizationUnit(OrganizationUnitViewQuery query) {
		UdbOrganizationUnitViewQuery udbQuery = (UdbOrganizationUnitViewQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbUserView.organizationUnit);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public UserViewQuery organizationUnit(NumericFilter filter) {
		and(UdbUserView.organizationUnit.createFilter(filter));
		return this;
	}

	@Override
	public UserViewQuery orOrganizationUnit(NumericFilter filter) {
		or(UdbUserView.organizationUnit.createFilter(filter));
		return this;
	}


	@Override
	public UdbUserViewQuery andOr(UserViewQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public UserViewQuery customFilter(Function<UserView, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(UserView.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



