package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbUserAccessToken extends AbstractUdbEntity<UserAccessToken> implements UserAccessToken {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static SingleReferenceIndex user;
	protected static TextIndex userAgentOnCreation;
	protected static TextIndex userAgentLastUsed;
	protected static IntegerIndex lastUsed;
	protected static BooleanIndex valid;
	protected static BooleanIndex restApi;
	protected static TextIndex secureToken;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_RESTORED_BY);
		user = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_USER);
		userAgentOnCreation = (TextIndex) tableIndex.getColumnIndex(FIELD_USER_AGENT_ON_CREATION);
		userAgentLastUsed = (TextIndex) tableIndex.getColumnIndex(FIELD_USER_AGENT_LAST_USED);
		lastUsed = (IntegerIndex) tableIndex.getColumnIndex(FIELD_LAST_USED);
		valid = (BooleanIndex) tableIndex.getColumnIndex(FIELD_VALID);
		restApi = (BooleanIndex) tableIndex.getColumnIndex(FIELD_REST_API);
		secureToken = (TextIndex) tableIndex.getColumnIndex(FIELD_SECURE_TOKEN);
    }

    public static List<UserAccessToken> getAll() {
        return new EntityBitSetList<>(UserAccessToken.getBuilder(), table.getRecordBitSet());
    }

    public static List<UserAccessToken> getDeletedRecords() {
        return new EntityBitSetList<>(UserAccessToken.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<UserAccessToken> sort(List<UserAccessToken> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<UserAccessToken> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, UserAccessToken.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbUserAccessToken() {
        super(table);
    }

    public UdbUserAccessToken(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public UserAccessToken build() {
        return new UdbUserAccessToken();
    }

    @Override
    public UserAccessToken build(int id) {
        return new UdbUserAccessToken(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public UserAccessToken setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public UserAccessToken setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public UserAccessToken setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public UserAccessToken setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public UserAccessToken setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public UserAccessToken setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public UserAccessToken setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public UserAccessToken setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public UserAccessToken setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public UserAccessToken setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public UserAccessToken setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public UserAccessToken setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public User getUser() {
		if (isChanged(user)) {
			return (User) getReferenceChangeValue(user);
		} else {
			int id = user.getValue(getId());
			if (id > 0) {
				return User.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public UserAccessToken setUser(User value) {
		setSingleReferenceValue(user, value, table);
		return this;
	}

	@Override
	public String getUserAgentOnCreation() {
        return getTextValue(userAgentOnCreation);
	}

	@Override
	public UserAccessToken setUserAgentOnCreation(String value) {
	    setTextValue(value, this.userAgentOnCreation);
		return this;
	}

	@Override
	public String getUserAgentLastUsed() {
        return getTextValue(userAgentLastUsed);
	}

	@Override
	public UserAccessToken setUserAgentLastUsed(String value) {
	    setTextValue(value, this.userAgentLastUsed);
		return this;
	}

	@Override
	public Instant getLastUsed() {
	    return getTimestampValue(lastUsed);
	}

	@Override
	public UserAccessToken setLastUsed(Instant value) {
	    setTimestampValue(value, this.lastUsed);
		return this;
	}

	@Override
	public int getLastUsedAsEpochSecond() {
	    return getTimestampAsEpochSecond(lastUsed);
	}

	@Override
	public UserAccessToken setLastUsedAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.lastUsed);
		return this;
	}

	@Override
	public long getLastUsedAsEpochMilli() {
	    return getTimestampAsEpochMilli(lastUsed);
	}

	@Override
	public UserAccessToken setLastUsedAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.lastUsed);
		return this;
	}

	@Override
	public boolean getValid() {
	    return getBooleanValue(valid);
	}

	@Override
	public UserAccessToken setValid(boolean value) {
	    setBooleanValue(value, this.valid);
		return this;
	}

	@Override
	public boolean isValid() {
	    return getBooleanValue(valid);
	}

	@Override
	public boolean getRestApi() {
	    return getBooleanValue(restApi);
	}

	@Override
	public UserAccessToken setRestApi(boolean value) {
	    setBooleanValue(value, this.restApi);
		return this;
	}

	@Override
	public boolean isRestApi() {
	    return getBooleanValue(restApi);
	}

	@Override
	public String getSecureToken() {
        return getTextValue(secureToken);
	}

	@Override
	public UserAccessToken setSecureToken(String value) {
	    setTextValue(value, this.secureToken);
		return this;
	}



    @Override
    public UdbUserAccessToken save() {
        saveRecord();
        return this;
    }

    @Override
    public void delete() {
        deleteRecord();
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord();
    }
}



