package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbUserQuery extends AbstractUdbQuery<User> implements UserQuery {

    public UdbUserQuery() {
        super(UdbUser.table, User.getBuilder());
    }

    @Override
    public UserQuery id(Integer... ids) {
        return id(Arrays.asList(ids));
    }

    @Override
    public UserQuery id(BitSet ids) {
        filterById(ids);
        return this;
    }

    @Override
    public UserQuery id(Collection<Integer> ids) {
        filterById(ids);
        return this;
    }

	@Override
	public UserQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbUser.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public UserQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbUser.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public UserQuery metaCreationDate(NumericFilter filter) {
		and(UdbUser.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbUser.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery metaCreatedBy(NumericFilter filter) {
		and(UdbUser.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbUser.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery metaModificationDate(NumericFilter filter) {
		and(UdbUser.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbUser.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery metaModifiedBy(NumericFilter filter) {
		and(UdbUser.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbUser.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery metaDeletionDate(NumericFilter filter) {
		and(UdbUser.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbUser.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery metaDeletedBy(NumericFilter filter) {
		and(UdbUser.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbUser.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery metaRestoreDate(NumericFilter filter) {
		and(UdbUser.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbUser.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery metaRestoredBy(NumericFilter filter) {
		and(UdbUser.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbUser.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery firstName(TextFilter filter) {
		and(UdbUser.firstName.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orFirstName(TextFilter filter) {
		or(UdbUser.firstName.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery firstNameTranslated(TextFilter filter) {
		and(UdbUser.firstNameTranslated.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orFirstNameTranslated(TextFilter filter) {
		or(UdbUser.firstNameTranslated.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery lastName(TextFilter filter) {
		and(UdbUser.lastName.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orLastName(TextFilter filter) {
		or(UdbUser.lastName.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery lastNameTranslated(TextFilter filter) {
		and(UdbUser.lastNameTranslated.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orLastNameTranslated(TextFilter filter) {
		or(UdbUser.lastNameTranslated.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery profilePicture(BinaryFilter filter) {
		and(UdbUser.profilePicture.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orProfilePicture(BinaryFilter filter) {
		or(UdbUser.profilePicture.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery profilePictureLarge(BinaryFilter filter) {
		and(UdbUser.profilePictureLarge.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orProfilePictureLarge(BinaryFilter filter) {
		or(UdbUser.profilePictureLarge.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery language(TextFilter filter) {
		and(UdbUser.language.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orLanguage(TextFilter filter) {
		or(UdbUser.language.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery email(TextFilter filter) {
		and(UdbUser.email.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orEmail(TextFilter filter) {
		or(UdbUser.email.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery mobile(TextFilter filter) {
		and(UdbUser.mobile.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orMobile(TextFilter filter) {
		or(UdbUser.mobile.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery phone(TextFilter filter) {
		and(UdbUser.phone.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orPhone(TextFilter filter) {
		or(UdbUser.phone.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery login(TextFilter filter) {
		and(UdbUser.login.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orLogin(TextFilter filter) {
		or(UdbUser.login.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery lastLogin(NumericFilter filter) {
		and(UdbUser.lastLogin.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orLastLogin(NumericFilter filter) {
		or(UdbUser.lastLogin.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery password(TextFilter filter) {
		and(UdbUser.password.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orPassword(TextFilter filter) {
		or(UdbUser.password.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery theme(TextFilter filter) {
		and(UdbUser.theme.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orTheme(TextFilter filter) {
		or(UdbUser.theme.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery darkTheme(BooleanFilter filter) {
		and(UdbUser.darkTheme.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orDarkTheme(BooleanFilter filter) {
		or(UdbUser.darkTheme.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery userAccountStatus(EnumFilterType filterType, UserAccountStatus... enums) {
		and(UdbUser.userAccountStatus.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public UserQuery orUserAccountStatus(EnumFilterType filterType, UserAccountStatus... enums) {
		or(UdbUser.userAccountStatus.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public UserQuery filterAcceptedPolicies(UserAcceptedPolicyQuery query) {
		UdbUserAcceptedPolicyQuery udbQuery = (UdbUserAcceptedPolicyQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbUser.acceptedPolicies);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public UserQuery acceptedPolicies(NumericFilter filter) {
		and(UdbUser.acceptedPolicies.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orAcceptedPolicies(NumericFilter filter) {
		or(UdbUser.acceptedPolicies.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery filterAddress(AddressQuery query) {
		UdbAddressQuery udbQuery = (UdbAddressQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbUser.address);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public UserQuery address(NumericFilter filter) {
		and(UdbUser.address.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orAddress(NumericFilter filter) {
		or(UdbUser.address.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery filterOrganizationUnit(OrganizationUnitQuery query) {
		UdbOrganizationUnitQuery udbQuery = (UdbOrganizationUnitQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbUser.organizationUnit, UdbOrganizationUnit.users);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public UserQuery organizationUnit(NumericFilter filter) {
		and(UdbUser.organizationUnit.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orOrganizationUnit(NumericFilter filter) {
		or(UdbUser.organizationUnit.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery filterAccessTokens(UserAccessTokenQuery query) {
		UdbUserAccessTokenQuery udbQuery = (UdbUserAccessTokenQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbUser.accessTokens, UdbUserAccessToken.user);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public UserQuery accessTokens(MultiReferenceFilterType type, UserAccessToken ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (UserAccessToken value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbUser.accessTokens.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery accessTokensCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbUser.accessTokens.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery accessTokens(MultiReferenceFilter filter) {
		and(UdbUser.accessTokens.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orAccessTokens(MultiReferenceFilter filter) {
		or(UdbUser.accessTokens.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery filterRoleAssignments(UserRoleAssignmentQuery query) {
		UdbUserRoleAssignmentQuery udbQuery = (UdbUserRoleAssignmentQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbUser.roleAssignments, UdbUserRoleAssignment.user);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public UserQuery roleAssignments(MultiReferenceFilterType type, UserRoleAssignment ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (UserRoleAssignment value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbUser.roleAssignments.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery roleAssignmentsCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbUser.roleAssignments.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery roleAssignments(MultiReferenceFilter filter) {
		and(UdbUser.roleAssignments.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orRoleAssignments(MultiReferenceFilter filter) {
		or(UdbUser.roleAssignments.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery filterLanguageSettings(UserLanguageSettingsQuery query) {
		UdbUserLanguageSettingsQuery udbQuery = (UdbUserLanguageSettingsQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbUser.languageSettings);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public UserQuery languageSettings(MultiReferenceFilterType type, UserLanguageSettings ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (UserLanguageSettings value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbUser.languageSettings.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery languageSettingsCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbUser.languageSettings.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery languageSettings(MultiReferenceFilter filter) {
		and(UdbUser.languageSettings.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orLanguageSettings(MultiReferenceFilter filter) {
		or(UdbUser.languageSettings.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery filterLoginStats(UserLoginStatsQuery query) {
		UdbUserLoginStatsQuery udbQuery = (UdbUserLoginStatsQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbUser.loginStats, UdbUserLoginStats.user);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public UserQuery loginStats(NumericFilter filter) {
		and(UdbUser.loginStats.createFilter(filter));
		return this;
	}

	@Override
	public UserQuery orLoginStats(NumericFilter filter) {
		or(UdbUser.loginStats.createFilter(filter));
		return this;
	}


	@Override
	public UdbUserQuery andOr(UserQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public UserQuery customFilter(Function<User, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(User.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



