package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.context.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface User extends Entity<User> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_FIRST_NAME = "firstName";
	final static String FIELD_FIRST_NAME_TRANSLATED = "firstNameTranslated";
	final static String FIELD_LAST_NAME = "lastName";
	final static String FIELD_LAST_NAME_TRANSLATED = "lastNameTranslated";
	final static String FIELD_PROFILE_PICTURE = "profilePicture";
	final static String FIELD_PROFILE_PICTURE_LARGE = "profilePictureLarge";
	final static String FIELD_LANGUAGE = "language";
	final static String FIELD_EMAIL = "email";
	final static String FIELD_MOBILE = "mobile";
	final static String FIELD_PHONE = "phone";
	final static String FIELD_LOGIN = "login";
	final static String FIELD_LAST_LOGIN = "lastLogin";
	final static String FIELD_PASSWORD = "password";
	final static String FIELD_THEME = "theme";
	final static String FIELD_DARK_THEME = "darkTheme";
	final static String FIELD_USER_ACCOUNT_STATUS = "userAccountStatus";
	final static String FIELD_ACCEPTED_POLICIES = "acceptedPolicies";
	final static String FIELD_ADDRESS = "address";
	final static String FIELD_ORGANIZATION_UNIT = "organizationUnit";
	final static String FIELD_ACCESS_TOKENS = "accessTokens";
	final static String FIELD_ROLE_ASSIGNMENTS = "roleAssignments";
	final static String FIELD_LANGUAGE_SETTINGS = "languageSettings";
	final static String FIELD_LOGIN_STATS = "loginStats";

    static User create() {
        return new UdbUser();
    }

    static User create(int id) {
        return new UdbUser(id, true);
    }

    static User getById(int id) {
        return new UdbUser(id, false);
    }

    static EntityBuilder<User> getBuilder() {
        return new UdbUser(0, false);
    }

    Instant getMetaCreationDate();

    User setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    User setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    User setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    User setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    User setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    User setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    User setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    User setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    User setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    User setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    User setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    User setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    User setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    User setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    User setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    User setMetaRestoredBy(int value);

    String getFirstName();

    User setFirstName(String value);

    String getFirstNameTranslated();

    User setFirstNameTranslated(String value);

    String getLastName();

    User setLastName(String value);

    String getLastNameTranslated();

    User setLastNameTranslated(String value);

    byte[] getProfilePicture();

    User setProfilePicture(byte[] value);

    int getProfilePictureLength();

    Supplier<InputStream> getProfilePictureInputStreamSupplier();

    byte[] getProfilePictureLarge();

    User setProfilePictureLarge(byte[] value);

    int getProfilePictureLargeLength();

    Supplier<InputStream> getProfilePictureLargeInputStreamSupplier();

    String getLanguage();

    User setLanguage(String value);

    String getEmail();

    User setEmail(String value);

    String getMobile();

    User setMobile(String value);

    String getPhone();

    User setPhone(String value);

    String getLogin();

    User setLogin(String value);

    Instant getLastLogin();

    User setLastLogin(Instant value);

    int getLastLoginAsEpochSecond();

    User setLastLoginAsEpochSecond(int value);

    long getLastLoginAsEpochMilli();

    User setLastLoginAsEpochMilli(long value);

    String getPassword();

    User setPassword(String value);

    String getTheme();

    User setTheme(String value);

    boolean getDarkTheme();

    User setDarkTheme(boolean value);

    boolean isDarkTheme();

    UserAccountStatus getUserAccountStatus();

    User setUserAccountStatus(UserAccountStatus value);

    UserAcceptedPolicy getAcceptedPolicies();

    User setAcceptedPolicies(UserAcceptedPolicy value);

    Address getAddress();

    User setAddress(Address value);

    OrganizationUnit getOrganizationUnit();

    User setOrganizationUnit(OrganizationUnit value);

    List<UserAccessToken> getAccessTokens();

    User setAccessTokens(List<UserAccessToken> value);

    int getAccessTokensCount();

    User setAccessTokens(UserAccessToken ... value);

    BitSet getAccessTokensAsBitSet();

    User addAccessTokens(List<UserAccessToken> value);

    User addAccessTokens(UserAccessToken ... value);

    User removeAccessTokens(List<UserAccessToken> value);

    User removeAccessTokens(UserAccessToken ... value);

    User removeAllAccessTokens();

    List<UserRoleAssignment> getRoleAssignments();

    User setRoleAssignments(List<UserRoleAssignment> value);

    int getRoleAssignmentsCount();

    User setRoleAssignments(UserRoleAssignment ... value);

    BitSet getRoleAssignmentsAsBitSet();

    User addRoleAssignments(List<UserRoleAssignment> value);

    User addRoleAssignments(UserRoleAssignment ... value);

    User removeRoleAssignments(List<UserRoleAssignment> value);

    User removeRoleAssignments(UserRoleAssignment ... value);

    User removeAllRoleAssignments();

    List<UserLanguageSettings> getLanguageSettings();

    User setLanguageSettings(List<UserLanguageSettings> value);

    int getLanguageSettingsCount();

    User setLanguageSettings(UserLanguageSettings ... value);

    BitSet getLanguageSettingsAsBitSet();

    User addLanguageSettings(List<UserLanguageSettings> value);

    User addLanguageSettings(UserLanguageSettings ... value);

    User removeLanguageSettings(List<UserLanguageSettings> value);

    User removeLanguageSettings(UserLanguageSettings ... value);

    User removeAllLanguageSettings();

    UserLoginStats getLoginStats();

    User setLoginStats(UserLoginStats value);


    static List<User> getAll() {
        return UdbUser.getAll();
    }

    static List<User> getDeletedRecords() {
        return UdbUser.getDeletedRecords();
    }

    static List<User> sort(List<User> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbUser.sort(list, sortFieldName, ascending, userContext, path);
    }

    static int getCount() {
        return UdbUser.getCount();
    }

    static UserQuery filter() {
        return new UdbUserQuery();
    }
}

