package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;
import org.teamapps.universaldb.index.transaction.request.*;


import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbAddressView extends AbstractUdbEntity<AddressView> implements AddressView {
	protected static TableIndex table;
	protected static TextIndex name;
	protected static TextIndex organisation;
	protected static TextIndex street;
	protected static TextIndex city;
	protected static TextIndex dependentLocality;
	protected static TextIndex state;
	protected static TextIndex postalCode;
	protected static TextIndex country;
	protected static FloatIndex latitude;
	protected static FloatIndex longitude;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		name = (TextIndex) tableIndex.getColumnIndex(FIELD_NAME);
		organisation = (TextIndex) tableIndex.getColumnIndex(FIELD_ORGANISATION);
		street = (TextIndex) tableIndex.getColumnIndex(FIELD_STREET);
		city = (TextIndex) tableIndex.getColumnIndex(FIELD_CITY);
		dependentLocality = (TextIndex) tableIndex.getColumnIndex(FIELD_DEPENDENT_LOCALITY);
		state = (TextIndex) tableIndex.getColumnIndex(FIELD_STATE);
		postalCode = (TextIndex) tableIndex.getColumnIndex(FIELD_POSTAL_CODE);
		country = (TextIndex) tableIndex.getColumnIndex(FIELD_COUNTRY);
		latitude = (FloatIndex) tableIndex.getColumnIndex(FIELD_LATITUDE);
		longitude = (FloatIndex) tableIndex.getColumnIndex(FIELD_LONGITUDE);
    }

    public static List<AddressView> getAll() {
        return new EntityBitSetList<>(AddressView.getBuilder(), table.getRecordBitSet());
    }

    public static List<AddressView> sort(List<AddressView> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<AddressView> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, AddressView.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbAddressView() {
        super(table);
    }

    public UdbAddressView(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public AddressView build() {
        return new UdbAddressView();
    }

    @Override
    public AddressView build(int id) {
        return new UdbAddressView(id, false);
    }

	@Override
	public String getName() {
        return getTextValue(name);
	}

	@Override
	public String getOrganisation() {
        return getTextValue(organisation);
	}

	@Override
	public String getStreet() {
        return getTextValue(street);
	}

	@Override
	public String getCity() {
        return getTextValue(city);
	}

	@Override
	public String getDependentLocality() {
        return getTextValue(dependentLocality);
	}

	@Override
	public String getState() {
        return getTextValue(state);
	}

	@Override
	public String getPostalCode() {
        return getTextValue(postalCode);
	}

	@Override
	public String getCountry() {
        return getTextValue(country);
	}

	@Override
	public float getLatitude() {
	    return getFloatValue(latitude);
	}

	@Override
	public float getLongitude() {
	    return getFloatValue(longitude);
	}



    @Override
    public UdbAddressView save() {
    	throw new UnsupportedOperationException();
    }

    @Override
    public void delete() {
    	throw new UnsupportedOperationException();
    }

    @Override
    public void restoreDeleted() {
    	throw new UnsupportedOperationException();
    }

	@Override
	public String toString() {
    	StringBuilder sb = new StringBuilder();
    	sb.append(table.getName()).append(": ").append(getId()).append("\n");
		for (ColumnIndex column : table.getColumnIndices()) {
			sb.append("\t").append(column.getName()).append(": ").append(column.getStringValue(getId()));
			if (isChanged(column)) {
			    TransactionRequestRecordValue changeValue = getChangeValue(column);
				sb.append(" -> ").append(changeValue.getValue());
			}
			sb.append("\n");
		}
		return sb.toString();
	}
}



