package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.context.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface UserLanguageSettings extends Entity<UserLanguageSettings> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_LANGUAGE = "language";
	final static String FIELD_LANGUAGE_SKILL_LEVEL = "languageSkillLevel";

    static UserLanguageSettings create() {
        return new UdbUserLanguageSettings();
    }

    static UserLanguageSettings create(int id) {
        return new UdbUserLanguageSettings(id, true);
    }

    static UserLanguageSettings getById(int id) {
        return new UdbUserLanguageSettings(id, false);
    }

    static EntityBuilder<UserLanguageSettings> getBuilder() {
        return new UdbUserLanguageSettings(0, false);
    }

    Instant getMetaCreationDate();

    UserLanguageSettings setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    UserLanguageSettings setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    UserLanguageSettings setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    UserLanguageSettings setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    UserLanguageSettings setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    UserLanguageSettings setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    UserLanguageSettings setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    UserLanguageSettings setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    UserLanguageSettings setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    UserLanguageSettings setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    UserLanguageSettings setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    UserLanguageSettings setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    UserLanguageSettings setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    UserLanguageSettings setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    UserLanguageSettings setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    UserLanguageSettings setMetaRestoredBy(int value);

    String getLanguage();

    UserLanguageSettings setLanguage(String value);

    LanguageSkillLevel getLanguageSkillLevel();

    UserLanguageSettings setLanguageSkillLevel(LanguageSkillLevel value);


    static List<UserLanguageSettings> getAll() {
        return UdbUserLanguageSettings.getAll();
    }

    static List<UserLanguageSettings> getDeletedRecords() {
        return UdbUserLanguageSettings.getDeletedRecords();
    }

    static List<UserLanguageSettings> sort(List<UserLanguageSettings> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbUserLanguageSettings.sort(list, sortFieldName, ascending, userContext, path);
    }

    static int getCount() {
        return UdbUserLanguageSettings.getCount();
    }

    static UserLanguageSettingsQuery filter() {
        return new UdbUserLanguageSettingsQuery();
    }
}

