/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.model.controlcenter;

import java.io.InputStream;
import java.util.List;
import java.util.function.Supplier;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.model.controlcenter.UdbUserView;
import org.teamapps.model.controlcenter.UdbUserViewQuery;
import org.teamapps.model.controlcenter.UserViewQuery;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.universaldb.record.EntityBuilder;

public interface UserView
extends Entity<UserView> {
    public static final String FIELD_FIRST_NAME = "firstName";
    public static final String FIELD_FIRST_NAME_TRANSLATED = "firstNameTranslated";
    public static final String FIELD_LAST_NAME = "lastName";
    public static final String FIELD_LAST_NAME_TRANSLATED = "lastNameTranslated";
    public static final String FIELD_PROFILE_PICTURE = "profilePicture";
    public static final String FIELD_PROFILE_PICTURE_LARGE = "profilePictureLarge";
    public static final String FIELD_LANGUAGE = "language";
    public static final String FIELD_ORGANIZATION_UNIT = "organizationUnit";

    public static UserView getById(int id) {
        return new UdbUserView(id, false);
    }

    public static EntityBuilder<UserView> getBuilder() {
        return new UdbUserView(0, false);
    }

    public String getFirstName();

    public String getFirstNameTranslated();

    public String getLastName();

    public String getLastNameTranslated();

    public byte[] getProfilePicture();

    public int getProfilePictureLength();

    public Supplier<InputStream> getProfilePictureInputStreamSupplier();

    public byte[] getProfilePictureLarge();

    public int getProfilePictureLargeLength();

    public Supplier<InputStream> getProfilePictureLargeInputStreamSupplier();

    public String getLanguage();

    public OrganizationUnitView getOrganizationUnit();

    public static List<UserView> getAll() {
        return UdbUserView.getAll();
    }

    public static List<UserView> sort(List<UserView> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbUserView.sort(list, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return UdbUserView.getCount();
    }

    public static UserViewQuery filter() {
        return new UdbUserViewQuery();
    }
}

