package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;
import org.teamapps.universaldb.index.transaction.request.*;


import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbOrganizationUnitTypeView extends AbstractUdbEntity<OrganizationUnitTypeView> implements OrganizationUnitTypeView {
	protected static TableIndex table;
	protected static UniversalDB universalDB;
	protected static TranslatableTextIndex name;
	protected static TranslatableTextIndex abbreviation;
	protected static TextIndex icon;
	protected static BooleanIndex translateOrganizationUnits;
	protected static BooleanIndex allowUserContainer;
	protected static SingleReferenceIndex defaultChildType;
	protected static MultiReferenceIndex possibleChildrenTypes;
	protected static ShortIndex geoLocationType;

    private static void setTableIndex(TableIndex tableIndex, UniversalDB udb) {
		universalDB = udb;
        table = tableIndex;
		name = (TranslatableTextIndex) tableIndex.getFieldIndex(FIELD_NAME);
		abbreviation = (TranslatableTextIndex) tableIndex.getFieldIndex(FIELD_ABBREVIATION);
		icon = (TextIndex) tableIndex.getFieldIndex(FIELD_ICON);
		translateOrganizationUnits = (BooleanIndex) tableIndex.getFieldIndex(FIELD_TRANSLATE_ORGANIZATION_UNITS);
		allowUserContainer = (BooleanIndex) tableIndex.getFieldIndex(FIELD_ALLOW_USER_CONTAINER);
		defaultChildType = (SingleReferenceIndex) tableIndex.getFieldIndex(FIELD_DEFAULT_CHILD_TYPE);
		possibleChildrenTypes = (MultiReferenceIndex) tableIndex.getFieldIndex(FIELD_POSSIBLE_CHILDREN_TYPES);
		geoLocationType = (ShortIndex) tableIndex.getFieldIndex(FIELD_GEO_LOCATION_TYPE);
    }

    public static List<OrganizationUnitTypeView> getAll() {
        return new EntityBitSetList<>(OrganizationUnitTypeView.getBuilder(), table.getRecordBitSet());
    }

    public static List<OrganizationUnitTypeView> sort(List<OrganizationUnitTypeView> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<OrganizationUnitTypeView> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, OrganizationUnitTypeView.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbOrganizationUnitTypeView() {
        super(table);
    }

    public UdbOrganizationUnitTypeView(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public OrganizationUnitTypeView build() {
        return new UdbOrganizationUnitTypeView();
    }

    @Override
    public OrganizationUnitTypeView build(int id) {
        return new UdbOrganizationUnitTypeView(id, false);
    }

	@Override
	public TranslatableText getName() {
	    return getTranslatableTextValue(this.name);
	}

	@Override
	public TranslatableText getAbbreviation() {
	    return getTranslatableTextValue(this.abbreviation);
	}

	@Override
	public String getIcon() {
        return getTextValue(icon);
	}

	@Override
	public boolean getTranslateOrganizationUnits() {
	    return getBooleanValue(translateOrganizationUnits);
	}

	@Override
	public boolean isTranslateOrganizationUnits() {
	    return getBooleanValue(translateOrganizationUnits);
	}

	@Override
	public boolean getAllowUserContainer() {
	    return getBooleanValue(allowUserContainer);
	}

	@Override
	public boolean isAllowUserContainer() {
	    return getBooleanValue(allowUserContainer);
	}

	@Override
	public OrganizationUnitTypeView getDefaultChildType() {
		if (isChanged(defaultChildType)) {
			return (OrganizationUnitTypeView) getReferenceChangeValue(defaultChildType);
		} else {
			int id = defaultChildType.getValue(getId());
			if (id > 0) {
				return OrganizationUnitTypeView.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public List<OrganizationUnitTypeView> getPossibleChildrenTypes() {
	    return getMultiReferenceValue(possibleChildrenTypes, OrganizationUnitTypeView.getBuilder());
	}

	@Override
	public int getPossibleChildrenTypesCount() {
	    return getMultiReferenceValueCount(possibleChildrenTypes, OrganizationUnitTypeView.getBuilder());
	}

	@Override
	public BitSet getPossibleChildrenTypesAsBitSet() {
	    return getMultiReferenceValueAsBitSet(possibleChildrenTypes, OrganizationUnitTypeView.getBuilder());
	}

	@Override
	public GeoLocationType getGeoLocationType() {
	    return getEnumValue(geoLocationType, GeoLocationType.values());
	}



    @Override
    public UdbOrganizationUnitTypeView save() {
    	throw new UnsupportedOperationException();
    }

    @Override
    public void delete() {
    	throw new UnsupportedOperationException();
    }

    @Override
    public void restoreDeleted() {
    	throw new UnsupportedOperationException();
    }

}



