package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbUserLoginStats extends AbstractUdbEntity<UserLoginStats> implements UserLoginStats {
	protected static TableIndex table;
	protected static UniversalDB universalDB;
	protected static SingleReferenceIndex user;
	protected static IntegerIndex firstLogin;
	protected static IntegerIndex lastLogin;
	protected static IntegerIndex loginCount;
	protected static IntegerIndex lastLoginIpAddress;
	protected static IntegerIndex wrongPasswordTimestamp;
	protected static IntegerIndex wrongPasswordIpAddress;
	protected static IntegerIndex wrongPasswordCount;

    private static void setTableIndex(TableIndex tableIndex, UniversalDB udb) {
		universalDB = udb;
        table = tableIndex;
		user = (SingleReferenceIndex) tableIndex.getFieldIndex(FIELD_USER);
		firstLogin = (IntegerIndex) tableIndex.getFieldIndex(FIELD_FIRST_LOGIN);
		lastLogin = (IntegerIndex) tableIndex.getFieldIndex(FIELD_LAST_LOGIN);
		loginCount = (IntegerIndex) tableIndex.getFieldIndex(FIELD_LOGIN_COUNT);
		lastLoginIpAddress = (IntegerIndex) tableIndex.getFieldIndex(FIELD_LAST_LOGIN_IP_ADDRESS);
		wrongPasswordTimestamp = (IntegerIndex) tableIndex.getFieldIndex(FIELD_WRONG_PASSWORD_TIMESTAMP);
		wrongPasswordIpAddress = (IntegerIndex) tableIndex.getFieldIndex(FIELD_WRONG_PASSWORD_IP_ADDRESS);
		wrongPasswordCount = (IntegerIndex) tableIndex.getFieldIndex(FIELD_WRONG_PASSWORD_COUNT);
    }

    public static List<UserLoginStats> getAll() {
        return new EntityBitSetList<>(UserLoginStats.getBuilder(), table.getRecordBitSet());
    }

    public static List<UserLoginStats> getDeletedRecords() {
        return new EntityBitSetList<>(UserLoginStats.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<UserLoginStats> sort(List<UserLoginStats> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<UserLoginStats> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, UserLoginStats.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbUserLoginStats() {
        super(table);
    }

    public UdbUserLoginStats(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public UserLoginStats build() {
        return new UdbUserLoginStats();
    }

    @Override
    public UserLoginStats build(int id) {
        return new UdbUserLoginStats(id, false);
    }

	@Override
	public User getUser() {
		if (isChanged(user)) {
			return (User) getReferenceChangeValue(user);
		} else {
			int id = user.getValue(getId());
			if (id > 0) {
				return User.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public UserLoginStats setUser(User value) {
		setSingleReferenceValue(user, value, table);
		return this;
	}

	@Override
	public Instant getFirstLogin() {
	    return getTimestampValue(firstLogin);
	}

	@Override
	public UserLoginStats setFirstLogin(Instant value) {
	    setTimestampValue(value, this.firstLogin);
		return this;
	}

	@Override
	public int getFirstLoginAsEpochSecond() {
	    return getTimestampAsEpochSecond(firstLogin);
	}

	@Override
	public UserLoginStats setFirstLoginAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.firstLogin);
		return this;
	}

	@Override
	public long getFirstLoginAsEpochMilli() {
	    return getTimestampAsEpochMilli(firstLogin);
	}

	@Override
	public UserLoginStats setFirstLoginAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.firstLogin);
		return this;
	}

	@Override
	public Instant getLastLogin() {
	    return getTimestampValue(lastLogin);
	}

	@Override
	public UserLoginStats setLastLogin(Instant value) {
	    setTimestampValue(value, this.lastLogin);
		return this;
	}

	@Override
	public int getLastLoginAsEpochSecond() {
	    return getTimestampAsEpochSecond(lastLogin);
	}

	@Override
	public UserLoginStats setLastLoginAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.lastLogin);
		return this;
	}

	@Override
	public long getLastLoginAsEpochMilli() {
	    return getTimestampAsEpochMilli(lastLogin);
	}

	@Override
	public UserLoginStats setLastLoginAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.lastLogin);
		return this;
	}

	@Override
	public int getLoginCount() {
        return getIntValue(loginCount);
	}

	@Override
	public UserLoginStats setLoginCount(int value) {
	    setIntValue(value, this.loginCount);
		return this;
	}

	@Override
	public Instant getLastLoginIpAddress() {
	    return getTimestampValue(lastLoginIpAddress);
	}

	@Override
	public UserLoginStats setLastLoginIpAddress(Instant value) {
	    setTimestampValue(value, this.lastLoginIpAddress);
		return this;
	}

	@Override
	public int getLastLoginIpAddressAsEpochSecond() {
	    return getTimestampAsEpochSecond(lastLoginIpAddress);
	}

	@Override
	public UserLoginStats setLastLoginIpAddressAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.lastLoginIpAddress);
		return this;
	}

	@Override
	public long getLastLoginIpAddressAsEpochMilli() {
	    return getTimestampAsEpochMilli(lastLoginIpAddress);
	}

	@Override
	public UserLoginStats setLastLoginIpAddressAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.lastLoginIpAddress);
		return this;
	}

	@Override
	public Instant getWrongPasswordTimestamp() {
	    return getTimestampValue(wrongPasswordTimestamp);
	}

	@Override
	public UserLoginStats setWrongPasswordTimestamp(Instant value) {
	    setTimestampValue(value, this.wrongPasswordTimestamp);
		return this;
	}

	@Override
	public int getWrongPasswordTimestampAsEpochSecond() {
	    return getTimestampAsEpochSecond(wrongPasswordTimestamp);
	}

	@Override
	public UserLoginStats setWrongPasswordTimestampAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.wrongPasswordTimestamp);
		return this;
	}

	@Override
	public long getWrongPasswordTimestampAsEpochMilli() {
	    return getTimestampAsEpochMilli(wrongPasswordTimestamp);
	}

	@Override
	public UserLoginStats setWrongPasswordTimestampAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.wrongPasswordTimestamp);
		return this;
	}

	@Override
	public Instant getWrongPasswordIpAddress() {
	    return getTimestampValue(wrongPasswordIpAddress);
	}

	@Override
	public UserLoginStats setWrongPasswordIpAddress(Instant value) {
	    setTimestampValue(value, this.wrongPasswordIpAddress);
		return this;
	}

	@Override
	public int getWrongPasswordIpAddressAsEpochSecond() {
	    return getTimestampAsEpochSecond(wrongPasswordIpAddress);
	}

	@Override
	public UserLoginStats setWrongPasswordIpAddressAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.wrongPasswordIpAddress);
		return this;
	}

	@Override
	public long getWrongPasswordIpAddressAsEpochMilli() {
	    return getTimestampAsEpochMilli(wrongPasswordIpAddress);
	}

	@Override
	public UserLoginStats setWrongPasswordIpAddressAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.wrongPasswordIpAddress);
		return this;
	}

	@Override
	public int getWrongPasswordCount() {
        return getIntValue(wrongPasswordCount);
	}

	@Override
	public UserLoginStats setWrongPasswordCount(int value) {
	    setIntValue(value, this.wrongPasswordCount);
		return this;
	}



    @Override
    public UdbUserLoginStats save() {
        saveRecord(universalDB);
        return this;
    }

    @Override
    public void delete() {
        deleteRecord(universalDB);
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord(universalDB);
    }
}



