package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;


public interface ApplicationPerspectiveQuery extends Query<ApplicationPerspective> {

    static ApplicationPerspectiveQuery create() {
        return new UdbApplicationPerspectiveQuery();
    }

    ApplicationPerspectiveQuery id(Integer... ids);

    ApplicationPerspectiveQuery id(BitSet ids);

    ApplicationPerspectiveQuery id(Collection<Integer> ids);

    ApplicationPerspectiveQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    ApplicationPerspectiveQuery parseFullTextFilter(String query, String... fieldNames);

	ApplicationPerspectiveQuery metaCreationDate(NumericFilter filter);

	ApplicationPerspectiveQuery orMetaCreationDate(NumericFilter filter);

	ApplicationPerspectiveQuery metaCreatedBy(NumericFilter filter);

	ApplicationPerspectiveQuery orMetaCreatedBy(NumericFilter filter);

	ApplicationPerspectiveQuery metaModificationDate(NumericFilter filter);

	ApplicationPerspectiveQuery orMetaModificationDate(NumericFilter filter);

	ApplicationPerspectiveQuery metaModifiedBy(NumericFilter filter);

	ApplicationPerspectiveQuery orMetaModifiedBy(NumericFilter filter);

	ApplicationPerspectiveQuery metaDeletionDate(NumericFilter filter);

	ApplicationPerspectiveQuery orMetaDeletionDate(NumericFilter filter);

	ApplicationPerspectiveQuery metaDeletedBy(NumericFilter filter);

	ApplicationPerspectiveQuery orMetaDeletedBy(NumericFilter filter);

	ApplicationPerspectiveQuery metaRestoreDate(NumericFilter filter);

	ApplicationPerspectiveQuery orMetaRestoreDate(NumericFilter filter);

	ApplicationPerspectiveQuery metaRestoredBy(NumericFilter filter);

	ApplicationPerspectiveQuery orMetaRestoredBy(NumericFilter filter);

	ApplicationPerspectiveQuery filterApplication(ApplicationQuery query);

	ApplicationPerspectiveQuery application(NumericFilter filter);

	ApplicationPerspectiveQuery orApplication(NumericFilter filter);

	ApplicationPerspectiveQuery name(TextFilter filter);

	ApplicationPerspectiveQuery orName(TextFilter filter);

	ApplicationPerspectiveQuery icon(TextFilter filter);

	ApplicationPerspectiveQuery orIcon(TextFilter filter);

	ApplicationPerspectiveQuery titleKey(TextFilter filter);

	ApplicationPerspectiveQuery orTitleKey(TextFilter filter);

	ApplicationPerspectiveQuery descriptionKey(TextFilter filter);

	ApplicationPerspectiveQuery orDescriptionKey(TextFilter filter);

	ApplicationPerspectiveQuery autoProvision(BooleanFilter filter);

	ApplicationPerspectiveQuery orAutoProvision(BooleanFilter filter);

	ApplicationPerspectiveQuery toolbarPerspectiveMenu(BooleanFilter filter);

	ApplicationPerspectiveQuery orToolbarPerspectiveMenu(BooleanFilter filter);

	ApplicationPerspectiveQuery filterManagedPerspectives(ManagedApplicationPerspectiveQuery query);

	ApplicationPerspectiveQuery managedPerspectives(MultiReferenceFilterType type, ManagedApplicationPerspective ... value);

	ApplicationPerspectiveQuery managedPerspectivesCount(MultiReferenceFilterType type, int count);

	ApplicationPerspectiveQuery managedPerspectives(MultiReferenceFilter filter);

	ApplicationPerspectiveQuery orManagedPerspectives(MultiReferenceFilter filter);


    ApplicationPerspectiveQuery andOr(ApplicationPerspectiveQuery... queries);

    ApplicationPerspectiveQuery customFilter(Function<ApplicationPerspective, Boolean> customFilter);

}

