package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbLocalizationKey extends AbstractUdbEntity<LocalizationKey> implements LocalizationKey {
	protected static TableIndex table;
	protected static UniversalDB universalDB;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static SingleReferenceIndex application;
	protected static TextIndex key;
	protected static BooleanIndex used;
	protected static ShortIndex localizationKeyFormat;
	protected static ShortIndex localizationKeyType;
	protected static TextIndex comments;
	protected static MultiReferenceIndex localizationValues;
	protected static MultiReferenceIndex topics;

    private static void setTableIndex(TableIndex tableIndex, UniversalDB udb) {
		universalDB = udb;
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_RESTORED_BY);
		application = (SingleReferenceIndex) tableIndex.getFieldIndex(FIELD_APPLICATION);
		key = (TextIndex) tableIndex.getFieldIndex(FIELD_KEY);
		used = (BooleanIndex) tableIndex.getFieldIndex(FIELD_USED);
		localizationKeyFormat = (ShortIndex) tableIndex.getFieldIndex(FIELD_LOCALIZATION_KEY_FORMAT);
		localizationKeyType = (ShortIndex) tableIndex.getFieldIndex(FIELD_LOCALIZATION_KEY_TYPE);
		comments = (TextIndex) tableIndex.getFieldIndex(FIELD_COMMENTS);
		localizationValues = (MultiReferenceIndex) tableIndex.getFieldIndex(FIELD_LOCALIZATION_VALUES);
		topics = (MultiReferenceIndex) tableIndex.getFieldIndex(FIELD_TOPICS);
    }

    public static List<LocalizationKey> getAll() {
        return new EntityBitSetList<>(LocalizationKey.getBuilder(), table.getRecordBitSet());
    }

    public static List<LocalizationKey> getDeletedRecords() {
        return new EntityBitSetList<>(LocalizationKey.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<LocalizationKey> sort(List<LocalizationKey> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<LocalizationKey> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, LocalizationKey.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbLocalizationKey() {
        super(table);
    }

    public UdbLocalizationKey(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public LocalizationKey build() {
        return new UdbLocalizationKey();
    }

    @Override
    public LocalizationKey build(int id) {
        return new UdbLocalizationKey(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public LocalizationKey setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public LocalizationKey setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public LocalizationKey setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public LocalizationKey setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public LocalizationKey setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public LocalizationKey setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public LocalizationKey setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public LocalizationKey setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public LocalizationKey setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public LocalizationKey setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public LocalizationKey setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public LocalizationKey setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public LocalizationKey setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public LocalizationKey setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public LocalizationKey setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public LocalizationKey setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public Application getApplication() {
		if (isChanged(application)) {
			return (Application) getReferenceChangeValue(application);
		} else {
			int id = application.getValue(getId());
			if (id > 0) {
				return Application.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public LocalizationKey setApplication(Application value) {
		setSingleReferenceValue(application, value, table);
		return this;
	}

	@Override
	public String getKey() {
        return getTextValue(key);
	}

	@Override
	public LocalizationKey setKey(String value) {
	    setTextValue(value, this.key);
		return this;
	}

	@Override
	public boolean getUsed() {
	    return getBooleanValue(used);
	}

	@Override
	public LocalizationKey setUsed(boolean value) {
	    setBooleanValue(value, this.used);
		return this;
	}

	@Override
	public boolean isUsed() {
	    return getBooleanValue(used);
	}

	@Override
	public LocalizationKeyFormat getLocalizationKeyFormat() {
	    return getEnumValue(localizationKeyFormat, LocalizationKeyFormat.values());
	}

	@Override
	public LocalizationKey setLocalizationKeyFormat(LocalizationKeyFormat value) {
    	setEnumValue(this.localizationKeyFormat, value);
		return this;
	}

	@Override
	public LocalizationKeyType getLocalizationKeyType() {
	    return getEnumValue(localizationKeyType, LocalizationKeyType.values());
	}

	@Override
	public LocalizationKey setLocalizationKeyType(LocalizationKeyType value) {
    	setEnumValue(this.localizationKeyType, value);
		return this;
	}

	@Override
	public String getComments() {
        return getTextValue(comments);
	}

	@Override
	public LocalizationKey setComments(String value) {
	    setTextValue(value, this.comments);
		return this;
	}

	@Override
	public List<LocalizationValue> getLocalizationValues() {
	    return getMultiReferenceValue(localizationValues, LocalizationValue.getBuilder());
	}

	@Override
	public LocalizationKey setLocalizationValues(List<LocalizationValue> value) {
		setMultiReferenceValue(value, localizationValues);
		return this;
	}

	@Override
	public int getLocalizationValuesCount() {
	    return getMultiReferenceValueCount(localizationValues, LocalizationValue.getBuilder());
	}

	@Override
	public LocalizationKey setLocalizationValues(LocalizationValue ... value) {
		setMultiReferenceValue(Arrays.asList(value), localizationValues);
		return this;
	}

	@Override
	public BitSet getLocalizationValuesAsBitSet() {
	    return getMultiReferenceValueAsBitSet(localizationValues, LocalizationValue.getBuilder());
	}

	@Override
	public LocalizationKey addLocalizationValues(List<LocalizationValue> value) {
		addMultiReferenceValue(value, localizationValues);
		return this;
	}

	@Override
	public LocalizationKey addLocalizationValues(LocalizationValue ... value) {
		addMultiReferenceValue(Arrays.asList(value), localizationValues);
		return this;
	}

	@Override
	public LocalizationKey removeLocalizationValues(List<LocalizationValue> value) {
		removeMultiReferenceValue(value, localizationValues);
		return this;
	}

	@Override
	public LocalizationKey removeLocalizationValues(LocalizationValue ... value) {
		removeMultiReferenceValue(Arrays.asList(value), localizationValues);
		return this;
	}

	@Override
	public LocalizationKey removeAllLocalizationValues() {
		removeAllMultiReferenceValue(localizationValues);
		return this;
	}

	@Override
	public List<LocalizationTopic> getTopics() {
	    return getMultiReferenceValue(topics, LocalizationTopic.getBuilder());
	}

	@Override
	public LocalizationKey setTopics(List<LocalizationTopic> value) {
		setMultiReferenceValue(value, topics);
		return this;
	}

	@Override
	public int getTopicsCount() {
	    return getMultiReferenceValueCount(topics, LocalizationTopic.getBuilder());
	}

	@Override
	public LocalizationKey setTopics(LocalizationTopic ... value) {
		setMultiReferenceValue(Arrays.asList(value), topics);
		return this;
	}

	@Override
	public BitSet getTopicsAsBitSet() {
	    return getMultiReferenceValueAsBitSet(topics, LocalizationTopic.getBuilder());
	}

	@Override
	public LocalizationKey addTopics(List<LocalizationTopic> value) {
		addMultiReferenceValue(value, topics);
		return this;
	}

	@Override
	public LocalizationKey addTopics(LocalizationTopic ... value) {
		addMultiReferenceValue(Arrays.asList(value), topics);
		return this;
	}

	@Override
	public LocalizationKey removeTopics(List<LocalizationTopic> value) {
		removeMultiReferenceValue(value, topics);
		return this;
	}

	@Override
	public LocalizationKey removeTopics(LocalizationTopic ... value) {
		removeMultiReferenceValue(Arrays.asList(value), topics);
		return this;
	}

	@Override
	public LocalizationKey removeAllTopics() {
		removeAllMultiReferenceValue(topics);
		return this;
	}



    @Override
    public UdbLocalizationKey save() {
        saveRecord(universalDB);
        return this;
    }

    @Override
    public void delete() {
        deleteRecord(universalDB);
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord(universalDB);
    }
}



