package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbLocalizationKeyQuery extends AbstractUdbQuery<LocalizationKey> implements LocalizationKeyQuery {

    public UdbLocalizationKeyQuery() {
        super(UdbLocalizationKey.table, LocalizationKey.getBuilder());
    }

    @Override
    public LocalizationKeyQuery id(Integer... ids) {
        return id(Arrays.asList(ids));
    }

    @Override
    public LocalizationKeyQuery id(BitSet ids) {
        filterById(ids);
        return this;
    }

    @Override
    public LocalizationKeyQuery id(Collection<Integer> ids) {
        filterById(ids);
        return this;
    }

	@Override
	public LocalizationKeyQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbLocalizationKey.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public LocalizationKeyQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbLocalizationKey.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public LocalizationKeyQuery metaCreationDate(NumericFilter filter) {
		and(UdbLocalizationKey.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbLocalizationKey.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery metaCreatedBy(NumericFilter filter) {
		and(UdbLocalizationKey.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbLocalizationKey.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery metaModificationDate(NumericFilter filter) {
		and(UdbLocalizationKey.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbLocalizationKey.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery metaModifiedBy(NumericFilter filter) {
		and(UdbLocalizationKey.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbLocalizationKey.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery metaDeletionDate(NumericFilter filter) {
		and(UdbLocalizationKey.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbLocalizationKey.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery metaDeletedBy(NumericFilter filter) {
		and(UdbLocalizationKey.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbLocalizationKey.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery metaRestoreDate(NumericFilter filter) {
		and(UdbLocalizationKey.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbLocalizationKey.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery metaRestoredBy(NumericFilter filter) {
		and(UdbLocalizationKey.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbLocalizationKey.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery filterApplication(ApplicationQuery query) {
		UdbApplicationQuery udbQuery = (UdbApplicationQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbLocalizationKey.application);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public LocalizationKeyQuery application(NumericFilter filter) {
		and(UdbLocalizationKey.application.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery orApplication(NumericFilter filter) {
		or(UdbLocalizationKey.application.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery key(TextFilter filter) {
		and(UdbLocalizationKey.key.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery orKey(TextFilter filter) {
		or(UdbLocalizationKey.key.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery used(BooleanFilter filter) {
		and(UdbLocalizationKey.used.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery orUsed(BooleanFilter filter) {
		or(UdbLocalizationKey.used.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery localizationKeyFormat(EnumFilterType filterType, LocalizationKeyFormat... enums) {
		and(UdbLocalizationKey.localizationKeyFormat.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public LocalizationKeyQuery orLocalizationKeyFormat(EnumFilterType filterType, LocalizationKeyFormat... enums) {
		or(UdbLocalizationKey.localizationKeyFormat.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public LocalizationKeyQuery localizationKeyType(EnumFilterType filterType, LocalizationKeyType... enums) {
		and(UdbLocalizationKey.localizationKeyType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public LocalizationKeyQuery orLocalizationKeyType(EnumFilterType filterType, LocalizationKeyType... enums) {
		or(UdbLocalizationKey.localizationKeyType.createFilter(NumericFilter.createEnumFilter(filterType, enums)));
		return this;
	}

	@Override
	public LocalizationKeyQuery comments(TextFilter filter) {
		and(UdbLocalizationKey.comments.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery orComments(TextFilter filter) {
		or(UdbLocalizationKey.comments.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery filterLocalizationValues(LocalizationValueQuery query) {
		UdbLocalizationValueQuery udbQuery = (UdbLocalizationValueQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbLocalizationKey.localizationValues, UdbLocalizationValue.localizationKey);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public LocalizationKeyQuery localizationValues(MultiReferenceFilterType type, LocalizationValue ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (LocalizationValue value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbLocalizationKey.localizationValues.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery localizationValuesCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbLocalizationKey.localizationValues.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery localizationValues(MultiReferenceFilter filter) {
		and(UdbLocalizationKey.localizationValues.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery orLocalizationValues(MultiReferenceFilter filter) {
		or(UdbLocalizationKey.localizationValues.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery filterTopics(LocalizationTopicQuery query) {
		UdbLocalizationTopicQuery udbQuery = (UdbLocalizationTopicQuery) query;
		IndexPath path = new IndexPath();
		path.addPath(UdbLocalizationKey.topics, UdbLocalizationTopic.keys);
		udbQuery.prependPath(path);
		and(udbQuery);
		return this;
	}

	@Override
	public LocalizationKeyQuery topics(MultiReferenceFilterType type, LocalizationTopic ... values) {
		List<Integer> ids = new ArrayList<>();
		if (values != null) {
			for (LocalizationTopic value : values) {
				ids.add(value.getId());
			}
		}
		MultiReferenceFilter filter = MultiReferenceFilter.createFilter(type, ids);
		and(UdbLocalizationKey.topics.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery topicsCount(MultiReferenceFilterType type, int count) {
		MultiReferenceFilter filter = MultiReferenceFilter.createCountFilter(type, count);
		and(UdbLocalizationKey.topics.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery topics(MultiReferenceFilter filter) {
		and(UdbLocalizationKey.topics.createFilter(filter));
		return this;
	}

	@Override
	public LocalizationKeyQuery orTopics(MultiReferenceFilter filter) {
		or(UdbLocalizationKey.topics.createFilter(filter));
		return this;
	}


	@Override
	public UdbLocalizationKeyQuery andOr(LocalizationKeyQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public LocalizationKeyQuery customFilter(Function<LocalizationKey, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(LocalizationKey.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



