package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbManagedApplicationPerspective extends AbstractUdbEntity<ManagedApplicationPerspective> implements ManagedApplicationPerspective {
	protected static TableIndex table;
	protected static UniversalDB universalDB;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static SingleReferenceIndex managedApplication;
	protected static SingleReferenceIndex applicationPerspective;
	protected static TextIndex iconOverride;
	protected static TextIndex titleKeyOverride;
	protected static TextIndex descriptionKeyOverride;
	protected static BooleanIndex toolbarPerspectiveMenu;
	protected static IntegerIndex listingPosition;

    private static void setTableIndex(TableIndex tableIndex, UniversalDB udb) {
		universalDB = udb;
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_RESTORED_BY);
		managedApplication = (SingleReferenceIndex) tableIndex.getFieldIndex(FIELD_MANAGED_APPLICATION);
		applicationPerspective = (SingleReferenceIndex) tableIndex.getFieldIndex(FIELD_APPLICATION_PERSPECTIVE);
		iconOverride = (TextIndex) tableIndex.getFieldIndex(FIELD_ICON_OVERRIDE);
		titleKeyOverride = (TextIndex) tableIndex.getFieldIndex(FIELD_TITLE_KEY_OVERRIDE);
		descriptionKeyOverride = (TextIndex) tableIndex.getFieldIndex(FIELD_DESCRIPTION_KEY_OVERRIDE);
		toolbarPerspectiveMenu = (BooleanIndex) tableIndex.getFieldIndex(FIELD_TOOLBAR_PERSPECTIVE_MENU);
		listingPosition = (IntegerIndex) tableIndex.getFieldIndex(FIELD_LISTING_POSITION);
    }

    public static List<ManagedApplicationPerspective> getAll() {
        return new EntityBitSetList<>(ManagedApplicationPerspective.getBuilder(), table.getRecordBitSet());
    }

    public static List<ManagedApplicationPerspective> getDeletedRecords() {
        return new EntityBitSetList<>(ManagedApplicationPerspective.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<ManagedApplicationPerspective> sort(List<ManagedApplicationPerspective> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<ManagedApplicationPerspective> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, ManagedApplicationPerspective.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbManagedApplicationPerspective() {
        super(table);
    }

    public UdbManagedApplicationPerspective(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public ManagedApplicationPerspective build() {
        return new UdbManagedApplicationPerspective();
    }

    @Override
    public ManagedApplicationPerspective build(int id) {
        return new UdbManagedApplicationPerspective(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public ManagedApplicationPerspective setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public ManagedApplicationPerspective setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public ManagedApplicationPerspective setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public ManagedApplicationPerspective setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public ManagedApplicationPerspective setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public ManagedApplicationPerspective setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public ManagedApplicationPerspective setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public ManagedApplicationPerspective setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public ManagedApplicationPerspective setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public ManagedApplicationPerspective setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public ManagedApplicationPerspective setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public ManagedApplicationPerspective setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public ManagedApplicationPerspective setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public ManagedApplicationPerspective setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public ManagedApplicationPerspective setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public ManagedApplicationPerspective setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public ManagedApplication getManagedApplication() {
		if (isChanged(managedApplication)) {
			return (ManagedApplication) getReferenceChangeValue(managedApplication);
		} else {
			int id = managedApplication.getValue(getId());
			if (id > 0) {
				return ManagedApplication.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public ManagedApplicationPerspective setManagedApplication(ManagedApplication value) {
		setSingleReferenceValue(managedApplication, value, table);
		return this;
	}

	@Override
	public ApplicationPerspective getApplicationPerspective() {
		if (isChanged(applicationPerspective)) {
			return (ApplicationPerspective) getReferenceChangeValue(applicationPerspective);
		} else {
			int id = applicationPerspective.getValue(getId());
			if (id > 0) {
				return ApplicationPerspective.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public ManagedApplicationPerspective setApplicationPerspective(ApplicationPerspective value) {
		setSingleReferenceValue(applicationPerspective, value, table);
		return this;
	}

	@Override
	public String getIconOverride() {
        return getTextValue(iconOverride);
	}

	@Override
	public ManagedApplicationPerspective setIconOverride(String value) {
	    setTextValue(value, this.iconOverride);
		return this;
	}

	@Override
	public String getTitleKeyOverride() {
        return getTextValue(titleKeyOverride);
	}

	@Override
	public ManagedApplicationPerspective setTitleKeyOverride(String value) {
	    setTextValue(value, this.titleKeyOverride);
		return this;
	}

	@Override
	public String getDescriptionKeyOverride() {
        return getTextValue(descriptionKeyOverride);
	}

	@Override
	public ManagedApplicationPerspective setDescriptionKeyOverride(String value) {
	    setTextValue(value, this.descriptionKeyOverride);
		return this;
	}

	@Override
	public boolean getToolbarPerspectiveMenu() {
	    return getBooleanValue(toolbarPerspectiveMenu);
	}

	@Override
	public ManagedApplicationPerspective setToolbarPerspectiveMenu(boolean value) {
	    setBooleanValue(value, this.toolbarPerspectiveMenu);
		return this;
	}

	@Override
	public boolean isToolbarPerspectiveMenu() {
	    return getBooleanValue(toolbarPerspectiveMenu);
	}

	@Override
	public int getListingPosition() {
        return getIntValue(listingPosition);
	}

	@Override
	public ManagedApplicationPerspective setListingPosition(int value) {
	    setIntValue(value, this.listingPosition);
		return this;
	}



    @Override
    public UdbManagedApplicationPerspective save() {
        saveRecord(universalDB);
        return this;
    }

    @Override
    public void delete() {
        deleteRecord(universalDB);
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord(universalDB);
    }
}



