package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


public class UdbNewsBoardMessageImageQuery extends AbstractUdbQuery<NewsBoardMessageImage> implements NewsBoardMessageImageQuery {

    public UdbNewsBoardMessageImageQuery() {
        super(UdbNewsBoardMessageImage.table, NewsBoardMessageImage.getBuilder());
    }

    @Override
    public NewsBoardMessageImageQuery id(Integer... ids) {
        return id(Arrays.asList(ids));
    }

    @Override
    public NewsBoardMessageImageQuery id(BitSet ids) {
        filterById(ids);
        return this;
    }

    @Override
    public NewsBoardMessageImageQuery id(Collection<Integer> ids) {
        filterById(ids);
        return this;
    }

	@Override
	public NewsBoardMessageImageQuery fullTextFilter(TextFilter textFilter, String... fieldNames) {
    	and(UdbNewsBoardMessageImage.table.createFullTextFilter(textFilter, fieldNames));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery parseFullTextFilter(String query, String... fieldNames) {
    	and(UdbNewsBoardMessageImage.table.createFullTextFilter(query, fieldNames));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery metaCreationDate(NumericFilter filter) {
		and(UdbNewsBoardMessageImage.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery orMetaCreationDate(NumericFilter filter) {
		or(UdbNewsBoardMessageImage.metaCreationDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery metaCreatedBy(NumericFilter filter) {
		and(UdbNewsBoardMessageImage.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery orMetaCreatedBy(NumericFilter filter) {
		or(UdbNewsBoardMessageImage.metaCreatedBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery metaModificationDate(NumericFilter filter) {
		and(UdbNewsBoardMessageImage.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery orMetaModificationDate(NumericFilter filter) {
		or(UdbNewsBoardMessageImage.metaModificationDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery metaModifiedBy(NumericFilter filter) {
		and(UdbNewsBoardMessageImage.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery orMetaModifiedBy(NumericFilter filter) {
		or(UdbNewsBoardMessageImage.metaModifiedBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery metaDeletionDate(NumericFilter filter) {
		and(UdbNewsBoardMessageImage.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery orMetaDeletionDate(NumericFilter filter) {
		or(UdbNewsBoardMessageImage.metaDeletionDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery metaDeletedBy(NumericFilter filter) {
		and(UdbNewsBoardMessageImage.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery orMetaDeletedBy(NumericFilter filter) {
		or(UdbNewsBoardMessageImage.metaDeletedBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery metaRestoreDate(NumericFilter filter) {
		and(UdbNewsBoardMessageImage.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery orMetaRestoreDate(NumericFilter filter) {
		or(UdbNewsBoardMessageImage.metaRestoreDate.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery metaRestoredBy(NumericFilter filter) {
		and(UdbNewsBoardMessageImage.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery orMetaRestoredBy(NumericFilter filter) {
		or(UdbNewsBoardMessageImage.metaRestoredBy.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery file(FileFilter filter) {
		and(UdbNewsBoardMessageImage.file.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery orFile(FileFilter filter) {
		or(UdbNewsBoardMessageImage.file.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery thumbnail(FileFilter filter) {
		and(UdbNewsBoardMessageImage.thumbnail.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery orThumbnail(FileFilter filter) {
		or(UdbNewsBoardMessageImage.thumbnail.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery fileName(TextFilter filter) {
		and(UdbNewsBoardMessageImage.fileName.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery orFileName(TextFilter filter) {
		or(UdbNewsBoardMessageImage.fileName.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery embedded(BooleanFilter filter) {
		and(UdbNewsBoardMessageImage.embedded.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery orEmbedded(BooleanFilter filter) {
		or(UdbNewsBoardMessageImage.embedded.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery position(NumericFilter filter) {
		and(UdbNewsBoardMessageImage.position.createFilter(filter));
		return this;
	}

	@Override
	public NewsBoardMessageImageQuery orPosition(NumericFilter filter) {
		or(UdbNewsBoardMessageImage.position.createFilter(filter));
		return this;
	}


	@Override
	public UdbNewsBoardMessageImageQuery andOr(NewsBoardMessageImageQuery ... queries) {
	    AbstractUdbQuery[] abstractUdbQueries = Arrays.copyOf(queries, queries.length, AbstractUdbQuery[].class);
		andOr(abstractUdbQueries);
		return this;
	}

    @Override
    public NewsBoardMessageImageQuery customFilter(Function<NewsBoardMessageImage, Boolean> customFilter) {
        Function<Integer, Boolean> filterFunction = id -> {
            return customFilter.apply(NewsBoardMessageImage.getById(id));
        };
        and(new CustomEntityFilter(filterFunction));
        return this;
    }

}



