package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.context.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface UserAccessToken extends Entity<UserAccessToken> {

	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_USER = "user";
	final static String FIELD_USER_AGENT_ON_CREATION = "userAgentOnCreation";
	final static String FIELD_USER_AGENT_LAST_USED = "userAgentLastUsed";
	final static String FIELD_LAST_USED = "lastUsed";
	final static String FIELD_VALID = "valid";
	final static String FIELD_REST_API = "restApi";
	final static String FIELD_SECURE_TOKEN = "secureToken";

    static UserAccessToken create() {
        return new UdbUserAccessToken();
    }

    static UserAccessToken create(int id) {
        return new UdbUserAccessToken(id, true);
    }

    static UserAccessToken getById(int id) {
        return new UdbUserAccessToken(id, false);
    }

    static EntityBuilder<UserAccessToken> getBuilder() {
        return new UdbUserAccessToken(0, false);
    }

    Instant getMetaDeletionDate();

    UserAccessToken setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    UserAccessToken setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    UserAccessToken setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    UserAccessToken setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    UserAccessToken setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    UserAccessToken setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    UserAccessToken setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    UserAccessToken setMetaRestoredBy(int value);

    User getUser();

    UserAccessToken setUser(User value);

    String getUserAgentOnCreation();

    UserAccessToken setUserAgentOnCreation(String value);

    String getUserAgentLastUsed();

    UserAccessToken setUserAgentLastUsed(String value);

    Instant getLastUsed();

    UserAccessToken setLastUsed(Instant value);

    int getLastUsedAsEpochSecond();

    UserAccessToken setLastUsedAsEpochSecond(int value);

    long getLastUsedAsEpochMilli();

    UserAccessToken setLastUsedAsEpochMilli(long value);

    boolean getValid();

    UserAccessToken setValid(boolean value);

    boolean isValid();

    boolean getRestApi();

    UserAccessToken setRestApi(boolean value);

    boolean isRestApi();

    String getSecureToken();

    UserAccessToken setSecureToken(String value);


    static List<UserAccessToken> getAll() {
        return UdbUserAccessToken.getAll();
    }

    static List<UserAccessToken> getDeletedRecords() {
        return UdbUserAccessToken.getDeletedRecords();
    }

    static List<UserAccessToken> sort(List<UserAccessToken> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbUserAccessToken.sort(list, sortFieldName, ascending, userContext, path);
    }

    static int getCount() {
        return UdbUserAccessToken.getCount();
    }

    static UserAccessTokenQuery filter() {
        return new UdbUserAccessTokenQuery();
    }
}

