package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;


public interface UserLanguageSettingsQuery extends Query<UserLanguageSettings> {

    static UserLanguageSettingsQuery create() {
        return new UdbUserLanguageSettingsQuery();
    }

    UserLanguageSettingsQuery id(Integer... ids);

    UserLanguageSettingsQuery id(BitSet ids);

    UserLanguageSettingsQuery id(Collection<Integer> ids);

    UserLanguageSettingsQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    UserLanguageSettingsQuery parseFullTextFilter(String query, String... fieldNames);

	UserLanguageSettingsQuery metaCreationDate(NumericFilter filter);

	UserLanguageSettingsQuery orMetaCreationDate(NumericFilter filter);

	UserLanguageSettingsQuery metaCreatedBy(NumericFilter filter);

	UserLanguageSettingsQuery orMetaCreatedBy(NumericFilter filter);

	UserLanguageSettingsQuery metaModificationDate(NumericFilter filter);

	UserLanguageSettingsQuery orMetaModificationDate(NumericFilter filter);

	UserLanguageSettingsQuery metaModifiedBy(NumericFilter filter);

	UserLanguageSettingsQuery orMetaModifiedBy(NumericFilter filter);

	UserLanguageSettingsQuery metaDeletionDate(NumericFilter filter);

	UserLanguageSettingsQuery orMetaDeletionDate(NumericFilter filter);

	UserLanguageSettingsQuery metaDeletedBy(NumericFilter filter);

	UserLanguageSettingsQuery orMetaDeletedBy(NumericFilter filter);

	UserLanguageSettingsQuery metaRestoreDate(NumericFilter filter);

	UserLanguageSettingsQuery orMetaRestoreDate(NumericFilter filter);

	UserLanguageSettingsQuery metaRestoredBy(NumericFilter filter);

	UserLanguageSettingsQuery orMetaRestoredBy(NumericFilter filter);

	UserLanguageSettingsQuery language(TextFilter filter);

	UserLanguageSettingsQuery orLanguage(TextFilter filter);

	UserLanguageSettingsQuery languageSkillLevel(EnumFilterType filterType, LanguageSkillLevel ... enums);

	UserLanguageSettingsQuery orLanguageSkillLevel(EnumFilterType filterType, LanguageSkillLevel ... enums);


    UserLanguageSettingsQuery andOr(UserLanguageSettingsQuery... queries);

    UserLanguageSettingsQuery customFilter(Function<UserLanguageSettings, Boolean> customFilter);

}

