package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.context.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface UserRoleAssignment extends Entity<UserRoleAssignment> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_META_RESTORE_DATE = "metaRestoreDate";
	final static String FIELD_META_RESTORED_BY = "metaRestoredBy";
	final static String FIELD_USER = "user";
	final static String FIELD_ROLE = "role";
	final static String FIELD_ORGANIZATION_UNIT = "organizationUnit";
	final static String FIELD_DELEGATED_CUSTOM_PRIVILEGE_OBJECT_ID = "delegatedCustomPrivilegeObjectId";
	final static String FIELD_MAIN_RESPONSIBLE = "mainResponsible";
	final static String FIELD_LAST_VERIFIED = "lastVerified";
	final static String FIELD_LAST_VERIFIED_BY = "lastVerifiedBy";

    static UserRoleAssignment create() {
        return new UdbUserRoleAssignment();
    }

    static UserRoleAssignment create(int id) {
        return new UdbUserRoleAssignment(id, true);
    }

    static UserRoleAssignment getById(int id) {
        return new UdbUserRoleAssignment(id, false);
    }

    static EntityBuilder<UserRoleAssignment> getBuilder() {
        return new UdbUserRoleAssignment(0, false);
    }

    Instant getMetaCreationDate();

    UserRoleAssignment setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    UserRoleAssignment setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    UserRoleAssignment setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    UserRoleAssignment setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    UserRoleAssignment setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    UserRoleAssignment setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    UserRoleAssignment setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    UserRoleAssignment setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    UserRoleAssignment setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    UserRoleAssignment setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    UserRoleAssignment setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    UserRoleAssignment setMetaDeletedBy(int value);

    Instant getMetaRestoreDate();

    UserRoleAssignment setMetaRestoreDate(Instant value);

    int getMetaRestoreDateAsEpochSecond();

    UserRoleAssignment setMetaRestoreDateAsEpochSecond(int value);

    long getMetaRestoreDateAsEpochMilli();

    UserRoleAssignment setMetaRestoreDateAsEpochMilli(long value);

    int getMetaRestoredBy();

    UserRoleAssignment setMetaRestoredBy(int value);

    User getUser();

    UserRoleAssignment setUser(User value);

    Role getRole();

    UserRoleAssignment setRole(Role value);

    OrganizationUnit getOrganizationUnit();

    UserRoleAssignment setOrganizationUnit(OrganizationUnit value);

    int getDelegatedCustomPrivilegeObjectId();

    UserRoleAssignment setDelegatedCustomPrivilegeObjectId(int value);

    boolean getMainResponsible();

    UserRoleAssignment setMainResponsible(boolean value);

    boolean isMainResponsible();

    Instant getLastVerified();

    UserRoleAssignment setLastVerified(Instant value);

    int getLastVerifiedAsEpochSecond();

    UserRoleAssignment setLastVerifiedAsEpochSecond(int value);

    long getLastVerifiedAsEpochMilli();

    UserRoleAssignment setLastVerifiedAsEpochMilli(long value);

    User getLastVerifiedBy();

    UserRoleAssignment setLastVerifiedBy(User value);


    static List<UserRoleAssignment> getAll() {
        return UdbUserRoleAssignment.getAll();
    }

    static List<UserRoleAssignment> getDeletedRecords() {
        return UdbUserRoleAssignment.getDeletedRecords();
    }

    static List<UserRoleAssignment> sort(List<UserRoleAssignment> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbUserRoleAssignment.sort(list, sortFieldName, ascending, userContext, path);
    }

    static int getCount() {
        return UdbUserRoleAssignment.getCount();
    }

    static UserRoleAssignmentQuery filter() {
        return new UdbUserRoleAssignmentQuery();
    }
}

