package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.context.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface UserView extends Entity<UserView> {

	final static String FIELD_FIRST_NAME = "firstName";
	final static String FIELD_FIRST_NAME_TRANSLATED = "firstNameTranslated";
	final static String FIELD_LAST_NAME = "lastName";
	final static String FIELD_LAST_NAME_TRANSLATED = "lastNameTranslated";
	final static String FIELD_PROFILE_PICTURE = "profilePicture";
	final static String FIELD_PROFILE_PICTURE_LARGE = "profilePictureLarge";
	final static String FIELD_LANGUAGE = "language";
	final static String FIELD_ORGANIZATION_UNIT = "organizationUnit";

    static UserView getById(int id) {
        return new UdbUserView(id, false);
    }

    static EntityBuilder<UserView> getBuilder() {
        return new UdbUserView(0, false);
    }

    String getFirstName();

    String getFirstNameTranslated();

    String getLastName();

    String getLastNameTranslated();

    byte[] getProfilePicture();

    int getProfilePictureLength();

    Supplier<InputStream> getProfilePictureInputStreamSupplier();

    byte[] getProfilePictureLarge();

    int getProfilePictureLargeLength();

    Supplier<InputStream> getProfilePictureLargeInputStreamSupplier();

    String getLanguage();

    OrganizationUnitView getOrganizationUnit();


    static List<UserView> getAll() {
        return UdbUserView.getAll();
    }

    static List<UserView> sort(List<UserView> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbUserView.sort(list, sortFieldName, ascending, userContext, path);
    }

    static int getCount() {
        return UdbUserView.getCount();
    }

    static UserViewQuery filter() {
        return new UdbUserViewQuery();
    }
}

