package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.enumeration.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.reference.value.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.query.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.util.function.Function;


public interface UserViewQuery extends Query<UserView> {

    static UserViewQuery create() {
        return new UdbUserViewQuery();
    }

    UserViewQuery id(Integer... ids);

    UserViewQuery id(BitSet ids);

    UserViewQuery id(Collection<Integer> ids);

    UserViewQuery fullTextFilter(TextFilter textFilter, String... fieldNames);

    UserViewQuery parseFullTextFilter(String query, String... fieldNames);

	UserViewQuery firstName(TextFilter filter);

	UserViewQuery orFirstName(TextFilter filter);

	UserViewQuery firstNameTranslated(TextFilter filter);

	UserViewQuery orFirstNameTranslated(TextFilter filter);

	UserViewQuery lastName(TextFilter filter);

	UserViewQuery orLastName(TextFilter filter);

	UserViewQuery lastNameTranslated(TextFilter filter);

	UserViewQuery orLastNameTranslated(TextFilter filter);

	UserViewQuery profilePicture(BinaryFilter filter);

	UserViewQuery orProfilePicture(BinaryFilter filter);

	UserViewQuery profilePictureLarge(BinaryFilter filter);

	UserViewQuery orProfilePictureLarge(BinaryFilter filter);

	UserViewQuery language(TextFilter filter);

	UserViewQuery orLanguage(TextFilter filter);

	UserViewQuery filterOrganizationUnit(OrganizationUnitViewQuery query);

	UserViewQuery organizationUnit(NumericFilter filter);

	UserViewQuery orOrganizationUnit(NumericFilter filter);


    UserViewQuery andOr(UserViewQuery... queries);

    UserViewQuery customFilter(Function<UserView, Boolean> customFilter);

}

