/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.model.controlcenter;

import java.time.Instant;
import java.util.BitSet;
import java.util.List;
import org.teamapps.model.controlcenter.User;
import org.teamapps.model.controlcenter.UserLoginStats;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.FieldIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.EntityBitSetList;

public class UdbUserLoginStats
extends AbstractUdbEntity<UserLoginStats>
implements UserLoginStats {
    protected static TableIndex table;
    protected static UniversalDB universalDB;
    protected static SingleReferenceIndex user;
    protected static IntegerIndex firstLogin;
    protected static IntegerIndex lastLogin;
    protected static IntegerIndex loginCount;
    protected static IntegerIndex lastLoginIpAddress;
    protected static IntegerIndex wrongPasswordTimestamp;
    protected static IntegerIndex wrongPasswordIpAddress;
    protected static IntegerIndex wrongPasswordCount;

    private static void setTableIndex(TableIndex tableIndex, UniversalDB udb) {
        universalDB = udb;
        table = tableIndex;
        user = (SingleReferenceIndex)tableIndex.getFieldIndex("user");
        firstLogin = (IntegerIndex)tableIndex.getFieldIndex("firstLogin");
        lastLogin = (IntegerIndex)tableIndex.getFieldIndex("lastLogin");
        loginCount = (IntegerIndex)tableIndex.getFieldIndex("loginCount");
        lastLoginIpAddress = (IntegerIndex)tableIndex.getFieldIndex("lastLoginIpAddress");
        wrongPasswordTimestamp = (IntegerIndex)tableIndex.getFieldIndex("wrongPasswordTimestamp");
        wrongPasswordIpAddress = (IntegerIndex)tableIndex.getFieldIndex("wrongPasswordIpAddress");
        wrongPasswordCount = (IntegerIndex)tableIndex.getFieldIndex("wrongPasswordCount");
    }

    public static List<UserLoginStats> getAll() {
        return new EntityBitSetList(UserLoginStats.getBuilder(), table.getRecordBitSet());
    }

    public static List<UserLoginStats> getDeletedRecords() {
        return new EntityBitSetList(UserLoginStats.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<UserLoginStats> sort(List<UserLoginStats> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbUserLoginStats.sort((TableIndex)table, list, (String)sortFieldName, (boolean)ascending, (UserContext)userContext, (String[])path);
    }

    public static List<UserLoginStats> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return UdbUserLoginStats.sort((TableIndex)table, UserLoginStats.getBuilder(), (BitSet)recordIds, (String)sortFieldName, (boolean)ascending, (UserContext)userContext, (String[])path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbUserLoginStats() {
        super(table);
    }

    public UdbUserLoginStats(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    public UserLoginStats build() {
        return new UdbUserLoginStats();
    }

    public UserLoginStats build(int id) {
        return new UdbUserLoginStats(id, false);
    }

    @Override
    public User getUser() {
        if (this.isChanged((FieldIndex)user)) {
            return (User)this.getReferenceChangeValue((FieldIndex)user);
        }
        int id = user.getValue(this.getId());
        if (id > 0) {
            return User.getById(id);
        }
        return null;
    }

    @Override
    public UserLoginStats setUser(User value) {
        this.setSingleReferenceValue(user, value, table);
        return this;
    }

    @Override
    public Instant getFirstLogin() {
        return this.getTimestampValue(firstLogin);
    }

    @Override
    public UserLoginStats setFirstLogin(Instant value) {
        this.setTimestampValue(value, firstLogin);
        return this;
    }

    @Override
    public int getFirstLoginAsEpochSecond() {
        return this.getTimestampAsEpochSecond(firstLogin);
    }

    @Override
    public UserLoginStats setFirstLoginAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, firstLogin);
        return this;
    }

    @Override
    public long getFirstLoginAsEpochMilli() {
        return this.getTimestampAsEpochMilli(firstLogin);
    }

    @Override
    public UserLoginStats setFirstLoginAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, firstLogin);
        return this;
    }

    @Override
    public Instant getLastLogin() {
        return this.getTimestampValue(lastLogin);
    }

    @Override
    public UserLoginStats setLastLogin(Instant value) {
        this.setTimestampValue(value, lastLogin);
        return this;
    }

    @Override
    public int getLastLoginAsEpochSecond() {
        return this.getTimestampAsEpochSecond(lastLogin);
    }

    @Override
    public UserLoginStats setLastLoginAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, lastLogin);
        return this;
    }

    @Override
    public long getLastLoginAsEpochMilli() {
        return this.getTimestampAsEpochMilli(lastLogin);
    }

    @Override
    public UserLoginStats setLastLoginAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, lastLogin);
        return this;
    }

    @Override
    public int getLoginCount() {
        return this.getIntValue(loginCount);
    }

    @Override
    public UserLoginStats setLoginCount(int value) {
        this.setIntValue(value, loginCount);
        return this;
    }

    @Override
    public Instant getLastLoginIpAddress() {
        return this.getTimestampValue(lastLoginIpAddress);
    }

    @Override
    public UserLoginStats setLastLoginIpAddress(Instant value) {
        this.setTimestampValue(value, lastLoginIpAddress);
        return this;
    }

    @Override
    public int getLastLoginIpAddressAsEpochSecond() {
        return this.getTimestampAsEpochSecond(lastLoginIpAddress);
    }

    @Override
    public UserLoginStats setLastLoginIpAddressAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, lastLoginIpAddress);
        return this;
    }

    @Override
    public long getLastLoginIpAddressAsEpochMilli() {
        return this.getTimestampAsEpochMilli(lastLoginIpAddress);
    }

    @Override
    public UserLoginStats setLastLoginIpAddressAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, lastLoginIpAddress);
        return this;
    }

    @Override
    public Instant getWrongPasswordTimestamp() {
        return this.getTimestampValue(wrongPasswordTimestamp);
    }

    @Override
    public UserLoginStats setWrongPasswordTimestamp(Instant value) {
        this.setTimestampValue(value, wrongPasswordTimestamp);
        return this;
    }

    @Override
    public int getWrongPasswordTimestampAsEpochSecond() {
        return this.getTimestampAsEpochSecond(wrongPasswordTimestamp);
    }

    @Override
    public UserLoginStats setWrongPasswordTimestampAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, wrongPasswordTimestamp);
        return this;
    }

    @Override
    public long getWrongPasswordTimestampAsEpochMilli() {
        return this.getTimestampAsEpochMilli(wrongPasswordTimestamp);
    }

    @Override
    public UserLoginStats setWrongPasswordTimestampAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, wrongPasswordTimestamp);
        return this;
    }

    @Override
    public Instant getWrongPasswordIpAddress() {
        return this.getTimestampValue(wrongPasswordIpAddress);
    }

    @Override
    public UserLoginStats setWrongPasswordIpAddress(Instant value) {
        this.setTimestampValue(value, wrongPasswordIpAddress);
        return this;
    }

    @Override
    public int getWrongPasswordIpAddressAsEpochSecond() {
        return this.getTimestampAsEpochSecond(wrongPasswordIpAddress);
    }

    @Override
    public UserLoginStats setWrongPasswordIpAddressAsEpochSecond(int value) {
        this.setTimestampAsEpochSecond(value, wrongPasswordIpAddress);
        return this;
    }

    @Override
    public long getWrongPasswordIpAddressAsEpochMilli() {
        return this.getTimestampAsEpochMilli(wrongPasswordIpAddress);
    }

    @Override
    public UserLoginStats setWrongPasswordIpAddressAsEpochMilli(long value) {
        this.setTimestampAsEpochMilli(value, wrongPasswordIpAddress);
        return this;
    }

    @Override
    public int getWrongPasswordCount() {
        return this.getIntValue(wrongPasswordCount);
    }

    @Override
    public UserLoginStats setWrongPasswordCount(int value) {
        this.setIntValue(value, wrongPasswordCount);
        return this;
    }

    public UdbUserLoginStats save() {
        this.saveRecord(universalDB);
        return this;
    }

    public void delete() {
        this.deleteRecord(universalDB);
    }

    public void restoreDeleted() {
        this.restoreDeletedRecord(universalDB);
    }
}

