package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.context.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbApplicationVersion extends AbstractUdbEntity<ApplicationVersion> implements ApplicationVersion {
	protected static TableIndex table;
	protected static UniversalDB universalDB;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static IntegerIndex metaRestoreDate;
	protected static IntegerIndex metaRestoredBy;
	protected static SingleReferenceIndex application;
	protected static FileIndex binary;
	protected static TextIndex binaryHash;
	protected static TextIndex version;
	protected static TextIndex releaseNotes;
	protected static SingleReferenceIndex dataModelData;
	protected static SingleReferenceIndex localizationData;
	protected static SingleReferenceIndex privilegeData;
	protected static SingleReferenceIndex perspectiveData;

    private static void setTableIndex(TableIndex tableIndex, UniversalDB udb) {
		universalDB = udb;
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_DELETED_BY);
		metaRestoreDate = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_RESTORE_DATE);
		metaRestoredBy = (IntegerIndex) tableIndex.getFieldIndex(FIELD_META_RESTORED_BY);
		application = (SingleReferenceIndex) tableIndex.getFieldIndex(FIELD_APPLICATION);
		binary = (FileIndex) tableIndex.getFieldIndex(FIELD_BINARY);
		binaryHash = (TextIndex) tableIndex.getFieldIndex(FIELD_BINARY_HASH);
		version = (TextIndex) tableIndex.getFieldIndex(FIELD_VERSION);
		releaseNotes = (TextIndex) tableIndex.getFieldIndex(FIELD_RELEASE_NOTES);
		dataModelData = (SingleReferenceIndex) tableIndex.getFieldIndex(FIELD_DATA_MODEL_DATA);
		localizationData = (SingleReferenceIndex) tableIndex.getFieldIndex(FIELD_LOCALIZATION_DATA);
		privilegeData = (SingleReferenceIndex) tableIndex.getFieldIndex(FIELD_PRIVILEGE_DATA);
		perspectiveData = (SingleReferenceIndex) tableIndex.getFieldIndex(FIELD_PERSPECTIVE_DATA);
    }

    public static List<ApplicationVersion> getAll() {
        return new EntityBitSetList<>(ApplicationVersion.getBuilder(), table.getRecordBitSet());
    }

    public static List<ApplicationVersion> getDeletedRecords() {
        return new EntityBitSetList<>(ApplicationVersion.getBuilder(), table.getDeletedRecordsBitSet());
    }

    public static List<ApplicationVersion> sort(List<ApplicationVersion> list, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
    	return sort(table, list, sortFieldName, ascending, userContext, path);
    }

    public static List<ApplicationVersion> sort(BitSet recordIds, String sortFieldName, boolean ascending, UserContext userContext, String ... path) {
        return sort(table, ApplicationVersion.getBuilder(), recordIds, sortFieldName, ascending, userContext, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbApplicationVersion() {
        super(table);
    }

    public UdbApplicationVersion(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public ApplicationVersion build() {
        return new UdbApplicationVersion();
    }

    @Override
    public ApplicationVersion build(int id) {
        return new UdbApplicationVersion(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public ApplicationVersion setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public ApplicationVersion setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public ApplicationVersion setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public ApplicationVersion setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public ApplicationVersion setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public ApplicationVersion setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public ApplicationVersion setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public ApplicationVersion setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public ApplicationVersion setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public ApplicationVersion setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public ApplicationVersion setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public ApplicationVersion setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Instant getMetaRestoreDate() {
	    return getTimestampValue(metaRestoreDate);
	}

	@Override
	public ApplicationVersion setMetaRestoreDate(Instant value) {
	    setTimestampValue(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoreDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaRestoreDate);
	}

	@Override
	public ApplicationVersion setMetaRestoreDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public long getMetaRestoreDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaRestoreDate);
	}

	@Override
	public ApplicationVersion setMetaRestoreDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaRestoreDate);
		return this;
	}

	@Override
	public int getMetaRestoredBy() {
        return getIntValue(metaRestoredBy);
	}

	@Override
	public ApplicationVersion setMetaRestoredBy(int value) {
	    setIntValue(value, this.metaRestoredBy);
		return this;
	}

	@Override
	public Application getApplication() {
		if (isChanged(application)) {
			return (Application) getReferenceChangeValue(application);
		} else {
			int id = application.getValue(getId());
			if (id > 0) {
				return Application.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public ApplicationVersion setApplication(Application value) {
		setSingleReferenceValue(application, value, table);
		return this;
	}

	@Override
	public FileValue getBinary() {
		if (isChanged(binary)) {
			return (FileValue) getChangedValue(binary);
		} else {
			return binary.getValue(getId());
		}
	}

	@Override
	public ApplicationVersion setBinary(File value) {
	    FileValue fileValue = createFileValue(value);
		setChangeValue(this.binary, fileValue, table);
		return this;
	}

	@Override
	public ApplicationVersion setBinary(File value, String fileName) {
	    FileValue fileValue = createFileValue(value, fileName);
		setChangeValue(this.binary, fileValue, table);
		return this;
	}

	@Override
	public String getBinaryHash() {
        return getTextValue(binaryHash);
	}

	@Override
	public ApplicationVersion setBinaryHash(String value) {
	    setTextValue(value, this.binaryHash);
		return this;
	}

	@Override
	public String getVersion() {
        return getTextValue(version);
	}

	@Override
	public ApplicationVersion setVersion(String value) {
	    setTextValue(value, this.version);
		return this;
	}

	@Override
	public String getReleaseNotes() {
        return getTextValue(releaseNotes);
	}

	@Override
	public ApplicationVersion setReleaseNotes(String value) {
	    setTextValue(value, this.releaseNotes);
		return this;
	}

	@Override
	public ApplicationVersionData getDataModelData() {
		if (isChanged(dataModelData)) {
			return (ApplicationVersionData) getReferenceChangeValue(dataModelData);
		} else {
			int id = dataModelData.getValue(getId());
			if (id > 0) {
				return ApplicationVersionData.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public ApplicationVersion setDataModelData(ApplicationVersionData value) {
		setSingleReferenceValue(dataModelData, value, table);
		return this;
	}

	@Override
	public ApplicationVersionData getLocalizationData() {
		if (isChanged(localizationData)) {
			return (ApplicationVersionData) getReferenceChangeValue(localizationData);
		} else {
			int id = localizationData.getValue(getId());
			if (id > 0) {
				return ApplicationVersionData.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public ApplicationVersion setLocalizationData(ApplicationVersionData value) {
		setSingleReferenceValue(localizationData, value, table);
		return this;
	}

	@Override
	public ApplicationVersionData getPrivilegeData() {
		if (isChanged(privilegeData)) {
			return (ApplicationVersionData) getReferenceChangeValue(privilegeData);
		} else {
			int id = privilegeData.getValue(getId());
			if (id > 0) {
				return ApplicationVersionData.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public ApplicationVersion setPrivilegeData(ApplicationVersionData value) {
		setSingleReferenceValue(privilegeData, value, table);
		return this;
	}

	@Override
	public ApplicationVersionData getPerspectiveData() {
		if (isChanged(perspectiveData)) {
			return (ApplicationVersionData) getReferenceChangeValue(perspectiveData);
		} else {
			int id = perspectiveData.getValue(getId());
			if (id > 0) {
				return ApplicationVersionData.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public ApplicationVersion setPerspectiveData(ApplicationVersionData value) {
		setSingleReferenceValue(perspectiveData, value, table);
		return this;
	}



    @Override
    public UdbApplicationVersion save() {
        saveRecord(universalDB);
        return this;
    }

    @Override
    public void delete() {
        deleteRecord(universalDB);
    }

    @Override
    public void restoreDeleted() {
        restoreDeletedRecord(universalDB);
    }
}



