/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icon.flags;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.icon.flags.FlagIcon;
import org.teamapps.icons.IconLoaderContext;
import org.teamapps.icons.IconResource;
import org.teamapps.icons.IconType;
import org.teamapps.icons.spi.IconLoader;

public class FlagIconLoader
implements IconLoader<FlagIcon> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IconResource loadIcon(FlagIcon icon, int size, IconLoaderContext iconLoaderContext) {
        try (InputStream inputStream = this.getClass().getResourceAsStream("/org/teamapps/icon/flags/" + icon.getIconName());){
            if (inputStream == null) {
                IconResource iconResource2 = null;
                return iconResource2;
            }
            IconResource iconResource = new IconResource(inputStream.readAllBytes(), IconType.SVG);
            return iconResource;
        }
        catch (IOException e) {
            LOGGER.error("Could not load icon " + icon.getIconName(), (Throwable)e);
            return null;
        }
    }
}

