/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icon.fontawesome;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.teamapps.common.format.Color;
import org.teamapps.icon.fontawesome.FontAwesomeIconStyles;
import org.teamapps.icon.fontawesome.SingleColorStyle;
import org.teamapps.icons.api.IconStyle;
import org.teamapps.icons.provider.SvgIconProvider;

public class FontAwesomeIconProvider
implements SvgIconProvider<IconStyle> {
    public static final String LIBRARY_ID = "fontawesome";
    private Map<String, SingleColorStyle> styleById = new HashMap<String, SingleColorStyle>();
    private Map<String, String> svgByStyleAndName = new HashMap<String, String>();

    public FontAwesomeIconProvider() {
        FontAwesomeIconStyles.getBaseStyles().forEach(this::addIconStyle);
    }

    public void addIconStyle(SingleColorStyle iconStyle) {
        this.styleById.put(iconStyle.getStyleId(), iconStyle);
    }

    public void addStyle(String styleId, Color color) {
        this.addIconStyle(new SingleColorStyle(styleId, color));
    }

    public String getInnerSvg(IconStyle style, String iconName) {
        return null;
    }

    public byte[] getIcon(String styleId, int size, String iconName) {
        String svg = this.getSVG(styleId, iconName);
        if (svg != null) {
            return svg.getBytes(StandardCharsets.UTF_8);
        }
        return null;
    }

    private String getSVG(String styleId, String iconName) {
        InputStream inputStream;
        SingleColorStyle iconStyle;
        if (!((String)iconName).endsWith(".svg")) {
            iconName = (String)iconName + ".svg";
        }
        if ((iconStyle = this.styleById.get(styleId)) == null) {
            iconStyle = this.styleById.get(this.getDefaultDesktopStyle().getStyleId());
        }
        if ((inputStream = this.getClass().getResourceAsStream("/org/teamapps/icon/fontawesome/" + (String)iconName)) == null) {
            return null;
        }
        try {
            String svg = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            svg = iconStyle.applyStyle(svg);
            return svg;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getIconLibraryId() {
        return LIBRARY_ID;
    }

    public Set<Integer> getAvailableIconSizes() {
        return null;
    }

    public Set<IconStyle> getAvailableIconStyles() {
        return new HashSet<IconStyle>(this.styleById.values());
    }

    public IconStyle getDefaultDesktopStyle() {
        return FontAwesomeIconStyles.BLUE_600;
    }

    public IconStyle getDefaultMobileStyle() {
        return FontAwesomeIconStyles.BLUE_600;
    }

    public IconStyle getDefaultSubIconStyle() {
        return FontAwesomeIconStyles.BLUE_600;
    }
}

