/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icon.fontawesome;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.teamapps.icon.fontawesome.FontAwesomeIcon;
import org.teamapps.icon.fontawesome.FontAwesomeIconStyle;
import org.teamapps.icons.IconLoaderContext;
import org.teamapps.icons.IconResource;
import org.teamapps.icons.IconType;
import org.teamapps.icons.spi.IconLoader;

public class FontAwesomeLoader
implements IconLoader<FontAwesomeIcon> {
    public IconResource loadIcon(FontAwesomeIcon icon, int size, IconLoaderContext context) {
        String svg = this.getSVG(icon.getName(), icon.getStyle());
        return svg != null ? new IconResource(svg.getBytes(StandardCharsets.UTF_8), IconType.SVG) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSVG(String iconName, FontAwesomeIconStyle style) {
        if (!((String)iconName).endsWith(".svg")) {
            iconName = (String)iconName + ".svg";
        }
        String path = "/org/teamapps/icon/fontawesome/" + (String)iconName;
        try (InputStream inputStream = this.getClass().getResourceAsStream(path);){
            if (inputStream == null) {
                String string2 = null;
                return string2;
            }
            String svg = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            String string = svg = style.applyStyle(svg);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

