/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icons;

import org.teamapps.icons.IconType;

public class IconResource {
    private final byte[] bytes;
    private final IconType iconType;
    private final int size;

    public IconResource(byte[] bytes, IconType iconType) {
        this(bytes, iconType, -1);
    }

    public IconResource(byte[] bytes, IconType iconType, int size) {
        this.bytes = bytes;
        this.iconType = iconType;
        this.size = size;
        if (iconType.isRasterImage() && size <= 0) {
            throw new IllegalArgumentException("iconSize is required for non-scalable icons.");
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public long getLength() {
        return this.bytes.length;
    }

    public IconType getIconType() {
        return this.iconType;
    }

    public String getMimeType() {
        return this.iconType.getMimeType();
    }

    public int getSize() {
        return this.size;
    }
}

